/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.ErrorEnclosed;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetReadAccessPropertyReadResult
implements Message {
    protected final BACnetTagHeader peekedTagHeader;
    protected final BACnetConstructedData propertyValue;
    protected final ErrorEnclosed propertyAccessError;
    protected final BACnetObjectType objectTypeArgument;
    protected final BACnetPropertyIdentifier propertyIdentifierArgument;
    protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    public BACnetReadAccessPropertyReadResult(BACnetTagHeader peekedTagHeader, BACnetConstructedData propertyValue, ErrorEnclosed propertyAccessError, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
        this.peekedTagHeader = peekedTagHeader;
        this.propertyValue = propertyValue;
        this.propertyAccessError = propertyAccessError;
        this.objectTypeArgument = objectTypeArgument;
        this.propertyIdentifierArgument = propertyIdentifierArgument;
        this.arrayIndexArgument = arrayIndexArgument;
    }

    public BACnetTagHeader getPeekedTagHeader() {
        return this.peekedTagHeader;
    }

    public BACnetConstructedData getPropertyValue() {
        return this.propertyValue;
    }

    public ErrorEnclosed getPropertyAccessError() {
        return this.propertyAccessError;
    }

    public short getPeekedTagNumber() {
        return this.getPeekedTagHeader().getActualTagNumber();
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetReadAccessPropertyReadResult", new WithWriterArgs[0]);
        short peekedTagNumber = this.getPeekedTagNumber();
        writeBuffer.writeVirtual("peekedTagNumber", (Object)peekedTagNumber, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"propertyValue", (Object)this.propertyValue, (DataWriter)new DataWriterComplexDefault(writeBuffer), (this.getPeekedTagNumber() == 4 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"propertyAccessError", (Object)this.propertyAccessError, (DataWriter)new DataWriterComplexDefault(writeBuffer), (this.getPeekedTagNumber() == 5 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetReadAccessPropertyReadResult", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetReadAccessPropertyReadResult _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.propertyValue != null) {
            lengthInBits += this.propertyValue.getLengthInBits();
        }
        if (this.propertyAccessError != null) {
            lengthInBits += this.propertyAccessError.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetReadAccessPropertyReadResult staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        BACnetPropertyIdentifier propertyIdentifierArgument;
        BACnetObjectType objectTypeArgument;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 3) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 3, but got " + args.length);
        }
        if (args[0] instanceof BACnetObjectType) {
            objectTypeArgument = (BACnetObjectType)((Object)args[0]);
        } else if (args[0] instanceof String) {
            objectTypeArgument = BACnetObjectType.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type BACnetObjectType or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof BACnetPropertyIdentifier) {
            propertyIdentifierArgument = (BACnetPropertyIdentifier)((Object)args[1]);
        } else if (args[1] instanceof String) {
            propertyIdentifierArgument = BACnetPropertyIdentifier.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type BACnetPropertyIdentifier or a string which is parseable but was " + args[1].getClass().getName());
        }
        if (!(args[2] instanceof BACnetTagPayloadUnsignedInteger)) {
            throw new PlcRuntimeException("Argument 2 expected to be of type BACnetTagPayloadUnsignedInteger or a string which is parseable but was " + args[2].getClass().getName());
        }
        BACnetTagPayloadUnsignedInteger arrayIndexArgument = (BACnetTagPayloadUnsignedInteger)args[2];
        return BACnetReadAccessPropertyReadResult.staticParse(readBuffer, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument);
    }

    public static BACnetReadAccessPropertyReadResult staticParse(ReadBuffer readBuffer, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) throws ParseException {
        readBuffer.pullContext("BACnetReadAccessPropertyReadResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader peekedTagHeader = (BACnetTagHeader)FieldReaderFactory.readPeekField((String)"peekedTagHeader", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short peekedTagNumber = (Short)FieldReaderFactory.readVirtualField((String)"peekedTagNumber", Short.TYPE, (Object)peekedTagHeader.getActualTagNumber(), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetConstructedData propertyValue = (BACnetConstructedData)FieldReaderFactory.readOptionalField((String)"propertyValue", (DataReader)new DataReaderComplexDefault(() -> BACnetConstructedData.staticParse(readBuffer, (short)4, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument), readBuffer), (peekedTagNumber == 4 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        if ((peekedTagNumber != 4 || propertyValue == null) && peekedTagNumber == 4) {
            throw new ParseValidationException("failure parsing field 4");
        }
        ErrorEnclosed propertyAccessError = (ErrorEnclosed)FieldReaderFactory.readOptionalField((String)"propertyAccessError", (DataReader)new DataReaderComplexDefault(() -> ErrorEnclosed.staticParse(readBuffer, (short)5), readBuffer), (peekedTagNumber == 5 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        if ((peekedTagNumber != 5 || propertyAccessError == null) && peekedTagNumber == 5) {
            throw new ParseValidationException("failure parsing field 5");
        }
        if (peekedTagNumber != 4 && peekedTagNumber != 5) {
            throw new ParseAssertException("should be either 4 or 5");
        }
        readBuffer.closeContext("BACnetReadAccessPropertyReadResult", new WithReaderArgs[0]);
        BACnetReadAccessPropertyReadResult _bACnetReadAccessPropertyReadResult = new BACnetReadAccessPropertyReadResult(peekedTagHeader, propertyValue, propertyAccessError, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument);
        return _bACnetReadAccessPropertyReadResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetReadAccessPropertyReadResult)) {
            return false;
        }
        BACnetReadAccessPropertyReadResult that = (BACnetReadAccessPropertyReadResult)o;
        return this.getPeekedTagHeader() == that.getPeekedTagHeader() && this.getPropertyValue() == that.getPropertyValue() && this.getPropertyAccessError() == that.getPropertyAccessError();
    }

    public int hashCode() {
        return Objects.hash(this.getPeekedTagHeader(), this.getPropertyValue(), this.getPropertyAccessError());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

