/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetRouterEntryStatusTagged;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetRouterEntry
implements Message {
    protected final BACnetContextTagUnsignedInteger networkNumber;
    protected final BACnetContextTagOctetString macAddress;
    protected final BACnetRouterEntryStatusTagged status;
    protected final BACnetContextTagOctetString performanceIndex;

    public BACnetRouterEntry(BACnetContextTagUnsignedInteger networkNumber, BACnetContextTagOctetString macAddress, BACnetRouterEntryStatusTagged status, BACnetContextTagOctetString performanceIndex) {
        this.networkNumber = networkNumber;
        this.macAddress = macAddress;
        this.status = status;
        this.performanceIndex = performanceIndex;
    }

    public BACnetContextTagUnsignedInteger getNetworkNumber() {
        return this.networkNumber;
    }

    public BACnetContextTagOctetString getMacAddress() {
        return this.macAddress;
    }

    public BACnetRouterEntryStatusTagged getStatus() {
        return this.status;
    }

    public BACnetContextTagOctetString getPerformanceIndex() {
        return this.performanceIndex;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetRouterEntry", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"networkNumber", (Object)this.networkNumber, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"macAddress", (Object)this.macAddress, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"status", (Object)this.status, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"performanceIndex", (Object)this.performanceIndex, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetRouterEntry", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetRouterEntry _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.networkNumber.getLengthInBits();
        lengthInBits += this.macAddress.getLengthInBits();
        lengthInBits += this.status.getLengthInBits();
        if (this.performanceIndex != null) {
            lengthInBits += this.performanceIndex.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetRouterEntry staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetRouterEntry.staticParse(readBuffer);
    }

    public static BACnetRouterEntry staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetRouterEntry", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetContextTagUnsignedInteger networkNumber = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readSimpleField((String)"networkNumber", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagOctetString macAddress = (BACnetContextTagOctetString)FieldReaderFactory.readSimpleField((String)"macAddress", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagOctetString)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.OCTET_STRING), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetRouterEntryStatusTagged status = (BACnetRouterEntryStatusTagged)FieldReaderFactory.readSimpleField((String)"status", (DataReader)new DataReaderComplexDefault(() -> BACnetRouterEntryStatusTagged.staticParse(readBuffer, (short)1, TagClass.CONTEXT_SPECIFIC_TAGS), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagOctetString performanceIndex = (BACnetContextTagOctetString)FieldReaderFactory.readOptionalField((String)"performanceIndex", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagOctetString)BACnetContextTag.staticParse(readBuffer, (short)3, BACnetDataType.OCTET_STRING), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetRouterEntry", new WithReaderArgs[0]);
        BACnetRouterEntry _bACnetRouterEntry = new BACnetRouterEntry(networkNumber, macAddress, status, performanceIndex);
        return _bACnetRouterEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetRouterEntry)) {
            return false;
        }
        BACnetRouterEntry that = (BACnetRouterEntry)o;
        return this.getNetworkNumber() == that.getNetworkNumber() && this.getMacAddress() == that.getMacAddress() && this.getStatus() == that.getStatus() && this.getPerformanceIndex() == that.getPerformanceIndex();
    }

    public int hashCode() {
        return Objects.hash(this.getNetworkNumber(), this.getMacAddress(), this.getStatus(), this.getPerformanceIndex());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

