/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckAtomicReadFile;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckAtomicWriteFile;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckAuthenticate;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckConfirmedPrivateTransfer;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckCreateObject;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckGetAlarmSummary;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckGetEnrollmentSummary;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckGetEventInformation;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckReadProperty;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckReadPropertyConditional;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckReadPropertyMultiple;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckReadRange;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckRequestKey;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckVTData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAckVTOpen;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class BACnetServiceAck
implements Message {
    protected final Long serviceAckLength;

    public abstract BACnetConfirmedServiceChoice getServiceChoice();

    public BACnetServiceAck(Long serviceAckLength) {
        this.serviceAckLength = serviceAckLength;
    }

    public long getServiceAckPayloadLength() {
        return this.serviceAckLength > 0L ? this.serviceAckLength - 1L : 0L;
    }

    protected abstract void serializeBACnetServiceAckChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetServiceAck", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorEnumField((String)"serviceChoice", (String)"BACnetConfirmedServiceChoice", (Object)((Object)this.getServiceChoice()), (DataWriter)new DataWriterEnumDefault(BACnetConfirmedServiceChoice::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        long serviceAckPayloadLength = this.getServiceAckPayloadLength();
        writeBuffer.writeVirtual("serviceAckPayloadLength", (Object)serviceAckPayloadLength, new WithWriterArgs[0]);
        this.serializeBACnetServiceAckChild(writeBuffer);
        writeBuffer.popContext("BACnetServiceAck", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetServiceAck _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += 8;
    }

    public static BACnetServiceAck staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Long serviceAckLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Long) {
            serviceAckLength = (Long)args[0];
        } else if (args[0] instanceof String) {
            serviceAckLength = Long.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Long or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetServiceAck.staticParse(readBuffer, serviceAckLength);
    }

    public static BACnetServiceAck staticParse(ReadBuffer readBuffer, Long serviceAckLength) throws ParseException {
        readBuffer.pullContext("BACnetServiceAck", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetConfirmedServiceChoice serviceChoice = (BACnetConfirmedServiceChoice)((Object)FieldReaderFactory.readDiscriminatorEnumField((String)"serviceChoice", (String)"BACnetConfirmedServiceChoice", (DataReader)new DataReaderEnumDefault(BACnetConfirmedServiceChoice::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        long serviceAckPayloadLength = (Long)FieldReaderFactory.readVirtualField((String)"serviceAckPayloadLength", Long.TYPE, (Object)(serviceAckLength > 0L ? serviceAckLength - 1L : 0L), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetServiceAckBuilder builder = null;
        if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.GET_ALARM_SUMMARY))) {
            builder = BACnetServiceAckGetAlarmSummary.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.GET_ENROLLMENT_SUMMARY))) {
            builder = BACnetServiceAckGetEnrollmentSummary.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.GET_EVENT_INFORMATION))) {
            builder = BACnetServiceAckGetEventInformation.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.ATOMIC_READ_FILE))) {
            builder = BACnetServiceAckAtomicReadFile.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.ATOMIC_WRITE_FILE))) {
            builder = BACnetServiceAckAtomicWriteFile.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.CREATE_OBJECT))) {
            builder = BACnetServiceAckCreateObject.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.READ_PROPERTY))) {
            builder = BACnetServiceAckReadProperty.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.READ_PROPERTY_MULTIPLE))) {
            builder = BACnetServiceAckReadPropertyMultiple.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckPayloadLength, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.READ_RANGE))) {
            builder = BACnetServiceAckReadRange.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.CONFIRMED_PRIVATE_TRANSFER))) {
            builder = BACnetServiceAckConfirmedPrivateTransfer.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.VT_OPEN))) {
            builder = BACnetServiceAckVTOpen.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.VT_DATA))) {
            builder = BACnetServiceAckVTData.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.AUTHENTICATE))) {
            builder = BACnetServiceAckAuthenticate.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckPayloadLength, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.REQUEST_KEY))) {
            builder = BACnetServiceAckRequestKey.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckPayloadLength, serviceAckLength);
        } else if (EvaluationHelper.equals((Object)((Object)serviceChoice), (Object)((Object)BACnetConfirmedServiceChoice.READ_PROPERTY_CONDITIONAL))) {
            builder = BACnetServiceAckReadPropertyConditional.staticParseBACnetServiceAckBuilder(readBuffer, serviceAckPayloadLength, serviceAckLength);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [serviceChoice=" + (Object)((Object)serviceChoice) + "]");
        }
        readBuffer.closeContext("BACnetServiceAck", new WithReaderArgs[0]);
        BACnetServiceAck _bACnetServiceAck = builder.build(serviceAckLength);
        return _bACnetServiceAck;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetServiceAck)) {
            return false;
        }
        BACnetServiceAck that = (BACnetServiceAck)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface BACnetServiceAckBuilder {
        public BACnetServiceAck build(Long var1);
    }
}

