/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAck;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetVendorIdTagged;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetServiceAckConfirmedPrivateTransfer
extends BACnetServiceAck
implements Message {
    protected final BACnetVendorIdTagged vendorId;
    protected final BACnetContextTagUnsignedInteger serviceNumber;
    protected final BACnetConstructedData resultBlock;
    protected final Long serviceAckLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.CONFIRMED_PRIVATE_TRANSFER;
    }

    public BACnetServiceAckConfirmedPrivateTransfer(BACnetVendorIdTagged vendorId, BACnetContextTagUnsignedInteger serviceNumber, BACnetConstructedData resultBlock, Long serviceAckLength) {
        super(serviceAckLength);
        this.vendorId = vendorId;
        this.serviceNumber = serviceNumber;
        this.resultBlock = resultBlock;
        this.serviceAckLength = serviceAckLength;
    }

    public BACnetVendorIdTagged getVendorId() {
        return this.vendorId;
    }

    public BACnetContextTagUnsignedInteger getServiceNumber() {
        return this.serviceNumber;
    }

    public BACnetConstructedData getResultBlock() {
        return this.resultBlock;
    }

    @Override
    protected void serializeBACnetServiceAckChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetServiceAckConfirmedPrivateTransfer", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"vendorId", (Object)this.vendorId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serviceNumber", (Object)this.serviceNumber, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"resultBlock", (Object)this.resultBlock, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetServiceAckConfirmedPrivateTransfer", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetServiceAckConfirmedPrivateTransfer _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.vendorId.getLengthInBits();
        lengthInBits += this.serviceNumber.getLengthInBits();
        if (this.resultBlock != null) {
            lengthInBits += this.resultBlock.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetServiceAck.BACnetServiceAckBuilder staticParseBACnetServiceAckBuilder(ReadBuffer readBuffer, Long serviceAckLength) throws ParseException {
        readBuffer.pullContext("BACnetServiceAckConfirmedPrivateTransfer", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetVendorIdTagged vendorId = (BACnetVendorIdTagged)FieldReaderFactory.readSimpleField((String)"vendorId", (DataReader)new DataReaderComplexDefault(() -> BACnetVendorIdTagged.staticParse(readBuffer, (short)0, TagClass.CONTEXT_SPECIFIC_TAGS), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagUnsignedInteger serviceNumber = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readSimpleField((String)"serviceNumber", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetConstructedData resultBlock = (BACnetConstructedData)FieldReaderFactory.readOptionalField((String)"resultBlock", (DataReader)new DataReaderComplexDefault(() -> BACnetConstructedData.staticParse(readBuffer, (short)2, BACnetObjectType.VENDOR_PROPRIETARY_VALUE, BACnetPropertyIdentifier.VENDOR_PROPRIETARY_VALUE, null), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetServiceAckConfirmedPrivateTransfer", new WithReaderArgs[0]);
        return new BACnetServiceAckConfirmedPrivateTransferBuilderImpl(vendorId, serviceNumber, resultBlock, serviceAckLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetServiceAckConfirmedPrivateTransfer)) {
            return false;
        }
        BACnetServiceAckConfirmedPrivateTransfer that = (BACnetServiceAckConfirmedPrivateTransfer)o;
        return this.getVendorId() == that.getVendorId() && this.getServiceNumber() == that.getServiceNumber() && this.getResultBlock() == that.getResultBlock() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getVendorId(), this.getServiceNumber(), this.getResultBlock());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetServiceAckConfirmedPrivateTransferBuilderImpl
    implements BACnetServiceAck.BACnetServiceAckBuilder {
        private final BACnetVendorIdTagged vendorId;
        private final BACnetContextTagUnsignedInteger serviceNumber;
        private final BACnetConstructedData resultBlock;
        private final Long serviceAckLength;

        public BACnetServiceAckConfirmedPrivateTransferBuilderImpl(BACnetVendorIdTagged vendorId, BACnetContextTagUnsignedInteger serviceNumber, BACnetConstructedData resultBlock, Long serviceAckLength) {
            this.vendorId = vendorId;
            this.serviceNumber = serviceNumber;
            this.resultBlock = resultBlock;
            this.serviceAckLength = serviceAckLength;
        }

        @Override
        public BACnetServiceAckConfirmedPrivateTransfer build(Long serviceAckLength) {
            BACnetServiceAckConfirmedPrivateTransfer bACnetServiceAckConfirmedPrivateTransfer = new BACnetServiceAckConfirmedPrivateTransfer(this.vendorId, this.serviceNumber, this.resultBlock, serviceAckLength);
            return bACnetServiceAckConfirmedPrivateTransfer;
        }
    }
}

