/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAck;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetServiceAckRequestKey
extends BACnetServiceAck
implements Message {
    protected final byte[] bytesOfRemovedService;
    protected final Long serviceAckPayloadLength;
    protected final Long serviceAckLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.REQUEST_KEY;
    }

    public BACnetServiceAckRequestKey(byte[] bytesOfRemovedService, Long serviceAckPayloadLength, Long serviceAckLength) {
        super(serviceAckLength);
        this.bytesOfRemovedService = bytesOfRemovedService;
        this.serviceAckPayloadLength = serviceAckPayloadLength;
        this.serviceAckLength = serviceAckLength;
    }

    public byte[] getBytesOfRemovedService() {
        return this.bytesOfRemovedService;
    }

    @Override
    protected void serializeBACnetServiceAckChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetServiceAckRequestKey", new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"bytesOfRemovedService", (byte[])this.bytesOfRemovedService, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetServiceAckRequestKey", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetServiceAckRequestKey _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.bytesOfRemovedService != null) {
            lengthInBits += 8 * this.bytesOfRemovedService.length;
        }
        return lengthInBits;
    }

    public static BACnetServiceAck.BACnetServiceAckBuilder staticParseBACnetServiceAckBuilder(ReadBuffer readBuffer, Long serviceAckPayloadLength, Long serviceAckLength) throws ParseException {
        readBuffer.pullContext("BACnetServiceAckRequestKey", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte[] bytesOfRemovedService = readBuffer.readByteArray("bytesOfRemovedService", Math.toIntExact(serviceAckPayloadLength), new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetServiceAckRequestKey", new WithReaderArgs[0]);
        return new BACnetServiceAckRequestKeyBuilderImpl(bytesOfRemovedService, serviceAckPayloadLength, serviceAckLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetServiceAckRequestKey)) {
            return false;
        }
        BACnetServiceAckRequestKey that = (BACnetServiceAckRequestKey)o;
        return this.getBytesOfRemovedService() == that.getBytesOfRemovedService() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBytesOfRemovedService());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetServiceAckRequestKeyBuilderImpl
    implements BACnetServiceAck.BACnetServiceAckBuilder {
        private final byte[] bytesOfRemovedService;
        private final Long serviceAckPayloadLength;
        private final Long serviceAckLength;

        public BACnetServiceAckRequestKeyBuilderImpl(byte[] bytesOfRemovedService, Long serviceAckPayloadLength, Long serviceAckLength) {
            this.bytesOfRemovedService = bytesOfRemovedService;
            this.serviceAckPayloadLength = serviceAckPayloadLength;
            this.serviceAckLength = serviceAckLength;
        }

        @Override
        public BACnetServiceAckRequestKey build(Long serviceAckLength) {
            BACnetServiceAckRequestKey bACnetServiceAckRequestKey = new BACnetServiceAckRequestKey(this.bytesOfRemovedService, this.serviceAckPayloadLength, serviceAckLength);
            return bACnetServiceAckRequestKey;
        }
    }
}

