/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetTagHeader
implements Message {
    protected final byte tagNumber;
    protected final TagClass tagClass;
    protected final byte lengthValueType;
    protected final Short extTagNumber;
    protected final Short extLength;
    protected final Integer extExtLength;
    protected final Long extExtExtLength;

    public BACnetTagHeader(byte tagNumber, TagClass tagClass, byte lengthValueType, Short extTagNumber, Short extLength, Integer extExtLength, Long extExtExtLength) {
        this.tagNumber = tagNumber;
        this.tagClass = tagClass;
        this.lengthValueType = lengthValueType;
        this.extTagNumber = extTagNumber;
        this.extLength = extLength;
        this.extExtLength = extExtLength;
        this.extExtExtLength = extExtExtLength;
    }

    public byte getTagNumber() {
        return this.tagNumber;
    }

    public TagClass getTagClass() {
        return this.tagClass;
    }

    public byte getLengthValueType() {
        return this.lengthValueType;
    }

    public Short getExtTagNumber() {
        return this.extTagNumber;
    }

    public Short getExtLength() {
        return this.extLength;
    }

    public Integer getExtExtLength() {
        return this.extExtLength;
    }

    public Long getExtExtExtLength() {
        return this.extExtExtLength;
    }

    public short getActualTagNumber() {
        return this.getTagNumber() < 15 ? this.getTagNumber() : this.getExtTagNumber().shortValue();
    }

    public boolean getIsBoolean() {
        return this.getTagNumber() == 1 && this.getTagClass() == TagClass.APPLICATION_TAGS;
    }

    public boolean getIsConstructed() {
        return this.getTagClass() == TagClass.CONTEXT_SPECIFIC_TAGS && this.getLengthValueType() == 6;
    }

    public boolean getIsPrimitiveAndNotBoolean() {
        return !this.getIsConstructed() && !this.getIsBoolean();
    }

    public long getActualLength() {
        return this.getLengthValueType() == 5 && this.getExtLength() == 255 ? this.getExtExtExtLength() : (long)(this.getLengthValueType() == 5 && this.getExtLength() == 254 ? (short)this.getExtExtLength().intValue() : (this.getLengthValueType() == 5 ? this.getExtLength().shortValue() : this.getLengthValueType()));
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetTagHeader", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"tagNumber", (Object)this.tagNumber, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"tagClass", (String)"TagClass", (Object)((Object)this.tagClass), (DataWriter)new DataWriterEnumDefault(TagClass::getValue, Enum::name, DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)1)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"lengthValueType", (Object)this.lengthValueType, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)3), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"extTagNumber", (Object)this.extTagNumber, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (this.getTagNumber() == 15 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        short actualTagNumber = this.getActualTagNumber();
        writeBuffer.writeVirtual("actualTagNumber", (Object)actualTagNumber, new WithWriterArgs[0]);
        boolean isBoolean = this.getIsBoolean();
        writeBuffer.writeVirtual("isBoolean", (Object)isBoolean, new WithWriterArgs[0]);
        boolean isConstructed = this.getIsConstructed();
        writeBuffer.writeVirtual("isConstructed", (Object)isConstructed, new WithWriterArgs[0]);
        boolean isPrimitiveAndNotBoolean = this.getIsPrimitiveAndNotBoolean();
        writeBuffer.writeVirtual("isPrimitiveAndNotBoolean", (Object)isPrimitiveAndNotBoolean, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"extLength", (Object)this.extLength, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (this.getIsPrimitiveAndNotBoolean() && this.getLengthValueType() == 5 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"extExtLength", (Object)this.extExtLength, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (this.getIsPrimitiveAndNotBoolean() && this.getLengthValueType() == 5 && this.getExtLength() == 254 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"extExtExtLength", (Object)this.extExtExtLength, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (this.getIsPrimitiveAndNotBoolean() && this.getLengthValueType() == 5 && this.getExtLength() == 255 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        long actualLength = this.getActualLength();
        writeBuffer.writeVirtual("actualLength", (Object)actualLength, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetTagHeader", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetTagHeader _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        ++lengthInBits;
        lengthInBits += 3;
        if (this.extTagNumber != null) {
            lengthInBits += 8;
        }
        if (this.extLength != null) {
            lengthInBits += 8;
        }
        if (this.extExtLength != null) {
            lengthInBits += 16;
        }
        if (this.extExtExtLength != null) {
            lengthInBits += 32;
        }
        return lengthInBits;
    }

    public static BACnetTagHeader staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetTagHeader.staticParse(readBuffer);
    }

    public static BACnetTagHeader staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetTagHeader", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short tagNumber = ((Byte)FieldReaderFactory.readSimpleField((String)"tagNumber", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (WithReaderArgs[])new WithReaderArgs[0])).byteValue();
        TagClass tagClass = (TagClass)((Object)FieldReaderFactory.readEnumField((String)"tagClass", (String)"TagClass", (DataReader)new DataReaderEnumDefault(TagClass::enumForValue, DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)1)), (WithReaderArgs[])new WithReaderArgs[0]));
        short lengthValueType = ((Byte)FieldReaderFactory.readSimpleField((String)"lengthValueType", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)3), (WithReaderArgs[])new WithReaderArgs[0])).byteValue();
        Short extTagNumber = (Short)FieldReaderFactory.readOptionalField((String)"extTagNumber", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (tagNumber == 15 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        short actualTagNumber = (Short)FieldReaderFactory.readVirtualField((String)"actualTagNumber", Short.TYPE, (Object)(tagNumber < 15 ? tagNumber : extTagNumber), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isBoolean = (Boolean)FieldReaderFactory.readVirtualField((String)"isBoolean", Boolean.TYPE, (Object)(tagNumber == 1 && tagClass == TagClass.APPLICATION_TAGS ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isConstructed = (Boolean)FieldReaderFactory.readVirtualField((String)"isConstructed", Boolean.TYPE, (Object)(tagClass == TagClass.CONTEXT_SPECIFIC_TAGS && lengthValueType == 6 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isPrimitiveAndNotBoolean = (Boolean)FieldReaderFactory.readVirtualField((String)"isPrimitiveAndNotBoolean", Boolean.TYPE, (Object)(!isConstructed && !isBoolean ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Short extLength = (Short)FieldReaderFactory.readOptionalField((String)"extLength", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (isPrimitiveAndNotBoolean && lengthValueType == 5 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        Integer extExtLength = (Integer)FieldReaderFactory.readOptionalField((String)"extExtLength", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (isPrimitiveAndNotBoolean && lengthValueType == 5 && extLength == 254 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        Long extExtExtLength = (Long)FieldReaderFactory.readOptionalField((String)"extExtExtLength", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (isPrimitiveAndNotBoolean && lengthValueType == 5 && extLength == 255 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        long actualLength = (Long)FieldReaderFactory.readVirtualField((String)"actualLength", Long.TYPE, (Object)(lengthValueType == 5 && extLength == 255 ? extExtExtLength : (long)(lengthValueType == 5 && extLength == 254 ? (short)extExtLength.intValue() : (lengthValueType == 5 ? extLength : lengthValueType))), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetTagHeader", new WithReaderArgs[0]);
        BACnetTagHeader _bACnetTagHeader = new BACnetTagHeader((byte)tagNumber, tagClass, (byte)lengthValueType, extTagNumber, extLength, extExtLength, extExtExtLength);
        return _bACnetTagHeader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetTagHeader)) {
            return false;
        }
        BACnetTagHeader that = (BACnetTagHeader)o;
        return this.getTagNumber() == that.getTagNumber() && this.getTagClass() == that.getTagClass() && this.getLengthValueType() == that.getLengthValueType() && this.getExtTagNumber() == that.getExtTagNumber() && this.getExtLength() == that.getExtLength() && this.getExtExtLength() == that.getExtExtLength() && this.getExtExtExtLength() == that.getExtExtExtLength();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTagNumber(), this.getTagClass(), this.getLengthValueType(), this.getExtTagNumber(), this.getExtLength(), this.getExtExtLength(), this.getExtExtExtLength()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

