/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetTagPayloadBitString
implements Message {
    protected final short unusedBits;
    protected final List<Boolean> data;
    protected final List<Boolean> unused;
    protected final Long actualLength;

    public BACnetTagPayloadBitString(short unusedBits, List<Boolean> data, List<Boolean> unused, Long actualLength) {
        this.unusedBits = unusedBits;
        this.data = data;
        this.unused = unused;
        this.actualLength = actualLength;
    }

    public short getUnusedBits() {
        return this.unusedBits;
    }

    public List<Boolean> getData() {
        return this.data;
    }

    public List<Boolean> getUnused() {
        return this.unused;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetTagPayloadBitString", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"unusedBits", (Object)this.unusedBits, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"data", this.data, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"unused", this.unused, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetTagPayloadBitString", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetTagPayloadBitString _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        if (this.data != null) {
            lengthInBits += 1 * this.data.size();
        }
        if (this.unused != null) {
            lengthInBits += 1 * this.unused.size();
        }
        return lengthInBits;
    }

    public static BACnetTagPayloadBitString staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Long actualLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Long) {
            actualLength = (Long)args[0];
        } else if (args[0] instanceof String) {
            actualLength = Long.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Long or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetTagPayloadBitString.staticParse(readBuffer, actualLength);
    }

    public static BACnetTagPayloadBitString staticParse(ReadBuffer readBuffer, Long actualLength) throws ParseException {
        readBuffer.pullContext("BACnetTagPayloadBitString", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short unusedBits = (Short)FieldReaderFactory.readSimpleField((String)"unusedBits", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        List data = FieldReaderFactory.readCountArrayField((String)"data", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (long)((actualLength - 1L) * 8L - (long)unusedBits), (WithReaderArgs[])new WithReaderArgs[0]);
        List unused = FieldReaderFactory.readCountArrayField((String)"unused", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (long)unusedBits, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetTagPayloadBitString", new WithReaderArgs[0]);
        BACnetTagPayloadBitString _bACnetTagPayloadBitString = new BACnetTagPayloadBitString(unusedBits, data, unused, actualLength);
        return _bACnetTagPayloadBitString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetTagPayloadBitString)) {
            return false;
        }
        BACnetTagPayloadBitString that = (BACnetTagPayloadBitString)o;
        return this.getUnusedBits() == that.getUnusedBits() && this.getData() == that.getData() && this.getUnused() == that.getUnused();
    }

    public int hashCode() {
        return Objects.hash(this.getUnusedBits(), this.getData(), this.getUnused());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

