/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetAddress;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagUnsignedInteger;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetVTSession
implements Message {
    protected final BACnetApplicationTagUnsignedInteger localVtSessionId;
    protected final BACnetApplicationTagUnsignedInteger removeVtSessionId;
    protected final BACnetAddress remoteVtAddress;

    public BACnetVTSession(BACnetApplicationTagUnsignedInteger localVtSessionId, BACnetApplicationTagUnsignedInteger removeVtSessionId, BACnetAddress remoteVtAddress) {
        this.localVtSessionId = localVtSessionId;
        this.removeVtSessionId = removeVtSessionId;
        this.remoteVtAddress = remoteVtAddress;
    }

    public BACnetApplicationTagUnsignedInteger getLocalVtSessionId() {
        return this.localVtSessionId;
    }

    public BACnetApplicationTagUnsignedInteger getRemoveVtSessionId() {
        return this.removeVtSessionId;
    }

    public BACnetAddress getRemoteVtAddress() {
        return this.remoteVtAddress;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetVTSession", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"localVtSessionId", (Object)this.localVtSessionId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"removeVtSessionId", (Object)this.removeVtSessionId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"remoteVtAddress", (Object)this.remoteVtAddress, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetVTSession", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetVTSession _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.localVtSessionId.getLengthInBits();
        lengthInBits += this.removeVtSessionId.getLengthInBits();
        return lengthInBits += this.remoteVtAddress.getLengthInBits();
    }

    public static BACnetVTSession staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetVTSession.staticParse(readBuffer);
    }

    public static BACnetVTSession staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetVTSession", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetApplicationTagUnsignedInteger localVtSessionId = (BACnetApplicationTagUnsignedInteger)FieldReaderFactory.readSimpleField((String)"localVtSessionId", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagUnsignedInteger)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagUnsignedInteger removeVtSessionId = (BACnetApplicationTagUnsignedInteger)FieldReaderFactory.readSimpleField((String)"removeVtSessionId", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagUnsignedInteger)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetAddress remoteVtAddress = (BACnetAddress)FieldReaderFactory.readSimpleField((String)"remoteVtAddress", (DataReader)new DataReaderComplexDefault(() -> BACnetAddress.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetVTSession", new WithReaderArgs[0]);
        BACnetVTSession _bACnetVTSession = new BACnetVTSession(localVtSessionId, removeVtSessionId, remoteVtAddress);
        return _bACnetVTSession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetVTSession)) {
            return false;
        }
        BACnetVTSession that = (BACnetVTSession)o;
        return this.getLocalVtSessionId() == that.getLocalVtSessionId() && this.getRemoveVtSessionId() == that.getRemoveVtSessionId() && this.getRemoteVtAddress() == that.getRemoteVtAddress();
    }

    public int hashCode() {
        return Objects.hash(this.getLocalVtSessionId(), this.getRemoveVtSessionId(), this.getRemoteVtAddress());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

