/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.NLMChallengeRequest;
import org.apache.plc4x.java.bacnetip.readwrite.NLMDisconnectConnectionToNetwork;
import org.apache.plc4x.java.bacnetip.readwrite.NLMEstablishConnectionToNetwork;
import org.apache.plc4x.java.bacnetip.readwrite.NLMIAmRouterToNetwork;
import org.apache.plc4x.java.bacnetip.readwrite.NLMICouldBeRouterToNetwork;
import org.apache.plc4x.java.bacnetip.readwrite.NLMInitalizeRoutingTable;
import org.apache.plc4x.java.bacnetip.readwrite.NLMInitalizeRoutingTableAck;
import org.apache.plc4x.java.bacnetip.readwrite.NLMNetworkNumberIs;
import org.apache.plc4x.java.bacnetip.readwrite.NLMRejectRouterToNetwork;
import org.apache.plc4x.java.bacnetip.readwrite.NLMRequestKeyUpdate;
import org.apache.plc4x.java.bacnetip.readwrite.NLMRequestMasterKey;
import org.apache.plc4x.java.bacnetip.readwrite.NLMReserved;
import org.apache.plc4x.java.bacnetip.readwrite.NLMRouterAvailableToNetwork;
import org.apache.plc4x.java.bacnetip.readwrite.NLMRouterBusyToNetwork;
import org.apache.plc4x.java.bacnetip.readwrite.NLMSecurityPayload;
import org.apache.plc4x.java.bacnetip.readwrite.NLMSecurityResponse;
import org.apache.plc4x.java.bacnetip.readwrite.NLMSetMasterKey;
import org.apache.plc4x.java.bacnetip.readwrite.NLMUpdateKeyDistributionKey;
import org.apache.plc4x.java.bacnetip.readwrite.NLMUpdateKeyUpdate;
import org.apache.plc4x.java.bacnetip.readwrite.NLMVendorProprietaryMessage;
import org.apache.plc4x.java.bacnetip.readwrite.NLMWhatIsNetworkNumber;
import org.apache.plc4x.java.bacnetip.readwrite.NLMWhoIsRouterToNetwork;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class NLM
implements Message {
    protected final Integer apduLength;

    public abstract Short getMessageType();

    public NLM(Integer apduLength) {
        this.apduLength = apduLength;
    }

    public boolean getIsVendorProprietaryMessage() {
        return this.getMessageType() >= 128;
    }

    protected abstract void serializeNLMChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NLM", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"messageType", (Object)this.getMessageType(), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isVendorProprietaryMessage = this.getIsVendorProprietaryMessage();
        writeBuffer.writeVirtual("isVendorProprietaryMessage", (Object)isVendorProprietaryMessage, new WithWriterArgs[0]);
        this.serializeNLMChild(writeBuffer);
        writeBuffer.popContext("NLM", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        NLM _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += 8;
    }

    public static NLM staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer apduLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            apduLength = (Integer)args[0];
        } else if (args[0] instanceof String) {
            apduLength = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return NLM.staticParse(readBuffer, apduLength);
    }

    public static NLM staticParse(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("NLM", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short messageType = (Short)FieldReaderFactory.readDiscriminatorField((String)"messageType", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isVendorProprietaryMessage = (Boolean)FieldReaderFactory.readVirtualField((String)"isVendorProprietaryMessage", Boolean.TYPE, (Object)(messageType >= 128 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        NLMBuilder builder = null;
        builder = EvaluationHelper.equals((Object)messageType, (Object)0) ? NLMWhoIsRouterToNetwork.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)1) ? NLMIAmRouterToNetwork.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)2) ? NLMICouldBeRouterToNetwork.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)3) ? NLMRejectRouterToNetwork.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)4) ? NLMRouterBusyToNetwork.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)5) ? NLMRouterAvailableToNetwork.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)6) ? NLMInitalizeRoutingTable.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)7) ? NLMInitalizeRoutingTableAck.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)8) ? NLMEstablishConnectionToNetwork.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)9) ? NLMDisconnectConnectionToNetwork.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)10) ? NLMChallengeRequest.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)11) ? NLMSecurityPayload.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)12) ? NLMSecurityResponse.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)13) ? NLMRequestKeyUpdate.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)14) ? NLMUpdateKeyUpdate.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)15) ? NLMUpdateKeyDistributionKey.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)16) ? NLMRequestMasterKey.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)17) ? NLMSetMasterKey.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)18) ? NLMWhatIsNetworkNumber.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)messageType, (Object)19) ? NLMNetworkNumberIs.staticParseNLMBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)isVendorProprietaryMessage, (Object)false) ? NLMReserved.staticParseNLMBuilder(readBuffer, apduLength) : NLMVendorProprietaryMessage.staticParseNLMBuilder(readBuffer, apduLength)))))))))))))))))))));
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [messageType=" + messageType + " " + "isVendorProprietaryMessage=" + isVendorProprietaryMessage + "]");
        }
        readBuffer.closeContext("NLM", new WithReaderArgs[0]);
        NLM _nLM = builder.build(apduLength);
        return _nLM;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NLM)) {
            return false;
        }
        NLM that = (NLM)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface NLMBuilder {
        public NLM build(Integer var1);
    }
}

