/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.NLM;
import org.apache.plc4x.java.bacnetip.readwrite.SecurityResponseCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NLMSecurityResponse
extends NLM
implements Message {
    protected final SecurityResponseCode responseCode;
    protected final long originalMessageId;
    protected final long originalTimestamp;
    protected final byte[] variableParameters;
    protected final Integer apduLength;

    @Override
    public Short getMessageType() {
        return (short)12;
    }

    public NLMSecurityResponse(SecurityResponseCode responseCode, long originalMessageId, long originalTimestamp, byte[] variableParameters, Integer apduLength) {
        super(apduLength);
        this.responseCode = responseCode;
        this.originalMessageId = originalMessageId;
        this.originalTimestamp = originalTimestamp;
        this.variableParameters = variableParameters;
        this.apduLength = apduLength;
    }

    public SecurityResponseCode getResponseCode() {
        return this.responseCode;
    }

    public long getOriginalMessageId() {
        return this.originalMessageId;
    }

    public long getOriginalTimestamp() {
        return this.originalTimestamp;
    }

    public byte[] getVariableParameters() {
        return this.variableParameters;
    }

    @Override
    protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NLMSecurityResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"responseCode", (String)"SecurityResponseCode", (Object)((Object)this.responseCode), (DataWriter)new DataWriterEnumDefault(SecurityResponseCode::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"originalMessageId", (Object)this.originalMessageId, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"originalTimestamp", (Object)this.originalTimestamp, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"variableParameters", (byte[])this.variableParameters, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NLMSecurityResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NLMSecurityResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.variableParameters != null) {
            lengthInBits += 8 * this.variableParameters.length;
        }
        return lengthInBits;
    }

    public static NLM.NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("NLMSecurityResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        SecurityResponseCode responseCode = (SecurityResponseCode)((Object)FieldReaderFactory.readEnumField((String)"responseCode", (String)"SecurityResponseCode", (DataReader)new DataReaderEnumDefault(SecurityResponseCode::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        long originalMessageId = (Long)FieldReaderFactory.readSimpleField((String)"originalMessageId", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long originalTimestamp = (Long)FieldReaderFactory.readSimpleField((String)"originalTimestamp", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] variableParameters = readBuffer.readByteArray("variableParameters", Math.toIntExact(apduLength - 10), new WithReaderArgs[0]);
        readBuffer.closeContext("NLMSecurityResponse", new WithReaderArgs[0]);
        return new NLMSecurityResponseBuilderImpl(responseCode, originalMessageId, originalTimestamp, variableParameters, apduLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NLMSecurityResponse)) {
            return false;
        }
        NLMSecurityResponse that = (NLMSecurityResponse)o;
        return this.getResponseCode() == that.getResponseCode() && this.getOriginalMessageId() == that.getOriginalMessageId() && this.getOriginalTimestamp() == that.getOriginalTimestamp() && this.getVariableParameters() == that.getVariableParameters() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getResponseCode(), this.getOriginalMessageId(), this.getOriginalTimestamp(), this.getVariableParameters()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NLMSecurityResponseBuilderImpl
    implements NLM.NLMBuilder {
        private final SecurityResponseCode responseCode;
        private final long originalMessageId;
        private final long originalTimestamp;
        private final byte[] variableParameters;
        private final Integer apduLength;

        public NLMSecurityResponseBuilderImpl(SecurityResponseCode responseCode, long originalMessageId, long originalTimestamp, byte[] variableParameters, Integer apduLength) {
            this.responseCode = responseCode;
            this.originalMessageId = originalMessageId;
            this.originalTimestamp = originalTimestamp;
            this.variableParameters = variableParameters;
            this.apduLength = apduLength;
        }

        @Override
        public NLMSecurityResponse build(Integer apduLength) {
            NLMSecurityResponse nLMSecurityResponse = new NLMSecurityResponse(this.responseCode, this.originalMessageId, this.originalTimestamp, this.variableParameters, apduLength);
            return nLMSecurityResponse;
        }
    }
}

