/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetVendorId;
import org.apache.plc4x.java.bacnetip.readwrite.NLM;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NLMVendorProprietaryMessage
extends NLM
implements Message {
    protected final BACnetVendorId vendorId;
    protected final byte[] proprietaryMessage;
    protected final Integer apduLength;

    @Override
    public Short getMessageType() {
        return (short)0;
    }

    public NLMVendorProprietaryMessage(BACnetVendorId vendorId, byte[] proprietaryMessage, Integer apduLength) {
        super(apduLength);
        this.vendorId = vendorId;
        this.proprietaryMessage = proprietaryMessage;
        this.apduLength = apduLength;
    }

    public BACnetVendorId getVendorId() {
        return this.vendorId;
    }

    public byte[] getProprietaryMessage() {
        return this.proprietaryMessage;
    }

    @Override
    protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NLMVendorProprietaryMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"vendorId", (String)"BACnetVendorId", (Object)((Object)this.vendorId), (DataWriter)new DataWriterEnumDefault(BACnetVendorId::getValue, Enum::name, DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"proprietaryMessage", (byte[])this.proprietaryMessage, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NLMVendorProprietaryMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NLMVendorProprietaryMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        if (this.proprietaryMessage != null) {
            lengthInBits += 8 * this.proprietaryMessage.length;
        }
        return lengthInBits;
    }

    public static NLM.NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("NLMVendorProprietaryMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetVendorId vendorId = (BACnetVendorId)((Object)FieldReaderFactory.readEnumField((String)"vendorId", (String)"BACnetVendorId", (DataReader)new DataReaderEnumDefault(BACnetVendorId::enumForValue, DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16)), (WithReaderArgs[])new WithReaderArgs[0]));
        byte[] proprietaryMessage = readBuffer.readByteArray("proprietaryMessage", Math.toIntExact(apduLength > 0 ? apduLength - 3 : 0), new WithReaderArgs[0]);
        readBuffer.closeContext("NLMVendorProprietaryMessage", new WithReaderArgs[0]);
        return new NLMVendorProprietaryMessageBuilderImpl(vendorId, proprietaryMessage, apduLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NLMVendorProprietaryMessage)) {
            return false;
        }
        NLMVendorProprietaryMessage that = (NLMVendorProprietaryMessage)o;
        return this.getVendorId() == that.getVendorId() && this.getProprietaryMessage() == that.getProprietaryMessage() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getVendorId(), this.getProprietaryMessage()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NLMVendorProprietaryMessageBuilderImpl
    implements NLM.NLMBuilder {
        private final BACnetVendorId vendorId;
        private final byte[] proprietaryMessage;
        private final Integer apduLength;

        public NLMVendorProprietaryMessageBuilderImpl(BACnetVendorId vendorId, byte[] proprietaryMessage, Integer apduLength) {
            this.vendorId = vendorId;
            this.proprietaryMessage = proprietaryMessage;
            this.apduLength = apduLength;
        }

        @Override
        public NLMVendorProprietaryMessage build(Integer apduLength) {
            NLMVendorProprietaryMessage nLMVendorProprietaryMessage = new NLMVendorProprietaryMessage(this.vendorId, this.proprietaryMessage, apduLength);
            return nLMVendorProprietaryMessage;
        }
    }
}

