/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.APDU;
import org.apache.plc4x.java.bacnetip.readwrite.NLM;
import org.apache.plc4x.java.bacnetip.readwrite.NPDUControl;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NPDU
implements Message {
    protected final short protocolVersionNumber;
    protected final NPDUControl control;
    protected final Integer destinationNetworkAddress;
    protected final Short destinationLength;
    protected final List<Short> destinationAddress;
    protected final Integer sourceNetworkAddress;
    protected final Short sourceLength;
    protected final List<Short> sourceAddress;
    protected final Short hopCount;
    protected final NLM nlm;
    protected final APDU apdu;
    protected final Integer npduLength;

    public NPDU(short protocolVersionNumber, NPDUControl control, Integer destinationNetworkAddress, Short destinationLength, List<Short> destinationAddress, Integer sourceNetworkAddress, Short sourceLength, List<Short> sourceAddress, Short hopCount, NLM nlm, APDU apdu, Integer npduLength) {
        this.protocolVersionNumber = protocolVersionNumber;
        this.control = control;
        this.destinationNetworkAddress = destinationNetworkAddress;
        this.destinationLength = destinationLength;
        this.destinationAddress = destinationAddress;
        this.sourceNetworkAddress = sourceNetworkAddress;
        this.sourceLength = sourceLength;
        this.sourceAddress = sourceAddress;
        this.hopCount = hopCount;
        this.nlm = nlm;
        this.apdu = apdu;
        this.npduLength = npduLength;
    }

    public short getProtocolVersionNumber() {
        return this.protocolVersionNumber;
    }

    public NPDUControl getControl() {
        return this.control;
    }

    public Integer getDestinationNetworkAddress() {
        return this.destinationNetworkAddress;
    }

    public Short getDestinationLength() {
        return this.destinationLength;
    }

    public List<Short> getDestinationAddress() {
        return this.destinationAddress;
    }

    public Integer getSourceNetworkAddress() {
        return this.sourceNetworkAddress;
    }

    public Short getSourceLength() {
        return this.sourceLength;
    }

    public List<Short> getSourceAddress() {
        return this.sourceAddress;
    }

    public Short getHopCount() {
        return this.hopCount;
    }

    public NLM getNlm() {
        return this.nlm;
    }

    public APDU getApdu() {
        return this.apdu;
    }

    public int getDestinationLengthAddon() {
        return this.getControl().getDestinationSpecified() ? 3 + this.getDestinationLength() : 0;
    }

    public int getSourceLengthAddon() {
        return this.getControl().getSourceSpecified() ? 3 + this.getSourceLength() : 0;
    }

    public int getPayloadSubtraction() {
        return 2 + (this.getSourceLengthAddon() + this.getDestinationLengthAddon() + (this.getControl().getDestinationSpecified() ? 1 : 0));
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NPDU", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"protocolVersionNumber", (Object)this.protocolVersionNumber, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"control", (Object)this.control, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"destinationNetworkAddress", (Object)this.destinationNetworkAddress, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (boolean)this.getControl().getDestinationSpecified(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"destinationLength", (Object)this.destinationLength, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (boolean)this.getControl().getDestinationSpecified(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"destinationAddress", this.destinationAddress, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        int destinationLengthAddon = this.getDestinationLengthAddon();
        writeBuffer.writeVirtual("destinationLengthAddon", (Object)destinationLengthAddon, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"sourceNetworkAddress", (Object)this.sourceNetworkAddress, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (boolean)this.getControl().getSourceSpecified(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"sourceLength", (Object)this.sourceLength, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (boolean)this.getControl().getSourceSpecified(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"sourceAddress", this.sourceAddress, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        int sourceLengthAddon = this.getSourceLengthAddon();
        writeBuffer.writeVirtual("sourceLengthAddon", (Object)sourceLengthAddon, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"hopCount", (Object)this.hopCount, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (boolean)this.getControl().getDestinationSpecified(), (WithWriterArgs[])new WithWriterArgs[0]);
        int payloadSubtraction = this.getPayloadSubtraction();
        writeBuffer.writeVirtual("payloadSubtraction", (Object)payloadSubtraction, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"nlm", (Object)this.nlm, (DataWriter)new DataWriterComplexDefault(writeBuffer), (boolean)this.getControl().getMessageTypeFieldPresent(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"apdu", (Object)this.apdu, (DataWriter)new DataWriterComplexDefault(writeBuffer), (!this.getControl().getMessageTypeFieldPresent() ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NPDU", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        NPDU _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += this.control.getLengthInBits();
        if (this.destinationNetworkAddress != null) {
            lengthInBits += 16;
        }
        if (this.destinationLength != null) {
            lengthInBits += 8;
        }
        if (this.destinationAddress != null) {
            lengthInBits += 8 * this.destinationAddress.size();
        }
        if (this.sourceNetworkAddress != null) {
            lengthInBits += 16;
        }
        if (this.sourceLength != null) {
            lengthInBits += 8;
        }
        if (this.sourceAddress != null) {
            lengthInBits += 8 * this.sourceAddress.size();
        }
        if (this.hopCount != null) {
            lengthInBits += 8;
        }
        if (this.nlm != null) {
            lengthInBits += this.nlm.getLengthInBits();
        }
        if (this.apdu != null) {
            lengthInBits += this.apdu.getLengthInBits();
        }
        return lengthInBits;
    }

    public static NPDU staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer npduLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            npduLength = (Integer)args[0];
        } else if (args[0] instanceof String) {
            npduLength = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return NPDU.staticParse(readBuffer, npduLength);
    }

    public static NPDU staticParse(ReadBuffer readBuffer, Integer npduLength) throws ParseException {
        readBuffer.pullContext("NPDU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short protocolVersionNumber = (Short)FieldReaderFactory.readSimpleField((String)"protocolVersionNumber", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        NPDUControl control = (NPDUControl)FieldReaderFactory.readSimpleField((String)"control", (DataReader)new DataReaderComplexDefault(() -> NPDUControl.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Integer destinationNetworkAddress = (Integer)FieldReaderFactory.readOptionalField((String)"destinationNetworkAddress", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (boolean)control.getDestinationSpecified(), (WithReaderArgs[])new WithReaderArgs[0]);
        Short destinationLength = (Short)FieldReaderFactory.readOptionalField((String)"destinationLength", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (boolean)control.getDestinationSpecified(), (WithReaderArgs[])new WithReaderArgs[0]);
        List destinationAddress = FieldReaderFactory.readCountArrayField((String)"destinationAddress", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (long)(control.getDestinationSpecified() ? destinationLength : (short)0), (WithReaderArgs[])new WithReaderArgs[0]);
        int destinationLengthAddon = (Integer)FieldReaderFactory.readVirtualField((String)"destinationLengthAddon", Integer.TYPE, (Object)(control.getDestinationSpecified() ? 3 + destinationLength : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Integer sourceNetworkAddress = (Integer)FieldReaderFactory.readOptionalField((String)"sourceNetworkAddress", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (boolean)control.getSourceSpecified(), (WithReaderArgs[])new WithReaderArgs[0]);
        Short sourceLength = (Short)FieldReaderFactory.readOptionalField((String)"sourceLength", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (boolean)control.getSourceSpecified(), (WithReaderArgs[])new WithReaderArgs[0]);
        List sourceAddress = FieldReaderFactory.readCountArrayField((String)"sourceAddress", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (long)(control.getSourceSpecified() ? sourceLength : (short)0), (WithReaderArgs[])new WithReaderArgs[0]);
        int sourceLengthAddon = (Integer)FieldReaderFactory.readVirtualField((String)"sourceLengthAddon", Integer.TYPE, (Object)(control.getSourceSpecified() ? 3 + sourceLength : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Short hopCount = (Short)FieldReaderFactory.readOptionalField((String)"hopCount", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (boolean)control.getDestinationSpecified(), (WithReaderArgs[])new WithReaderArgs[0]);
        int payloadSubtraction = (Integer)FieldReaderFactory.readVirtualField((String)"payloadSubtraction", Integer.TYPE, (Object)(2 + (sourceLengthAddon + destinationLengthAddon + (control.getDestinationSpecified() ? 1 : 0))), (WithReaderArgs[])new WithReaderArgs[0]);
        NLM nlm = (NLM)FieldReaderFactory.readOptionalField((String)"nlm", (DataReader)new DataReaderComplexDefault(() -> NLM.staticParse(readBuffer, npduLength - payloadSubtraction), readBuffer), (boolean)control.getMessageTypeFieldPresent(), (WithReaderArgs[])new WithReaderArgs[0]);
        APDU apdu = (APDU)FieldReaderFactory.readOptionalField((String)"apdu", (DataReader)new DataReaderComplexDefault(() -> APDU.staticParse(readBuffer, npduLength - payloadSubtraction), readBuffer), (!control.getMessageTypeFieldPresent() ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        if (nlm == null && apdu == null) {
            throw new ParseValidationException("something is wrong here... apdu and nlm not set");
        }
        readBuffer.closeContext("NPDU", new WithReaderArgs[0]);
        NPDU _nPDU = new NPDU(protocolVersionNumber, control, destinationNetworkAddress, destinationLength, destinationAddress, sourceNetworkAddress, sourceLength, sourceAddress, hopCount, nlm, apdu, npduLength);
        return _nPDU;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NPDU)) {
            return false;
        }
        NPDU that = (NPDU)o;
        return this.getProtocolVersionNumber() == that.getProtocolVersionNumber() && this.getControl() == that.getControl() && this.getDestinationNetworkAddress() == that.getDestinationNetworkAddress() && this.getDestinationLength() == that.getDestinationLength() && this.getDestinationAddress() == that.getDestinationAddress() && this.getSourceNetworkAddress() == that.getSourceNetworkAddress() && this.getSourceLength() == that.getSourceLength() && this.getSourceAddress() == that.getSourceAddress() && this.getHopCount() == that.getHopCount() && this.getNlm() == that.getNlm() && this.getApdu() == that.getApdu();
    }

    public int hashCode() {
        return Objects.hash(this.getProtocolVersionNumber(), this.getControl(), this.getDestinationNetworkAddress(), this.getDestinationLength(), this.getDestinationAddress(), this.getSourceNetworkAddress(), this.getSourceLength(), this.getSourceAddress(), this.getHopCount(), this.getNlm(), this.getApdu());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

