/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum SecurityResponseCode {
    SUCCESS(0),
    ACCESS_DENIED(1),
    BAD_DESTINATION_ADDRESS(2),
    BAD_DESTINATION_DEVICE_ID(3),
    BAD_SIGNATURE(4),
    BAD_SOURCE_ADDRESS(5),
    BAD_TIMESTAMP(6),
    CANNOT_USE_KEY(7),
    CANNOT_VERIFY_MESSAGE_ID(8),
    CORRECT_KEY_REVISION(9),
    DESTINATION_DEVICE_ID_REQUIRED(10),
    DUPLICATE_MESSAGE(11),
    ENCRYPTION_NOT_CONFIGURED(12),
    ENCRYPTION_REQUIRED(13),
    INCORRECT_KEY(14),
    INVALID_KEY_DATA(15),
    KEY_UPDATE_IN_PROGRESS(16),
    MALFORMED_MESSAGE(17),
    NOT_KEY_SERVER(18),
    SECURITY_NOT_CONFIGURED(19),
    SOURCE_SECURITY_REQUIRED(20),
    TOO_MANY_KEYS(21),
    UNKNOWN_AUTHENTICATION_TYPE(22),
    UNKNOWN_KEY(23),
    UNKNOWN_KEY_REVISION(24),
    UNKNOWN_SOURCE_MESSAGE(25);

    private static final Map<Short, SecurityResponseCode> map;
    private final short value;

    static {
        map = new HashMap<Short, SecurityResponseCode>();
        SecurityResponseCode[] securityResponseCodeArray = SecurityResponseCode.values();
        int n = securityResponseCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SecurityResponseCode value = securityResponseCodeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private SecurityResponseCode(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static SecurityResponseCode enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

