/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetAbortReason;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetAccumulatorRecordAccumulatorStatus;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetAction;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagBitString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagBoolean;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagDate;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagDouble;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagEnumerated;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagNull;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagReal;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagSignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagTime;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetBinaryPV;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetCharacterEncoding;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisable;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagBitString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagBoolean;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagDate;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagDouble;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagEnumerated;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagNull;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagReal;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagSignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagTime;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDoorSecuredStatus;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDoorValue;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetEventState;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetEventType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetFileAccessMethod;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetLifeSafetyMode;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetLifeSafetyState;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetLockStatus;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetNetworkType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetNodeType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetNotifyType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPolarity;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetProgramRequest;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetProgramState;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifierTagged;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetRejectReason;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetReliability;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetSegmentation;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetSegmentationTagged;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetShedState;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadBitString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadBoolean;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadDate;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadDouble;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadEnumerated;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadReal;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadSignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadTime;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetVendorId;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetVendorIdTagged;
import org.apache.plc4x.java.bacnetip.readwrite.ErrorClass;
import org.apache.plc4x.java.bacnetip.readwrite.ErrorCode;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHelper {
    public static final Logger LOGGER = LoggerFactory.getLogger(StaticHelper.class);

    public static Object readEnumGenericFailing(ReadBuffer readBuffer, Long actualLength, Enum<?> template) throws ParseException {
        int bitsToRead = (int)(actualLength * 8L);
        long rawValue = readBuffer.readUnsignedLong("value", bitsToRead, new WithReaderArgs[0]);
        Class<?> declaringClass = template.getDeclaringClass();
        if (declaringClass == BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisable.class) {
            if (!BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisable.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisable.class.getSimpleName());
            }
            return BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisable.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.class) {
            if (!BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.class.getSimpleName());
            }
            return BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetSegmentation.class) {
            if (!BACnetSegmentation.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetSegmentation.class.getSimpleName());
            }
            return BACnetSegmentation.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetAction.class) {
            if (!BACnetAction.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetAction.class.getSimpleName());
            }
            return BACnetAction.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetNotifyType.class) {
            if (!BACnetNotifyType.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetBinaryPV.class.getSimpleName());
            }
            return BACnetNotifyType.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetBinaryPV.class) {
            if (!BACnetBinaryPV.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetBinaryPV.class.getSimpleName());
            }
            return BACnetBinaryPV.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetLockStatus.class) {
            if (!BACnetLockStatus.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetLockStatus.class.getSimpleName());
            }
            return BACnetLockStatus.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetDoorSecuredStatus.class) {
            if (!BACnetDoorSecuredStatus.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetDoorSecuredStatus.class.getSimpleName());
            }
            return BACnetDoorSecuredStatus.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetNodeType.class) {
            if (!BACnetNodeType.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetNodeType.class.getSimpleName());
            }
            return BACnetNodeType.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetProgramState.class) {
            if (!BACnetProgramState.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetProgramState.class.getSimpleName());
            }
            return BACnetProgramState.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetProgramRequest.class) {
            if (!BACnetProgramRequest.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetProgramRequest.class.getSimpleName());
            }
            return BACnetProgramRequest.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetFileAccessMethod.class) {
            if (!BACnetFileAccessMethod.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetFileAccessMethod.class.getSimpleName());
            }
            return BACnetFileAccessMethod.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetAccumulatorRecordAccumulatorStatus.class) {
            if (!BACnetAccumulatorRecordAccumulatorStatus.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetAccumulatorRecordAccumulatorStatus.class.getSimpleName());
            }
            return BACnetAccumulatorRecordAccumulatorStatus.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetPolarity.class) {
            if (!BACnetPolarity.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetPolarity.class.getSimpleName());
            }
            return BACnetPolarity.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetShedState.class) {
            if (!BACnetShedState.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetShedState.class.getSimpleName());
            }
            return BACnetShedState.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetDoorValue.class) {
            if (!BACnetDoorValue.isDefined((short)rawValue).booleanValue()) {
                throw new ParseException("Invalid value " + rawValue + " for " + BACnetDoorValue.class.getSimpleName());
            }
            return BACnetDoorValue.enumForValue((short)rawValue);
        }
        throw new ParseException("Unmapped type " + declaringClass);
    }

    public static Object readEnumGeneric(ReadBuffer readBuffer, Long actualLength, Enum<?> template) throws ParseException {
        int bitsToRead = (int)(actualLength * 8L);
        long rawValue = readBuffer.readUnsignedLong("value", bitsToRead, new WithReaderArgs[0]);
        Class<?> declaringClass = template.getDeclaringClass();
        if (declaringClass == BACnetAbortReason.class) {
            if (!BACnetAbortReason.isDefined((short)rawValue).booleanValue()) {
                return BACnetAbortReason.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetAbortReason.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetEventState.class) {
            if (!BACnetEventState.isDefined((short)rawValue).booleanValue()) {
                return BACnetEventState.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetEventState.enumForValue((int)rawValue);
        }
        if (declaringClass == BACnetEventType.class) {
            if (!BACnetEventType.isDefined((short)rawValue).booleanValue()) {
                return BACnetEventType.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetEventType.enumForValue((int)rawValue);
        }
        if (declaringClass == BACnetLifeSafetyMode.class) {
            if (!BACnetLifeSafetyMode.isDefined((short)rawValue).booleanValue()) {
                return BACnetLifeSafetyMode.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetLifeSafetyMode.enumForValue((int)rawValue);
        }
        if (declaringClass == BACnetLifeSafetyState.class) {
            if (!BACnetLifeSafetyState.isDefined((short)rawValue).booleanValue()) {
                return BACnetLifeSafetyState.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetLifeSafetyState.enumForValue((int)rawValue);
        }
        if (declaringClass == BACnetNetworkType.class) {
            if (!BACnetNetworkType.isDefined((short)rawValue).booleanValue()) {
                return BACnetNetworkType.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetNetworkType.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetObjectType.class) {
            if (!BACnetObjectType.isDefined((short)rawValue).booleanValue()) {
                return BACnetObjectType.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetObjectType.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetPropertyIdentifier.class) {
            if (!BACnetPropertyIdentifier.isDefined((short)rawValue).booleanValue()) {
                return BACnetPropertyIdentifier.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetPropertyIdentifier.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetReliability.class) {
            if (!BACnetReliability.isDefined((short)rawValue).booleanValue()) {
                return BACnetReliability.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetReliability.enumForValue((short)rawValue);
        }
        if (declaringClass == ErrorClass.class) {
            if (!ErrorClass.isDefined((short)rawValue).booleanValue()) {
                return ErrorClass.VENDOR_PROPRIETARY_VALUE;
            }
            return ErrorClass.enumForValue((short)rawValue);
        }
        if (declaringClass == ErrorCode.class) {
            if (!ErrorCode.isDefined((short)rawValue).booleanValue()) {
                return ErrorCode.VENDOR_PROPRIETARY_VALUE;
            }
            return ErrorCode.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetRejectReason.class) {
            if (!BACnetRejectReason.isDefined((short)rawValue).booleanValue()) {
                return BACnetRejectReason.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetRejectReason.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.class) {
            if (!BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.isDefined((short)rawValue).booleanValue()) {
                return BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.VENDOR_PROPRIETARY_VALUE;
            }
            return BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.enumForValue((short)rawValue);
        }
        if (declaringClass == BACnetSegmentation.class) {
            if (!BACnetSegmentation.isDefined((short)rawValue).booleanValue()) {
                LOGGER.error("{} not defined for segmentation falling back to no segmentation", (Object)rawValue);
            }
            return BACnetSegmentation.NO_SEGMENTATION;
        }
        if (declaringClass == BACnetVendorId.class) {
            if (!BACnetVendorId.isDefined((short)rawValue).booleanValue()) {
                return BACnetVendorId.UNKNOWN_VENDOR;
            }
            return BACnetVendorId.enumForValue((short)rawValue);
        }
        LOGGER.warn("using reflection for {}", declaringClass);
        Optional<Method> enumForValue = Arrays.stream(declaringClass.getDeclaredMethods()).filter(method -> method.getName().equals("enumForValue")).findAny();
        if (!enumForValue.isPresent()) {
            throw new ParseException("No enumForValue available");
        }
        Method method2 = enumForValue.get();
        try {
            Class<?> parameterType = method2.getParameterTypes()[0];
            Number paramValue = null;
            if (parameterType == Byte.TYPE || parameterType == Byte.class) {
                paramValue = (byte)rawValue;
            } else if (parameterType == Short.TYPE || parameterType == Short.class) {
                paramValue = (short)rawValue;
            } else if (parameterType == Integer.TYPE || parameterType == Integer.class) {
                paramValue = (int)rawValue;
            } else if (parameterType == Long.TYPE || parameterType == Long.class) {
                paramValue = (int)rawValue;
            }
            Object result = method2.invoke(null, paramValue);
            return Objects.requireNonNullElseGet(result, () -> Enum.valueOf(template.getDeclaringClass(), "VENDOR_PROPRIETARY_VALUE"));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ParseException("error invoking method", (Throwable)e);
        }
    }

    public static long readProprietaryEnumGeneric(ReadBuffer readBuffer, Long actualLength, boolean shouldRead) throws ParseException {
        if (!shouldRead) {
            return 0L;
        }
        readBuffer.reset((int)((long)readBuffer.getPos() - actualLength));
        int bitsToRead = (int)(actualLength * 8L);
        return readBuffer.readUnsignedLong("proprietaryValue", bitsToRead, new WithReaderArgs[0]);
    }

    public static void writeEnumGeneric(WriteBuffer writeBuffer, Enum<?> value) throws SerializationException {
        long valueValue;
        if (value == null) {
            return;
        }
        if (value.name().equals("VENDOR_PROPRIETARY_VALUE")) {
            return;
        }
        if (value.getDeclaringClass() == BACnetAbortReason.class) {
            valueValue = ((BACnetAbortReason)value).getValue();
        } else if (value.getDeclaringClass() == BACnetEventState.class) {
            valueValue = ((BACnetEventState)value).getValue();
        } else if (value.getDeclaringClass() == BACnetEventType.class) {
            valueValue = ((BACnetEventType)value).getValue();
        } else if (value.getDeclaringClass() == BACnetLifeSafetyMode.class) {
            valueValue = ((BACnetLifeSafetyMode)value).getValue();
        } else if (value.getDeclaringClass() == BACnetLifeSafetyState.class) {
            valueValue = ((BACnetLifeSafetyState)value).getValue();
        } else if (value.getDeclaringClass() == BACnetNetworkType.class) {
            valueValue = ((BACnetNetworkType)value).getValue();
        } else if (value.getDeclaringClass() == BACnetNodeType.class) {
            valueValue = ((BACnetNodeType)value).getValue();
        } else if (value.getDeclaringClass() == BACnetNotifyType.class) {
            valueValue = ((BACnetNotifyType)value).getValue();
        } else if (value.getDeclaringClass() == BACnetObjectType.class) {
            valueValue = ((BACnetObjectType)value).getValue();
        } else if (value.getDeclaringClass() == BACnetPropertyIdentifier.class) {
            valueValue = ((BACnetPropertyIdentifier)value).getValue();
        } else if (value.getDeclaringClass() == BACnetReliability.class) {
            valueValue = ((BACnetReliability)value).getValue();
        } else if (value.getDeclaringClass() == ErrorClass.class) {
            valueValue = ((ErrorClass)value).getValue();
        } else if (value.getDeclaringClass() == ErrorCode.class) {
            valueValue = ((ErrorCode)value).getValue();
        } else if (value.getDeclaringClass() == BACnetRejectReason.class) {
            valueValue = ((BACnetRejectReason)value).getValue();
        } else if (value.getDeclaringClass() == BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.class) {
            valueValue = ((BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice)value).getValue();
        } else if (value.getDeclaringClass() == BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisable.class) {
            valueValue = ((BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisable)value).getValue();
        } else if (value.getDeclaringClass() == BACnetSegmentation.class) {
            valueValue = ((BACnetSegmentation)value).getValue();
        } else if (value.getDeclaringClass() == BACnetVendorId.class) {
            valueValue = ((BACnetVendorId)value).getValue();
        } else {
            LOGGER.warn("using reflection for {}", value.getDeclaringClass());
            try {
                valueValue = ((Number)FieldUtils.getDeclaredField(value.getDeclaringClass(), (String)"value", (boolean)true).get(value)).longValue();
            }
            catch (IllegalAccessException e) {
                throw new SerializationException("error accessing value", (Throwable)e);
            }
        }
        int bitsToWrite = valueValue <= 255L ? 8 : (valueValue <= 65535L ? 16 : (valueValue <= 0xFFFFFFFFL ? 32 : 32));
        writeBuffer.writeUnsignedLong("value", bitsToWrite, valueValue, new WithWriterArgs[]{WithReaderWriterArgs.WithAdditionalStringRepresentation((String)value.name())});
    }

    public static void writeProprietaryEnumGeneric(WriteBuffer writeBuffer, long value, boolean shouldWrite) throws SerializationException {
        if (!shouldWrite) {
            return;
        }
        int bitsToWrite = value <= 255L ? 8 : (value <= 65535L ? 16 : (value <= 0xFFFFFFFFL ? 32 : 32));
        writeBuffer.writeUnsignedLong("proprietaryValue", bitsToWrite, value, new WithWriterArgs[]{WithReaderWriterArgs.WithAdditionalStringRepresentation((String)"VENDOR_PROPRIETARY_VALUE")});
    }

    @Deprecated
    public static BACnetObjectType readObjectType(ReadBuffer readBuffer) throws ParseException {
        short readUnsignedShort = readBuffer.readUnsignedShort("objectType", 10, new WithReaderArgs[0]);
        if (!BACnetObjectType.isDefined(readUnsignedShort).booleanValue()) {
            return BACnetObjectType.VENDOR_PROPRIETARY_VALUE;
        }
        return BACnetObjectType.enumForValue(readUnsignedShort);
    }

    @Deprecated
    public static Short readProprietaryObjectType(ReadBuffer readBuffer, BACnetObjectType value) throws ParseException {
        if (value != null && value != BACnetObjectType.VENDOR_PROPRIETARY_VALUE) {
            return (short)0;
        }
        readBuffer.readUnsignedInt(6, new WithReaderArgs[0]);
        readBuffer.reset(readBuffer.getPos() - 2);
        return readBuffer.readUnsignedShort("proprietaryObjectType", 10, new WithReaderArgs[0]);
    }

    @Deprecated
    public static void writeObjectType(WriteBuffer writeBuffer, BACnetObjectType value) throws SerializationException {
        if (value == null || value == BACnetObjectType.VENDOR_PROPRIETARY_VALUE) {
            return;
        }
        writeBuffer.writeUnsignedLong("objectType", 10, (long)value.getValue(), new WithWriterArgs[]{WithReaderWriterArgs.WithAdditionalStringRepresentation((String)value.name())});
    }

    @Deprecated
    public static void writeProprietaryObjectType(WriteBuffer writeBuffer, BACnetObjectType objectType, int value) throws SerializationException {
        if (objectType != null && objectType != BACnetObjectType.VENDOR_PROPRIETARY_VALUE) {
            return;
        }
        writeBuffer.writeUnsignedInt("proprietaryObjectType", 10, value, new WithWriterArgs[]{WithReaderWriterArgs.WithAdditionalStringRepresentation((String)BACnetObjectType.VENDOR_PROPRIETARY_VALUE.name())});
    }

    @Deprecated
    public static BACnetObjectType mapBACnetObjectType(BACnetContextTagEnumerated rawObjectType) {
        if (rawObjectType == null) {
            return null;
        }
        BACnetObjectType baCnetObjectType = BACnetObjectType.enumForValue((short)rawObjectType.getActualValue());
        if (baCnetObjectType == null) {
            return BACnetObjectType.VENDOR_PROPRIETARY_VALUE;
        }
        return baCnetObjectType;
    }

    public static boolean isBACnetConstructedDataClosingTag(ReadBuffer readBuffer, boolean instantTerminate, int expectedTagNumber) {
        if (instantTerminate) {
            return true;
        }
        int oldPos = readBuffer.getPos();
        try {
            int tagNumber = readBuffer.readUnsignedInt(4, new WithReaderArgs[0]);
            boolean isContextTag = readBuffer.readBit(new WithReaderArgs[0]);
            int tagValue = readBuffer.readUnsignedInt(3, new WithReaderArgs[0]);
            boolean foundOurClosingTag = isContextTag && tagNumber == expectedTagNumber && tagValue == 7;
            LOGGER.debug("Checking at pos pos:{}: tagNumber:{}, isContextTag:{}, tagValue:{}, expectedTagNumber:{}. foundOurClosingTag:{}", new Object[]{oldPos, tagNumber, isContextTag, tagValue, expectedTagNumber, foundOurClosingTag});
            boolean bl = foundOurClosingTag;
            return bl;
        }
        catch (ParseException e) {
            LOGGER.warn("Error reading termination bit", (Throwable)e);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.debug("Reached EOF at {}", (Object)oldPos, (Object)e);
            return true;
        }
        finally {
            readBuffer.reset(oldPos);
        }
    }

    public static long parseVarUint(byte[] data) {
        if (data.length == 0) {
            return 0L;
        }
        return new BigInteger(data).longValue();
    }

    public static byte[] writeVarUint(long value) {
        return BigInteger.valueOf(value).toByteArray();
    }

    public static BACnetTagHeader createBACnetTagHeaderBalanced(boolean isContext, short id, long value) {
        byte lengthValueType;
        byte tagNumber;
        TagClass tagClass = TagClass.APPLICATION_TAGS;
        if (isContext) {
            tagClass = TagClass.CONTEXT_SPECIFIC_TAGS;
        }
        Short extTagNumber = null;
        if (id <= 14) {
            tagNumber = (byte)id;
        } else {
            tagNumber = 15;
            extTagNumber = id;
        }
        Short extLength = null;
        Integer extExtLength = null;
        Long extExtExtLength = null;
        if (value <= 4L) {
            lengthValueType = (byte)value;
        } else {
            lengthValueType = 5;
            if (value <= 253L) {
                extLength = (short)value;
            } else if (value <= 65535L) {
                extLength = 254;
                extExtLength = (int)value;
            } else {
                extLength = 255;
                extExtExtLength = value;
            }
        }
        return new BACnetTagHeader(tagNumber, tagClass, lengthValueType, extTagNumber, extLength, extExtLength, extExtExtLength);
    }

    public static BACnetApplicationTagNull createBACnetApplicationTagNull() {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.NULL.getValue(), 0L);
        return new BACnetApplicationTagNull(header);
    }

    public static BACnetContextTagNull createBACnetContextTagNull(byte tagNumber) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, 0L);
        return new BACnetContextTagNull(header, Short.valueOf(tagNumber));
    }

    public static BACnetOpeningTag createBACnetOpeningTag(short tagNum) {
        byte tagNumber;
        Short extTagNumber = null;
        if (tagNum <= 14) {
            tagNumber = (byte)tagNum;
        } else {
            tagNumber = 15;
            extTagNumber = tagNum;
        }
        BACnetTagHeader header = new BACnetTagHeader(tagNumber, TagClass.CONTEXT_SPECIFIC_TAGS, 6, extTagNumber, null, null, null);
        return new BACnetOpeningTag(header, tagNum);
    }

    public static BACnetClosingTag createBACnetClosingTag(short tagNum) {
        byte tagNumber;
        Short extTagNumber = null;
        if (tagNum <= 14) {
            tagNumber = (byte)tagNum;
        } else {
            tagNumber = 15;
            extTagNumber = tagNum;
        }
        BACnetTagHeader header = new BACnetTagHeader(tagNumber, TagClass.CONTEXT_SPECIFIC_TAGS, 7, extTagNumber, null, null, null);
        return new BACnetClosingTag(header, tagNum);
    }

    public static BACnetApplicationTagObjectIdentifier createBACnetApplicationTagObjectIdentifier(short objectType, int instance) {
        BACnetTagHeader header = new BACnetTagHeader((byte)BACnetDataType.BACNET_OBJECT_IDENTIFIER.getValue(), TagClass.APPLICATION_TAGS, 4, null, null, null, null);
        BACnetObjectType objectTypeEnum = BACnetObjectType.enumForValue(objectType);
        short proprietaryValue = 0;
        if (objectType >= 128 || !BACnetObjectType.isDefined(objectType).booleanValue()) {
            objectTypeEnum = BACnetObjectType.VENDOR_PROPRIETARY_VALUE;
            proprietaryValue = objectType;
        }
        BACnetTagPayloadObjectIdentifier payload = new BACnetTagPayloadObjectIdentifier(objectTypeEnum, proprietaryValue, instance);
        return new BACnetApplicationTagObjectIdentifier(header, payload);
    }

    public static BACnetContextTagObjectIdentifier createBACnetContextTagObjectIdentifier(byte tagNum, short objectType, int instance) {
        BACnetTagHeader header = new BACnetTagHeader(tagNum, TagClass.CONTEXT_SPECIFIC_TAGS, 4, null, null, null, null);
        BACnetObjectType objectTypeEnum = BACnetObjectType.enumForValue(objectType);
        short proprietaryValue = 0;
        if (objectType >= 128 || !BACnetObjectType.isDefined(objectType).booleanValue()) {
            objectTypeEnum = BACnetObjectType.VENDOR_PROPRIETARY_VALUE;
            proprietaryValue = objectType;
        }
        BACnetTagPayloadObjectIdentifier payload = new BACnetTagPayloadObjectIdentifier(objectTypeEnum, proprietaryValue, instance);
        return new BACnetContextTagObjectIdentifier(header, payload, Short.valueOf(tagNum));
    }

    public static BACnetPropertyIdentifierTagged createBACnetPropertyIdentifierTagged(byte tagNum, int propertyType) {
        BACnetPropertyIdentifier propertyIdentifier = BACnetPropertyIdentifier.enumForValue(propertyType);
        int proprietaryValue = 0;
        if (!BACnetPropertyIdentifier.isDefined(propertyType).booleanValue()) {
            propertyIdentifier = BACnetPropertyIdentifier.VENDOR_PROPRIETARY_VALUE;
            proprietaryValue = propertyType;
        }
        BACnetTagHeader header = new BACnetTagHeader(tagNum, TagClass.CONTEXT_SPECIFIC_TAGS, (byte)StaticHelper.requiredLength(propertyType), null, null, null, null);
        return new BACnetPropertyIdentifierTagged(header, propertyIdentifier, proprietaryValue, Short.valueOf(tagNum), TagClass.CONTEXT_SPECIFIC_TAGS);
    }

    public static BACnetVendorIdTagged createBACnetVendorIdApplicationTagged(int vendorId) {
        BACnetVendorId baCnetVendorId = BACnetVendorId.enumForValue(vendorId);
        int unknownVendorId = 0;
        if (!BACnetVendorId.isDefined(vendorId).booleanValue()) {
            baCnetVendorId = BACnetVendorId.UNKNOWN_VENDOR;
            unknownVendorId = vendorId;
        }
        BACnetTagHeader header = new BACnetTagHeader(2, TagClass.APPLICATION_TAGS, (byte)StaticHelper.requiredLength(vendorId), null, null, null, null);
        return new BACnetVendorIdTagged(header, baCnetVendorId, unknownVendorId, (short)2, TagClass.APPLICATION_TAGS);
    }

    public static BACnetVendorIdTagged createBACnetVendorIdContextTagged(byte tagNum, int vendorId) {
        BACnetVendorId baCnetVendorId = BACnetVendorId.enumForValue(vendorId);
        int unknownVendorId = 0;
        if (!BACnetVendorId.isDefined(vendorId).booleanValue()) {
            baCnetVendorId = BACnetVendorId.UNKNOWN_VENDOR;
            unknownVendorId = vendorId;
        }
        BACnetTagHeader header = new BACnetTagHeader(tagNum, TagClass.CONTEXT_SPECIFIC_TAGS, (byte)StaticHelper.requiredLength(vendorId), null, null, null, null);
        return new BACnetVendorIdTagged(header, baCnetVendorId, unknownVendorId, Short.valueOf(tagNum), TagClass.CONTEXT_SPECIFIC_TAGS);
    }

    public static BACnetSegmentationTagged creatBACnetSegmentationTagged(BACnetSegmentation value) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, (short)9, 1L);
        return new BACnetSegmentationTagged(header, value, (short)9, TagClass.APPLICATION_TAGS);
    }

    public static BACnetApplicationTagBoolean createBACnetApplicationTagBoolean(boolean value) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.BOOLEAN.getValue(), value ? 1L : 0L);
        return new BACnetApplicationTagBoolean(header, new BACnetTagPayloadBoolean(value ? 1L : 0L));
    }

    public static BACnetContextTagBoolean createBACnetContextTagBoolean(byte tagNumber, boolean value) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, 1L);
        return new BACnetContextTagBoolean(header, (short)(value ? 1 : 0), new BACnetTagPayloadBoolean(value ? 1L : 0L), Short.valueOf(tagNumber));
    }

    public static BACnetApplicationTagUnsignedInteger createBACnetApplicationTagUnsignedInteger(long value) {
        Pair<Long, BACnetTagPayloadUnsignedInteger> lengthPayload = StaticHelper.createUnsignedPayload(value);
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.UNSIGNED_INTEGER.getValue(), (Long)lengthPayload.getLeft());
        return new BACnetApplicationTagUnsignedInteger(header, (BACnetTagPayloadUnsignedInteger)lengthPayload.getRight());
    }

    public static BACnetContextTagUnsignedInteger createBACnetContextTagUnsignedInteger(byte tagNumber, long value) {
        Pair<Long, BACnetTagPayloadUnsignedInteger> lengthPayload = StaticHelper.createUnsignedPayload(value);
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, (Long)lengthPayload.getLeft());
        return new BACnetContextTagUnsignedInteger(header, (BACnetTagPayloadUnsignedInteger)lengthPayload.getRight(), Short.valueOf(tagNumber));
    }

    public static Pair<Long, BACnetTagPayloadUnsignedInteger> createUnsignedPayload(long value) {
        long length;
        Short valueUint8 = null;
        Integer valueUint16 = null;
        Integer valueUint24 = null;
        Long valueUint32 = null;
        Long valueUint40 = null;
        Long valueUint48 = null;
        Long valueUint56 = null;
        BigInteger valueUint64 = null;
        if (value < 256L) {
            length = 1L;
            valueUint8 = (short)value;
        } else if (value < 65536L) {
            length = 2L;
            valueUint16 = (int)value;
        } else if (value < 0x1000000L) {
            length = 3L;
            valueUint24 = (int)value;
        } else {
            length = 4L;
            valueUint32 = value;
        }
        BACnetTagPayloadUnsignedInteger payload = new BACnetTagPayloadUnsignedInteger(valueUint8, valueUint16, valueUint24, valueUint32, valueUint40, valueUint48, valueUint56, valueUint64, length);
        return Pair.of((Object)length, (Object)payload);
    }

    public static BACnetApplicationTagSignedInteger createBACnetApplicationTagSignedInteger(long value) {
        Pair<Long, BACnetTagPayloadSignedInteger> lengthPayload = StaticHelper.createSignedPayload(value);
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.SIGNED_INTEGER.getValue(), (Long)lengthPayload.getLeft());
        return new BACnetApplicationTagSignedInteger(header, (BACnetTagPayloadSignedInteger)lengthPayload.getRight());
    }

    public static BACnetContextTagSignedInteger createBACnetContextTagSignedInteger(short tagNumber, long value) {
        Pair<Long, BACnetTagPayloadSignedInteger> lengthPayload = StaticHelper.createSignedPayload(value);
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, (byte)tagNumber, (Long)lengthPayload.getLeft());
        return new BACnetContextTagSignedInteger(header, (BACnetTagPayloadSignedInteger)lengthPayload.getRight(), tagNumber);
    }

    public static Pair<Long, BACnetTagPayloadSignedInteger> createSignedPayload(long value) {
        long length;
        Byte valueInt8 = null;
        Short valueInt16 = null;
        Integer valueInt24 = null;
        Integer valueInt32 = null;
        if (value < 256L) {
            length = 1L;
            valueInt8 = (byte)value;
        } else if (value < 65536L) {
            length = 2L;
            valueInt16 = (short)value;
        } else if (value < 0x1000000L) {
            length = 3L;
            valueInt24 = (int)value;
        } else {
            length = 4L;
            valueInt32 = (int)value;
        }
        BACnetTagPayloadSignedInteger payload = new BACnetTagPayloadSignedInteger(valueInt8, valueInt16, valueInt24, valueInt32, null, null, null, null, length);
        return Pair.of((Object)length, (Object)payload);
    }

    public static BACnetApplicationTagReal createBACnetApplicationTagReal(float value) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.REAL.getValue(), 4L);
        return new BACnetApplicationTagReal(header, new BACnetTagPayloadReal(value));
    }

    public static BACnetContextTagReal createBACnetContextTagReal(byte tagNumber, float value) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, 4L);
        return new BACnetContextTagReal(header, new BACnetTagPayloadReal(value), Short.valueOf(tagNumber));
    }

    public static BACnetApplicationTagDouble createBACnetApplicationTagDouble(double value) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.DOUBLE.getValue(), 8L);
        return new BACnetApplicationTagDouble(header, new BACnetTagPayloadDouble(value));
    }

    public static BACnetContextTagDouble createBACnetContextTagDouble(byte tagNumber, double value) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, 8L);
        return new BACnetContextTagDouble(header, new BACnetTagPayloadDouble(value), Short.valueOf(tagNumber));
    }

    public static BACnetApplicationTagOctetString createBACnetApplicationTagOctetString(byte[] octets) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.OCTET_STRING.getValue(), octets.length + 1);
        return new BACnetApplicationTagOctetString(header, new BACnetTagPayloadOctetString(octets, (long)octets.length + 1L));
    }

    public static BACnetContextTagOctetString createBACnetContextTagOctetString(byte tagNumber, byte[] octets) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, octets.length + 1);
        return new BACnetContextTagOctetString(header, new BACnetTagPayloadOctetString(octets, (long)octets.length + 1L), Short.valueOf(tagNumber));
    }

    public static BACnetApplicationTagCharacterString createBACnetApplicationTagCharacterString(BACnetCharacterEncoding baCnetCharacterEncoding, String value) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.CHARACTER_STRING.getValue(), value.length() + 1);
        return new BACnetApplicationTagCharacterString(header, new BACnetTagPayloadCharacterString(baCnetCharacterEncoding, value, (long)value.length() + 1L));
    }

    public static BACnetContextTagCharacterString createBACnetContextTagCharacterString(byte tagNumber, BACnetCharacterEncoding baCnetCharacterEncoding, String value) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, value.length() + 1);
        return new BACnetContextTagCharacterString(header, new BACnetTagPayloadCharacterString(baCnetCharacterEncoding, value, (long)value.length() + 1L), Short.valueOf(tagNumber));
    }

    public static BACnetApplicationTagBitString createBACnetApplicationTagBitString(List<Boolean> value) {
        long numberOfBytesNeeded = (value.size() + 7) / 8;
        short unusedBits = (short)(8 - value.size() % 8);
        if (unusedBits == 8) {
            unusedBits = 0;
        }
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.BIT_STRING.getValue(), numberOfBytesNeeded + 1L);
        return new BACnetApplicationTagBitString(header, new BACnetTagPayloadBitString(unusedBits, value, new ArrayList<Boolean>(unusedBits), numberOfBytesNeeded + 1L));
    }

    public static BACnetContextTagBitString createBACnetContextTagBitString(byte tagNumber, List<Boolean> value) {
        long numberOfBytesNeeded = (value.size() + 7) / 8;
        short unusedBits = (short)(8 - value.size() % 8);
        if (unusedBits == 8) {
            unusedBits = 0;
        }
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, numberOfBytesNeeded + 1L);
        return new BACnetContextTagBitString(header, new BACnetTagPayloadBitString(unusedBits, value, new ArrayList<Boolean>(unusedBits), numberOfBytesNeeded + 1L), Short.valueOf(tagNumber));
    }

    public static BACnetApplicationTagEnumerated createBACnetApplicationTagEnumerated(long value) {
        Pair<Long, BACnetTagPayloadEnumerated> lengthPayload = StaticHelper.CreateEnumeratedPayload(value);
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.ENUMERATED.getValue(), (Long)lengthPayload.getLeft());
        return new BACnetApplicationTagEnumerated(header, (BACnetTagPayloadEnumerated)lengthPayload.getRight());
    }

    public static BACnetContextTagEnumerated createBACnetContextTagEnumerated(byte tagNumber, long value) {
        Pair<Long, BACnetTagPayloadEnumerated> lengthPayload = StaticHelper.CreateEnumeratedPayload(value);
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, (Long)lengthPayload.getLeft());
        return new BACnetContextTagEnumerated(header, (BACnetTagPayloadEnumerated)lengthPayload.getRight(), Short.valueOf(tagNumber));
    }

    public static Pair<Long, BACnetTagPayloadEnumerated> CreateEnumeratedPayload(long value) {
        long length = StaticHelper.requiredLength(value);
        byte[] data = StaticHelper.writeVarUint(value);
        BACnetTagPayloadEnumerated payload = new BACnetTagPayloadEnumerated(data, length);
        return Pair.of((Object)length, (Object)payload);
    }

    public static BACnetApplicationTagDate createBACnetApplicationTagDate(int year, short month, short dayOfMonth, short dayOfWeek) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.DATE.getValue(), 4L);
        short yearMinus1900 = (short)(year - 1900);
        if (year == 255) {
            yearMinus1900 = 255;
        }
        return new BACnetApplicationTagDate(header, new BACnetTagPayloadDate(yearMinus1900, month, dayOfMonth, dayOfWeek));
    }

    public static BACnetContextTagDate createBACnetContextTagDate(byte tagNumber, int year, short month, short dayOfMonth, short dayOfWeek) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, 4L);
        short yearMinus1900 = (short)(year - 1900);
        if (year == 255) {
            yearMinus1900 = 255;
        }
        return new BACnetContextTagDate(header, new BACnetTagPayloadDate(yearMinus1900, month, dayOfMonth, dayOfWeek), Short.valueOf(tagNumber));
    }

    public static BACnetApplicationTagTime createBACnetApplicationTagTime(short hour, short minute, short second, short fractional) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(false, BACnetDataType.TIME.getValue(), 4L);
        return new BACnetApplicationTagTime(header, new BACnetTagPayloadTime(hour, minute, second, fractional));
    }

    public static BACnetContextTagTime createBACnetContextTagTime(byte tagNumber, short hour, short minute, short second, short fractional) {
        BACnetTagHeader header = StaticHelper.createBACnetTagHeaderBalanced(true, tagNumber, 4L);
        return new BACnetContextTagTime(header, new BACnetTagPayloadTime(hour, minute, second, fractional), Short.valueOf(tagNumber));
    }

    private static long requiredLength(long value) {
        long length = value < 256L ? 1L : (value < 65536L ? 2L : (value < 0x1000000L ? 3L : 4L));
        return length;
    }
}

