/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.genericcan.readwrite;

import java.math.BigInteger;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.genericcan.readwrite.GenericCANDataType;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, GenericCANDataType dataType) throws ParseException {
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BYTE))) {
            Byte value = readBuffer.readByte("", new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BOOLEAN))) {
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED8))) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED16))) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED24))) {
            Integer value = readBuffer.readUnsignedInt("", 24, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED32))) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED40))) {
            Long value = readBuffer.readUnsignedLong("", 40, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED48))) {
            Long value = readBuffer.readUnsignedLong("", 48, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED56))) {
            Long value = readBuffer.readUnsignedLong("", 56, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED64))) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER8))) {
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER16))) {
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER24))) {
            Integer value = readBuffer.readInt("", 24, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER32))) {
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER40))) {
            Long value = readBuffer.readLong("", 40, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER48))) {
            Long value = readBuffer.readLong("", 48, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER56))) {
            Long value = readBuffer.readLong("", 56, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER64))) {
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL32))) {
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL64))) {
            Double value = readBuffer.readDouble("", 64, new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        return null;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, GenericCANDataType dataType) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataType, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, GenericCANDataType dataType, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BYTE))) {
            byte value = _value.getByte();
            writeBuffer.writeByte("", ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BOOLEAN))) {
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED8))) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED16))) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED24))) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 24, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED32))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED40))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 40, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED48))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 48, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED56))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 56, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED64))) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER8))) {
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER16))) {
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER24))) {
            int value = _value.getInt();
            writeBuffer.writeInt("", 24, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER32))) {
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER40))) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 40, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER48))) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 48, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER56))) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 56, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER64))) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL32))) {
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL64))) {
            double value = _value.getDouble();
            writeBuffer.writeDouble("", 64, value, new WithWriterArgs[0]);
        }
    }

    public static int getLengthInBytes(PlcValue _value, GenericCANDataType dataType) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataType) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, GenericCANDataType dataType) {
        int sizeInBits = 0;
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BYTE))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BOOLEAN))) {
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED8))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED16))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED24))) {
            sizeInBits += 24;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED32))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED40))) {
            sizeInBits += 40;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED48))) {
            sizeInBits += 48;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED56))) {
            sizeInBits += 56;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED64))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER8))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER16))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER24))) {
            sizeInBits += 24;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER32))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER40))) {
            sizeInBits += 40;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER48))) {
            sizeInBits += 48;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER56))) {
            sizeInBits += 56;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER64))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL32))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL64))) {
            sizeInBits += 64;
        }
        return sizeInBits;
    }
}

