/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.can.adapter;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.can.adapter.Plc4xCANProtocolBase;
import org.apache.plc4x.java.can.adapter.conversation.ConversationContextWrapper;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.transport.can.CANTransport;
import org.apache.plc4x.java.transport.can.FrameData;

public class CANDriverAdapter<C, T>
extends Plc4xProtocolBase<C> {
    private final Plc4xCANProtocolBase<T> delegate;
    private final Class<C> wireType;
    private final Function<C, FrameData> adapter;
    private final CANTransport.FrameHandler<C, T> frameHandler;
    private final PlcTagHandler tagHandler;

    public CANDriverAdapter(Plc4xCANProtocolBase<T> delegate, Class<C> wireType, Function<C, FrameData> adapter, CANTransport.FrameHandler<C, T> frameHandler, PlcTagHandler tagHandler) {
        this.delegate = delegate;
        this.wireType = wireType;
        this.adapter = adapter;
        this.frameHandler = frameHandler;
        this.tagHandler = tagHandler;
    }

    public void setDriverContext(DriverContext driverContext) {
        this.delegate.setDriverContext(driverContext);
    }

    public DriverContext getDriverContext() {
        return this.delegate.getDriverContext();
    }

    public void setConversationContext(ConversationContext<C> conversationContext) {
        this.delegate.setConversationContext(new ConversationContextWrapper<C, T>(conversationContext, this.wireType, this.adapter, this.frameHandler, conversationContext.getAuthentication()));
    }

    public PlcTagHandler getTagHandler() {
        return this.tagHandler;
    }

    public void onConnect(ConversationContext<C> context) {
        this.delegate.onConnect(new ConversationContextWrapper<C, T>(context, this.wireType, this.adapter, this.frameHandler, context.getAuthentication()));
    }

    public void onDisconnect(ConversationContext<C> context) {
        this.delegate.onDisconnect(new ConversationContextWrapper<C, T>(context, this.wireType, this.adapter, this.frameHandler, context.getAuthentication()));
    }

    protected void decode(ConversationContext<C> context, C msg) throws Exception {
        this.delegate.decode(new ConversationContextWrapper<C, T>(context, this.wireType, this.adapter, this.frameHandler, context.getAuthentication()), this.frameHandler.fromCAN(this.adapter.apply(msg)));
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        return this.delegate.read(readRequest);
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        return this.delegate.write(writeRequest);
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        return this.delegate.subscribe(subscriptionRequest);
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        return this.delegate.unsubscribe(unsubscriptionRequest);
    }

    public void close(ConversationContext<C> context) {
        this.delegate.close(new ConversationContextWrapper<C, T>(context, this.wireType, this.adapter, this.frameHandler, context.getAuthentication()));
    }
}

