/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.api.segmentation.accumulator;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.plc4x.java.canopen.api.segmentation.accumulator.Storage;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateDownloadRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateExpeditedUploadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateUploadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDORequest;
import org.apache.plc4x.java.canopen.readwrite.SDOResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentDownloadRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentUploadResponse;

public class ByteStorage<T>
implements Storage<T, byte[]> {
    private final List<byte[]> segments = new ArrayList<byte[]>();
    private final Function<T, byte[]> extractor;
    private long size = 0L;

    public ByteStorage(Function<T, byte[]> extractor) {
        this.extractor = extractor;
    }

    @Override
    public void append(T frame) {
        this.segments.add(this.extractor.apply(frame));
        this.size += (long)this.segments.get(this.segments.size() - 1).length;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public byte[] get() {
        Optional collect = this.segments.stream().reduce((b1, b2) -> {
            byte[] combined = new byte[((byte[])b1).length + ((byte[])b2).length];
            System.arraycopy(b1, 0, combined, 0, ((byte[])b1).length);
            System.arraycopy(b2, 0, combined, ((byte[])b1).length, ((byte[])b2).length);
            return combined;
        });
        return collect.orElse(new byte[0]);
    }

    public static class SDODownloadStorage
    extends ByteStorage<SDORequest> {
        public SDODownloadStorage() {
            super(sdoRequest -> {
                SDOInitiateDownloadRequest initiate;
                if (sdoRequest instanceof SDOSegmentDownloadRequest) {
                    return ((SDOSegmentDownloadRequest)sdoRequest).getData();
                }
                if (sdoRequest instanceof SDOInitiateDownloadRequest && (initiate = (SDOInitiateDownloadRequest)sdoRequest).getPayload() instanceof SDOInitiateExpeditedUploadResponse) {
                    return ((SDOInitiateExpeditedUploadResponse)initiate.getPayload()).getData();
                }
                return new byte[0];
            });
        }
    }

    public static class SDOUploadStorage
    extends ByteStorage<SDOResponse> {
        public SDOUploadStorage() {
            super(sdoResponse -> {
                SDOInitiateUploadResponse initiate;
                if (sdoResponse instanceof SDOSegmentUploadResponse) {
                    return ((SDOSegmentUploadResponse)sdoResponse).getData();
                }
                if (sdoResponse instanceof SDOInitiateUploadResponse && (initiate = (SDOInitiateUploadResponse)sdoResponse).getPayload() instanceof SDOInitiateExpeditedUploadResponse) {
                    return ((SDOInitiateExpeditedUploadResponse)initiate.getPayload()).getData();
                }
                return new byte[0];
            });
        }
    }
}

