/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.tag;

import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.canopen.tag.CANOpenHeartbeatTag;
import org.apache.plc4x.java.canopen.tag.CANOpenNMTTag;
import org.apache.plc4x.java.canopen.tag.CANOpenPDOTag;
import org.apache.plc4x.java.canopen.tag.CANOpenSDOTag;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class CANOpenTag
implements PlcTag,
Serializable {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?:(0[xX](?<indexHex>[0-9a-fA-F]+))|(?<index>\\d+))/(?:(0[xX](?<subIndexHex>[0-9a-fA-F]+))|(?<subIndex>\\d+)):(?<canDataType>\\w+)(\\[(?<numberOfElements>\\d)])?");
    public static final Pattern NODE_PATTERN = Pattern.compile("(?<nodeId>\\d+)");
    private final int nodeId;

    public CANOpenTag(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public static CANOpenTag of(String addressString) throws PlcInvalidTagException {
        if (CANOpenSDOTag.matches(addressString)) {
            return CANOpenSDOTag.of(addressString);
        }
        if (CANOpenPDOTag.matches(addressString)) {
            return CANOpenPDOTag.of(addressString);
        }
        if (CANOpenNMTTag.matches(addressString)) {
            return CANOpenNMTTag.of(addressString);
        }
        if (CANOpenHeartbeatTag.matches(addressString)) {
            return CANOpenHeartbeatTag.of(addressString);
        }
        throw new PlcInvalidTagException("Unable to parse address: " + addressString);
    }
}

