/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.canopen.readwrite.SDOAbortResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOBlockResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateDownloadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateUploadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOResponseCommand;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentDownloadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentUploadResponse;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class SDOResponse
implements Message {
    public abstract SDOResponseCommand getCommand();

    protected abstract void serializeSDOResponseChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SDOResponse", new WithWriterArgs[0]);
        this.serializeSDOResponseChild(writeBuffer);
        writeBuffer.popContext("SDOResponse", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        SDOResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits;
    }

    public static SDOResponse staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        SDOResponseCommand command;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof SDOResponseCommand) {
            command = (SDOResponseCommand)((Object)args[0]);
        } else if (args[0] instanceof String) {
            command = SDOResponseCommand.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type SDOResponseCommand or a string which is parseable but was " + args[0].getClass().getName());
        }
        return SDOResponse.staticParse(readBuffer, command);
    }

    public static SDOResponse staticParse(ReadBuffer readBuffer, SDOResponseCommand command) throws ParseException {
        readBuffer.pullContext("SDOResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        SDOResponseBuilder builder = null;
        if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDOResponseCommand.SEGMENT_UPLOAD))) {
            builder = SDOSegmentUploadResponse.staticParseSDOResponseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDOResponseCommand.SEGMENT_DOWNLOAD))) {
            builder = SDOSegmentDownloadResponse.staticParseSDOResponseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDOResponseCommand.INITIATE_UPLOAD))) {
            builder = SDOInitiateUploadResponse.staticParseSDOResponseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDOResponseCommand.INITIATE_DOWNLOAD))) {
            builder = SDOInitiateDownloadResponse.staticParseSDOResponseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDOResponseCommand.ABORT))) {
            builder = SDOAbortResponse.staticParseSDOResponseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDOResponseCommand.BLOCK))) {
            builder = SDOBlockResponse.staticParseSDOResponseBuilder(readBuffer, command);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [command=" + (Object)((Object)command) + "]");
        }
        readBuffer.closeContext("SDOResponse", new WithReaderArgs[0]);
        SDOResponse _sDOResponse = builder.build();
        return _sDOResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SDOResponse)) {
            return false;
        }
        SDOResponse that = (SDOResponse)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface SDOResponseBuilder {
        public SDOResponse build();
    }
}

