/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum CANOpenDataType {
    BOOLEAN(0L, "BIT", 1),
    UNSIGNED8(1L, "USINT", 8),
    UNSIGNED16(2L, "UINT", 16),
    UNSIGNED24(3L, "RAW_BYTE_ARRAY", 24),
    UNSIGNED32(4L, "UDINT", 32),
    UNSIGNED40(5L, "RAW_BYTE_ARRAY", 40),
    UNSIGNED48(6L, "RAW_BYTE_ARRAY", 48),
    UNSIGNED56(7L, "RAW_BYTE_ARRAY", 56),
    UNSIGNED64(8L, "ULINT", 64),
    INTEGER8(9L, "SINT", 8),
    INTEGER16(10L, "INT", 16),
    INTEGER24(11L, "RAW_BYTE_ARRAY", 24),
    INTEGER32(12L, "DINT", 32),
    INTEGER40(13L, "RAW_BYTE_ARRAY", 40),
    INTEGER48(14L, "RAW_BYTE_ARRAY", 48),
    INTEGER56(15L, "RAW_BYTE_ARRAY", 56),
    INTEGER64(16L, "LINT", 64),
    REAL32(17L, "REAL", 32),
    REAL64(18L, "LREAL", 64),
    RECORD(19L, "RAW_BYTE_ARRAY", 8),
    OCTET_STRING(20L, "RAW_BYTE_ARRAY", 8),
    VISIBLE_STRING(21L, "CHAR", 8),
    UNICODE_STRING(22L, "WCHAR", 16),
    TIME_OF_DAY(23L, "TIME_OF_DAY", 48),
    TIME_DIFFERENCE(24L, "TIME", 48);

    private static final Map<Long, CANOpenDataType> map;
    private final long value;
    private final String plcValueName;
    private final short numBits;

    static {
        map = new HashMap<Long, CANOpenDataType>();
        CANOpenDataType[] cANOpenDataTypeArray = CANOpenDataType.values();
        int n = cANOpenDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CANOpenDataType value = cANOpenDataTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private CANOpenDataType(long value, String plcValueName, short numBits) {
        this.value = value;
        this.plcValueName = plcValueName;
        this.numBits = numBits;
    }

    public long getValue() {
        return this.value;
    }

    public String getPlcValueName() {
        return this.plcValueName;
    }

    public static CANOpenDataType firstEnumForFieldPlcValueName(String fieldValue) {
        CANOpenDataType[] cANOpenDataTypeArray = CANOpenDataType.values();
        int n = cANOpenDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CANOpenDataType _val = cANOpenDataTypeArray[n2];
            if (_val.getPlcValueName().equals(fieldValue)) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<CANOpenDataType> enumsForFieldPlcValueName(String fieldValue) {
        ArrayList<CANOpenDataType> _values = new ArrayList<CANOpenDataType>();
        CANOpenDataType[] cANOpenDataTypeArray = CANOpenDataType.values();
        int n = cANOpenDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CANOpenDataType _val = cANOpenDataTypeArray[n2];
            if (_val.getPlcValueName().equals(fieldValue)) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public short getNumBits() {
        return this.numBits;
    }

    public static CANOpenDataType firstEnumForFieldNumBits(short fieldValue) {
        CANOpenDataType[] cANOpenDataTypeArray = CANOpenDataType.values();
        int n = cANOpenDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CANOpenDataType _val = cANOpenDataTypeArray[n2];
            if (_val.getNumBits() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<CANOpenDataType> enumsForFieldNumBits(short fieldValue) {
        ArrayList<CANOpenDataType> _values = new ArrayList<CANOpenDataType>();
        CANOpenDataType[] cANOpenDataTypeArray = CANOpenDataType.values();
        int n = cANOpenDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CANOpenDataType _val = cANOpenDataTypeArray[n2];
            if (_val.getNumBits() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static CANOpenDataType enumForValue(long value) {
        return map.get(value);
    }

    public static Boolean isDefined(long value) {
        return map.containsKey(value);
    }
}

