/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.IndexAddress;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class SDOSegment
implements Message {
    protected final boolean expedited;
    protected final boolean indicated;
    protected final IndexAddress address;
    protected final byte[] data;

    public SDOSegment(boolean expedited, boolean indicated, IndexAddress address, byte[] data) {
        this.expedited = expedited;
        this.indicated = indicated;
        this.address = address;
        this.data = data;
    }

    public boolean getExpedited() {
        return this.expedited;
    }

    public boolean getIndicated() {
        return this.indicated;
    }

    public IndexAddress getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.data;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SDOSegment", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)1), (WithWriterArgs[])new WithWriterArgs[0]);
        byte size = (byte)(this.getExpedited() && this.getIndicated() ? 4 - StaticHelper.COUNT((Object)this.getData()) : 0);
        FieldWriterFactory.writeImplicitField((String)"size", (Object)size, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)2), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"expedited", (Object)this.expedited, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"indicated", (Object)this.indicated, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"address", (Object)this.address, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writePaddingField((String)"padding", (int)(4 - StaticHelper.COUNT((Object)this.data)), (Object)0, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("SDOSegment", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        SDOSegment _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        lengthInBits += 2;
        ++lengthInBits;
        ++lengthInBits;
        lengthInBits += this.address.getLengthInBits();
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        int _timesPadding = 4 - StaticHelper.COUNT((Object)this.data);
        while (_timesPadding-- > 0) {
            lengthInBits += 8;
        }
        return lengthInBits;
    }

    public static SDOSegment staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("SDOSegment", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)1), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        byte size = (Byte)FieldReaderFactory.readImplicitField((String)"size", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)2), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean expedited = (Boolean)FieldReaderFactory.readSimpleField((String)"expedited", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean indicated = (Boolean)FieldReaderFactory.readSimpleField((String)"indicated", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        IndexAddress address = (IndexAddress)FieldReaderFactory.readSimpleField((String)"address", (DataReader)DataReaderFactory.readComplex(() -> IndexAddress.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(expedited && indicated ? 4 - size : 0), new WithReaderArgs[0]);
        FieldReaderFactory.readPaddingField((DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (int)(4 - StaticHelper.COUNT((Object)data)), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("SDOSegment", new WithReaderArgs[0]);
        SDOSegment _sDOSegment = new SDOSegment(expedited, indicated, address, data);
        return _sDOSegment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SDOSegment)) {
            return false;
        }
        SDOSegment that = (SDOSegment)o;
        return this.getExpedited() == that.getExpedited() && this.getIndicated() == that.getIndicated() && this.getAddress() == that.getAddress() && this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(this.getExpedited(), this.getIndicated(), this.getAddress(), this.getData());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

