/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.eip.readwrite.PathSegment;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CipUnconnectedRequest
extends CipService
implements Message {
    public static final Integer ROUTE = 1;
    protected final PathSegment classSegment;
    protected final PathSegment instanceSegment;
    protected final CipService unconnectedService;
    protected final byte backPlane;
    protected final byte slot;

    @Override
    public Byte getService() {
        return (byte)82;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    @Override
    public Boolean getConnected() {
        return false;
    }

    public CipUnconnectedRequest(PathSegment classSegment, PathSegment instanceSegment, CipService unconnectedService, byte backPlane, byte slot) {
        this.classSegment = classSegment;
        this.instanceSegment = instanceSegment;
        this.unconnectedService = unconnectedService;
        this.backPlane = backPlane;
        this.slot = slot;
    }

    public PathSegment getClassSegment() {
        return this.classSegment;
    }

    public PathSegment getInstanceSegment() {
        return this.instanceSegment;
    }

    public CipService getUnconnectedService() {
        return this.unconnectedService;
    }

    public byte getBackPlane() {
        return this.backPlane;
    }

    public byte getSlot() {
        return this.slot;
    }

    public int getRoute() {
        return ROUTE;
    }

    @Override
    protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CipUnconnectedRequest", new WithWriterArgs[0]);
        short requestPathSize = (short)((this.getClassSegment().getLengthInBytes() + this.getInstanceSegment().getLengthInBytes()) / 2);
        FieldWriterFactory.writeImplicitField((String)"requestPathSize", (Object)requestPathSize, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"classSegment", (Object)this.classSegment, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"instanceSegment", (Object)this.instanceSegment, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)40197, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        int messageSize = this.getLengthInBytes() - 10 - 4;
        FieldWriterFactory.writeImplicitField((String)"messageSize", (Object)messageSize, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"unconnectedService", (Object)this.unconnectedService, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"route", (Object)ROUTE, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"backPlane", (Object)this.backPlane, (DataWriter)DataWriterFactory.writeSignedByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"slot", (Object)this.slot, (DataWriter)DataWriterFactory.writeSignedByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CipUnconnectedRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CipUnconnectedRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += this.classSegment.getLengthInBits();
        lengthInBits += this.instanceSegment.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += this.unconnectedService.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 8;
        return lengthInBits += 8;
    }

    public static CipService.CipServiceBuilder staticParseCipServiceBuilder(ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
        readBuffer.pullContext("CipUnconnectedRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short requestPathSize = (Short)FieldReaderFactory.readImplicitField((String)"requestPathSize", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        PathSegment classSegment = (PathSegment)FieldReaderFactory.readSimpleField((String)"classSegment", (DataReader)new DataReaderComplexDefault(() -> PathSegment.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PathSegment instanceSegment = (PathSegment)FieldReaderFactory.readSimpleField((String)"instanceSegment", (DataReader)new DataReaderComplexDefault(() -> PathSegment.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Integer reservedField0 = (Integer)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)40197, (WithReaderArgs[])new WithReaderArgs[0]);
        int messageSize = (Integer)FieldReaderFactory.readImplicitField((String)"messageSize", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        CipService unconnectedService = (CipService)FieldReaderFactory.readSimpleField((String)"unconnectedService", (DataReader)new DataReaderComplexDefault(() -> CipService.staticParse(readBuffer, false, messageSize), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int route = (Integer)FieldReaderFactory.readConstField((String)"route", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)ROUTE, (WithReaderArgs[])new WithReaderArgs[0]);
        byte backPlane = (Byte)FieldReaderFactory.readSimpleField((String)"backPlane", (DataReader)DataReaderFactory.readSignedByte((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        byte slot = (Byte)FieldReaderFactory.readSimpleField((String)"slot", (DataReader)DataReaderFactory.readSignedByte((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CipUnconnectedRequest", new WithReaderArgs[0]);
        return new CipUnconnectedRequestBuilderImpl(classSegment, instanceSegment, unconnectedService, backPlane, slot);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipUnconnectedRequest)) {
            return false;
        }
        CipUnconnectedRequest that = (CipUnconnectedRequest)o;
        return this.getClassSegment() == that.getClassSegment() && this.getInstanceSegment() == that.getInstanceSegment() && this.getUnconnectedService() == that.getUnconnectedService() && this.getBackPlane() == that.getBackPlane() && this.getSlot() == that.getSlot() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getClassSegment(), this.getInstanceSegment(), this.getUnconnectedService(), this.getBackPlane(), this.getSlot());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CipUnconnectedRequestBuilderImpl
    implements CipService.CipServiceBuilder {
        private final PathSegment classSegment;
        private final PathSegment instanceSegment;
        private final CipService unconnectedService;
        private final byte backPlane;
        private final byte slot;

        public CipUnconnectedRequestBuilderImpl(PathSegment classSegment, PathSegment instanceSegment, CipService unconnectedService, byte backPlane, byte slot) {
            this.classSegment = classSegment;
            this.instanceSegment = instanceSegment;
            this.unconnectedService = unconnectedService;
            this.backPlane = backPlane;
            this.slot = slot;
        }

        @Override
        public CipUnconnectedRequest build() {
            CipUnconnectedRequest cipUnconnectedRequest = new CipUnconnectedRequest(this.classSegment, this.instanceSegment, this.unconnectedService, this.backPlane, this.slot);
            return cipUnconnectedRequest;
        }
    }
}

