/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.base.discovery;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItem;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItemHandler;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.messages.PlcDiscoveryResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.eip.readwrite.CipIdentity;
import org.apache.plc4x.java.eip.readwrite.CommandSpecificDataItem;
import org.apache.plc4x.java.eip.readwrite.EipConstants;
import org.apache.plc4x.java.eip.readwrite.EipListIdentityRequest;
import org.apache.plc4x.java.eip.readwrite.EipListIdentityResponse;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryResponse;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EipPlcDiscoverer
implements PlcDiscoverer {
    private final Logger logger = LoggerFactory.getLogger(EipPlcDiscoverer.class);

    public CompletableFuture<PlcDiscoveryResponse> discover(PlcDiscoveryRequest discoveryRequest) {
        return this.discoverWithHandler(discoveryRequest, null);
    }

    /*
     * Unable to fully structure code
     */
    public CompletableFuture<PlcDiscoveryResponse> discoverWithHandler(final PlcDiscoveryRequest discoveryRequest, PlcDiscoveryItemHandler handler) {
        future = new CompletableFuture<PlcDiscoveryResponse>();
        values = new ConcurrentLinkedQueue<E>();
        openSockets = new ArrayList<DatagramSocket>();
        try {
            try {
                for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                    if (networkInterface.isLoopback()) continue;
                    for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                        if (interfaceAddress.getBroadcast() == null || !(interfaceAddress.getAddress() instanceof Inet4Address)) continue;
                        inet4Address = (Inet4Address)interfaceAddress.getAddress();
                        discoverySocket = new DatagramSocket(EipConstants.EIPUDPDISCOVERYDEFAULTPORT, inet4Address);
                        discoverySocket.setBroadcast(true);
                        openSockets.add(discoverySocket);
                        thread = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(java.net.DatagramSocket org.apache.plc4x.java.api.messages.PlcDiscoveryItemHandler java.util.Queue ), ()V)((EipPlcDiscoverer)this, (DatagramSocket)discoverySocket, (PlcDiscoveryItemHandler)handler, values));
                        thread.start();
                        try {
                            discoveryPacket = new EipListIdentityRequest(0L, 0L, new byte[8], 0L);
                            writeBuffer = new WriteBufferByteBased(discoveryPacket.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
                            discoveryPacket.serialize((WriteBuffer)writeBuffer);
                            broadcastAddress = interfaceAddress.getBroadcast();
                            discoveryRequestPacket = new DatagramPacket(writeBuffer.getBytes(), writeBuffer.getBytes().length, broadcastAddress, EipConstants.EIPUDPDISCOVERYDEFAULTPORT);
                            discoverySocket.send(discoveryRequestPacket);
                        }
                        catch (SerializationException e) {
                            this.logger.error("Error serializing EIP discovery request", (Throwable)e);
                        }
                        catch (IOException e) {
                            this.logger.error("Error sending EIP discover request", (Throwable)e);
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            ** for (openSocket : openSockets)
        }
lbl-1000:
        // 1 sources

        {
            openSocket.close();
            continue;
        }
lbl43:
        // 1 sources

        timer = new Timer("Discovery Timeout");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DefaultPlcDiscoveryResponse response = new DefaultPlcDiscoveryResponse(discoveryRequest, PlcResponseCode.OK, new ArrayList(values));
                timer.cancel();
                timer.purge();
                future.complete(response);
            }
        }, 5000L);
        return future;
    }

    public static void main(String[] args) throws Exception {
        EipPlcDiscoverer discoverer = new EipPlcDiscoverer();
        CompletableFuture<PlcDiscoveryResponse> discover = discoverer.discover(null);
        PlcDiscoveryResponse plcDiscoveryResponse = discover.get(6000L, TimeUnit.MILLISECONDS);
        for (PlcDiscoveryItem value : plcDiscoveryResponse.getValues()) {
            System.out.println(String.valueOf(value.getConnectionUrl()) + " (" + value.getName() + ")");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$0(DatagramSocket datagramSocket, PlcDiscoveryItemHandler plcDiscoveryItemHandler, Queue queue) {
        try {
            block5: while (true) {
                byte[] buffer = new byte[512];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                datagramSocket.receive(packet);
                InetAddress plcAddress = packet.getAddress();
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(packet.getData(), ByteOrder.LITTLE_ENDIAN);
                try {
                    EipPacket eipPacket = EipPacket.staticParse((ReadBuffer)readBuffer, true);
                    if (eipPacket.getCommand() != 99 || !eipPacket.getResponse().booleanValue()) continue;
                    EipListIdentityResponse listIdentityResponse = (EipListIdentityResponse)eipPacket;
                    Iterator<CommandSpecificDataItem> iterator = listIdentityResponse.getItems().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block5;
                        CommandSpecificDataItem commandSpecificDataItem = iterator.next();
                        if (!(commandSpecificDataItem instanceof CipIdentity)) continue;
                        CipIdentity identityItem = (CipIdentity)commandSpecificDataItem;
                        DefaultPlcDiscoveryItem plcDiscoveryItem = new DefaultPlcDiscoveryItem("eip", "tcp", String.valueOf(plcAddress.getHostAddress()) + ":" + EipConstants.EIPTCPDEFAULTPORT, Collections.emptyMap(), identityItem.getProductName(), Collections.emptyMap());
                        if (plcDiscoveryItemHandler != null) {
                            plcDiscoveryItemHandler.handle((PlcDiscoveryItem)plcDiscoveryItem);
                        }
                        queue.add(plcDiscoveryItem);
                    }
                }
                catch (ParseException e) {
                    this.logger.error("Error parsing EIP discovery response", (Throwable)e);
                }
            }
        }
        catch (SocketException e) {
            if ("Socket closed".equals(e.getMessage())) return;
            this.logger.error("Error receiving EIP discovery response", (Throwable)e);
            return;
        }
        catch (IOException e) {
            this.logger.error("Error reading EIP discovery response", (Throwable)e);
        }
    }
}

