/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.logix;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.eip.base.protocol.EipProtocolLogic;
import org.apache.plc4x.java.eip.base.tag.EipTag;
import org.apache.plc4x.java.eip.logix.configuration.LogixConfiguration;
import org.apache.plc4x.java.eip.logix.configuration.LogixTcpTransportConfiguration;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;

public class LogixDriver
extends GeneratedDriverBase<EipPacket> {
    public String getProtocolCode() {
        return "logix";
    }

    public String getProtocolName() {
        return "Logix CIP";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return LogixConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(LogixTcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("tcp");
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("tcp");
    }

    protected boolean awaitDisconnectComplete() {
        return true;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected ProtocolStackConfigurer<EipPacket> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(EipPacket.class, io -> EipPacket.staticParse(io, true)).withProtocol(EipProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withCorruptPacketRemover(CorruptPackageCleaner.class).littleEndian().build();
    }

    public EipTag prepareTag(String query) {
        return EipTag.of(query);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                return byteBuf.getUnsignedShortLE(byteBuf.readerIndex() + 2) + 24;
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != 0) {
                byteBuf.readByte();
            }
        }
    }
}

