/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipRRData;
import org.apache.plc4x.java.eip.readwrite.EipConnectionRequest;
import org.apache.plc4x.java.eip.readwrite.EipConnectionResponse;
import org.apache.plc4x.java.eip.readwrite.EipDisconnectRequest;
import org.apache.plc4x.java.eip.readwrite.EipListIdentityRequest;
import org.apache.plc4x.java.eip.readwrite.EipListIdentityResponse;
import org.apache.plc4x.java.eip.readwrite.ListServicesRequest;
import org.apache.plc4x.java.eip.readwrite.ListServicesResponse;
import org.apache.plc4x.java.eip.readwrite.NullCommandRequest;
import org.apache.plc4x.java.eip.readwrite.NullCommandResponse;
import org.apache.plc4x.java.eip.readwrite.NullEipConnectionResponse;
import org.apache.plc4x.java.eip.readwrite.NullListServicesResponse;
import org.apache.plc4x.java.eip.readwrite.SendUnitData;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class EipPacket
implements Message {
    protected final long sessionHandle;
    protected final long status;
    protected final byte[] senderContext;
    protected final long options;

    public abstract Integer getCommand();

    public abstract Integer getPacketLength();

    public abstract Boolean getResponse();

    public EipPacket(long sessionHandle, long status, byte[] senderContext, long options) {
        this.sessionHandle = sessionHandle;
        this.status = status;
        this.senderContext = senderContext;
        this.options = options;
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public long getStatus() {
        return this.status;
    }

    public byte[] getSenderContext() {
        return this.senderContext;
    }

    public long getOptions() {
        return this.options;
    }

    protected abstract void serializeEipPacketChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EipPacket", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"command", (Object)this.getCommand(), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        int packetLength = this.getLengthInBytes() - 24;
        FieldWriterFactory.writeImplicitField((String)"packetLength", (Object)packetLength, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sessionHandle", (Object)this.sessionHandle, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"status", (Object)this.status, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"senderContext", (byte[])this.senderContext, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"options", (Object)this.options, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        this.serializeEipPacketChild(writeBuffer);
        writeBuffer.popContext("EipPacket", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        EipPacket _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.senderContext != null) {
            lengthInBits += 8 * this.senderContext.length;
        }
        return lengthInBits += 32;
    }

    public static EipPacket staticParse(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("EipPacket", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int command = (Integer)FieldReaderFactory.readDiscriminatorField((String)"command", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int packetLength = (Integer)FieldReaderFactory.readImplicitField((String)"packetLength", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        long sessionHandle = (Long)FieldReaderFactory.readSimpleField((String)"sessionHandle", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long status = (Long)FieldReaderFactory.readSimpleField((String)"status", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] senderContext = readBuffer.readByteArray("senderContext", Math.toIntExact(8L), new WithReaderArgs[0]);
        long options = (Long)FieldReaderFactory.readSimpleField((String)"options", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        EipPacketBuilder builder = null;
        if (EvaluationHelper.equals((Object)command, (Object)1) && EvaluationHelper.equals((Object)response, (Object)false)) {
            builder = NullCommandRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)1) && EvaluationHelper.equals((Object)response, (Object)true)) {
            builder = NullCommandResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)4) && EvaluationHelper.equals((Object)response, (Object)false)) {
            builder = ListServicesRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)4) && EvaluationHelper.equals((Object)response, (Object)true) && EvaluationHelper.equals((Object)packetLength, (Object)0)) {
            builder = NullListServicesResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)4) && EvaluationHelper.equals((Object)response, (Object)true)) {
            builder = ListServicesResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)99) && EvaluationHelper.equals((Object)response, (Object)false)) {
            builder = EipListIdentityRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)99) && EvaluationHelper.equals((Object)response, (Object)true)) {
            builder = EipListIdentityResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)101) && EvaluationHelper.equals((Object)response, (Object)false)) {
            builder = EipConnectionRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)101) && EvaluationHelper.equals((Object)response, (Object)true) && EvaluationHelper.equals((Object)packetLength, (Object)0)) {
            builder = NullEipConnectionResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)101) && EvaluationHelper.equals((Object)response, (Object)true)) {
            builder = EipConnectionResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)102)) {
            builder = EipDisconnectRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)111)) {
            builder = CipRRData.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)command, (Object)112)) {
            builder = SendUnitData.staticParseEipPacketBuilder(readBuffer, response);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [command=" + command + " " + "response=" + response + " " + "packetLength=" + packetLength + "]");
        }
        readBuffer.closeContext("EipPacket", new WithReaderArgs[0]);
        EipPacket _eipPacket = builder.build(sessionHandle, status, senderContext, options);
        return _eipPacket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EipPacket)) {
            return false;
        }
        EipPacket that = (EipPacket)o;
        return this.getSessionHandle() == that.getSessionHandle() && this.getStatus() == that.getStatus() && this.getSenderContext() == that.getSenderContext() && this.getOptions() == that.getOptions();
    }

    public int hashCode() {
        return Objects.hash(this.getSessionHandle(), this.getStatus(), this.getSenderContext(), this.getOptions());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface EipPacketBuilder {
        public EipPacket build(long var1, long var3, byte[] var5, long var6);
    }
}

