/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class Services
implements Message {
    protected final List<Integer> offsets;
    protected final List<CipService> services;

    public Services(List<Integer> offsets, List<CipService> services) {
        this.offsets = offsets;
        this.services = services;
    }

    public List<Integer> getOffsets() {
        return this.offsets;
    }

    public List<CipService> getServices() {
        return this.services;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Services", new WithWriterArgs[0]);
        int serviceNb = StaticHelper.COUNT(this.getOffsets());
        FieldWriterFactory.writeImplicitField((String)"serviceNb", (Object)serviceNb, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"offsets", this.offsets, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"services", this.services, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("Services", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        Services _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        if (this.offsets != null) {
            lengthInBits += 16 * this.offsets.size();
        }
        if (this.services != null) {
            int i = 0;
            for (CipService element : this.services) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.services.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static Services staticParse(ReadBuffer readBuffer, Integer servicesLen) throws ParseException {
        readBuffer.pullContext("Services", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int serviceNb = (Integer)FieldReaderFactory.readImplicitField((String)"serviceNb", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        List offsets = FieldReaderFactory.readCountArrayField((String)"offsets", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (long)serviceNb, (WithReaderArgs[])new WithReaderArgs[0]);
        List services = FieldReaderFactory.readCountArrayField((String)"services", (DataReader)DataReaderFactory.readComplex(() -> CipService.staticParse(readBuffer, false, servicesLen / serviceNb), (ReadBuffer)readBuffer), (long)serviceNb, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("Services", new WithReaderArgs[0]);
        Services _services = new Services(offsets, services);
        return _services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Services)) {
            return false;
        }
        Services that = (Services)o;
        return this.getOffsets() == that.getOffsets() && this.getServices() == that.getServices();
    }

    public int hashCode() {
        return Objects.hash(this.getOffsets(), this.getServices());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

