/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.firmata.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class FirmataMessageSubscribeAnalogPinValue extends FirmataMessage implements Message {

  // Accessors for discriminator values.
  public Byte getMessageType() {
    return (byte) 0xC;
  }

  // Properties.
  protected final byte pin;
  protected final boolean enable;

  // Arguments.
  protected final Boolean response;
  // Reserved Fields
  private Short reservedField0;

  public FirmataMessageSubscribeAnalogPinValue(byte pin, boolean enable, Boolean response) {
    super(response);
    this.pin = pin;
    this.enable = enable;
    this.response = response;
  }

  public byte getPin() {
    return pin;
  }

  public boolean getEnable() {
    return enable;
  }

  @Override
  protected void serializeFirmataMessageChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("FirmataMessageSubscribeAnalogPinValue");

    // Simple Field (pin)
    writeSimpleField(
        "pin",
        pin,
        writeUnsignedByte(writeBuffer, 4),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 7));

    // Simple Field (enable)
    writeSimpleField(
        "enable",
        enable,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("FirmataMessageSubscribeAnalogPinValue");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    FirmataMessageSubscribeAnalogPinValue _value = this;

    // Simple field (pin)
    lengthInBits += 4;

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (enable)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static FirmataMessageSubscribeAnalogPinValueBuilder staticParseBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("FirmataMessageSubscribeAnalogPinValue");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    byte pin =
        readSimpleField(
            "pin", readUnsignedByte(readBuffer, 4), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Short reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedShort(readBuffer, 7),
            (short) 0x00,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean enable =
        readSimpleField(
            "enable", readBoolean(readBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("FirmataMessageSubscribeAnalogPinValue");
    // Create the instance
    return new FirmataMessageSubscribeAnalogPinValueBuilder(pin, enable, response, reservedField0);
  }

  public static class FirmataMessageSubscribeAnalogPinValueBuilder
      implements FirmataMessage.FirmataMessageBuilder {
    private final byte pin;
    private final boolean enable;
    private final Boolean response;
    private final Short reservedField0;

    public FirmataMessageSubscribeAnalogPinValueBuilder(
        byte pin, boolean enable, Boolean response, Short reservedField0) {
      this.pin = pin;
      this.enable = enable;
      this.response = response;
      this.reservedField0 = reservedField0;
    }

    public FirmataMessageSubscribeAnalogPinValue build(Boolean response) {

      FirmataMessageSubscribeAnalogPinValue firmataMessageSubscribeAnalogPinValue =
          new FirmataMessageSubscribeAnalogPinValue(pin, enable, response);
      firmataMessageSubscribeAnalogPinValue.reservedField0 = reservedField0;
      return firmataMessageSubscribeAnalogPinValue;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof FirmataMessageSubscribeAnalogPinValue)) {
      return false;
    }
    FirmataMessageSubscribeAnalogPinValue that = (FirmataMessageSubscribeAnalogPinValue) o;
    return (getPin() == that.getPin())
        && (getEnable() == that.getEnable())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPin(), getEnable());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
