/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite.field;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.firmata.readwrite.field.FirmataField;

public class FirmataFieldAnalog
extends FirmataField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("analog:" + FirmataField.ADDRESS_PATTERN);

    public FirmataFieldAnalog(int address, Integer quantity) {
        super(address, quantity);
    }

    public String getPlcDataType() {
        return "INT";
    }

    public static FirmataFieldAnalog of(String addressString) throws PlcInvalidFieldException {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (!matcher.matches()) {
            throw new PlcInvalidFieldException(addressString, ADDRESS_PATTERN);
        }
        int address = Integer.parseInt(matcher.group("address"));
        String quantityString = matcher.group("quantity");
        Integer quantity = quantityString != null ? Integer.valueOf(quantityString) : null;
        return new FirmataFieldAnalog(address, quantity);
    }
}

