/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite.field;

import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.firmata.readwrite.PinMode;
import org.apache.plc4x.java.firmata.readwrite.field.FirmataField;

public class FirmataFieldDigital
extends FirmataField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("digital:" + FirmataField.ADDRESS_PATTERN + "(:(?<mode>PULLUP))?");
    protected final BitSet bitSet = new BitSet();
    protected final PinMode pinMode;

    public FirmataFieldDigital(int address, Integer quantity, PinMode pinMode) {
        super(address, quantity);
        for (int i = this.getAddress(); i < this.getAddress() + this.getNumberOfElements(); ++i) {
            this.bitSet.set(i, true);
        }
        this.pinMode = pinMode;
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    public PinMode getPinMode() {
        return this.pinMode;
    }

    public String getPlcDataType() {
        return "BOOL";
    }

    public static FirmataFieldDigital of(String addressString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (!matcher.matches()) {
            throw new PlcInvalidFieldException(addressString, ADDRESS_PATTERN);
        }
        int address = Integer.parseInt(matcher.group("address"));
        String quantityString = matcher.group("quantity");
        Integer quantity = quantityString != null ? Integer.valueOf(quantityString) : null;
        PinMode pinMode = "PULLUP".equals(matcher.group("mode")) ? PinMode.PinModePullup : null;
        return new FirmataFieldDigital(address, quantity, pinMode);
    }
}

