/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite.protocol;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSysex;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSystemReset;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessage;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageAnalogIO;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageCommand;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageDigitalIO;
import org.apache.plc4x.java.firmata.readwrite.SysexCommandReportFirmwareResponse;
import org.apache.plc4x.java.firmata.readwrite.context.FirmataDriverContext;
import org.apache.plc4x.java.firmata.readwrite.field.FirmataField;
import org.apache.plc4x.java.firmata.readwrite.field.FirmataFieldAnalog;
import org.apache.plc4x.java.firmata.readwrite.field.FirmataFieldDigital;
import org.apache.plc4x.java.firmata.readwrite.model.FirmataSubscriptionHandle;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmataProtocolLogic
extends Plc4xProtocolBase<FirmataMessage>
implements PlcSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmataProtocolLogic.class);
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    private AtomicBoolean connected = new AtomicBoolean(false);
    private Map<Integer, AtomicInteger> analogValues = new HashMap<Integer, AtomicInteger>();
    private BitSet digitalValues = new BitSet();
    private Map<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> consumers = new ConcurrentHashMap<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>>();

    public void onConnect(ConversationContext<FirmataMessage> context) {
        LOGGER.debug("Sending Firmata Reset Command");
        FirmataMessageCommand resetCommandMessage = new FirmataMessageCommand(new FirmataCommandSystemReset(false), false);
        context.sendRequest((Object)resetCommandMessage).expectResponse(FirmataMessage.class, REQUEST_TIMEOUT).only(FirmataMessageCommand.class).unwrap(FirmataMessageCommand::getCommand).only(FirmataCommandSysex.class).unwrap(FirmataCommandSysex::getCommand).only(SysexCommandReportFirmwareResponse.class).handle(sysexCommandReportFirmware -> {
            String name = new String(sysexCommandReportFirmware.getFileName(), StandardCharsets.UTF_8);
            LOGGER.info(String.format("Connected to Firmata host running version %s.%s with name %s", sysexCommandReportFirmware.getMajorVersion(), sysexCommandReportFirmware.getMinorVersion(), name));
            this.connected.set(true);
            context.fireConnected();
        });
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        try {
            List<FirmataMessage> firmataMessages = ((FirmataDriverContext)this.getDriverContext()).processWriteRequest(writeRequest);
            for (FirmataMessage firmataMessage : firmataMessages) {
                this.context.sendToWire((Object)firmataMessage);
            }
            HashMap<String, PlcResponseCode> result = new HashMap<String, PlcResponseCode>();
            for (String fieldName : writeRequest.getFieldNames()) {
                result.put(fieldName, PlcResponseCode.OK);
            }
            future.complete((PlcWriteResponse)new DefaultPlcWriteResponse(writeRequest, result));
        }
        catch (PlcRuntimeException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
        try {
            List<FirmataMessage> firmataMessages = ((FirmataDriverContext)this.getDriverContext()).processSubscriptionRequest(subscriptionRequest);
            for (FirmataMessage firmataMessage : firmataMessages) {
                this.context.sendToWire((Object)firmataMessage);
            }
            HashMap<String, ResponseItem> result = new HashMap<String, ResponseItem>();
            for (String fieldName : subscriptionRequest.getFieldNames()) {
                DefaultPlcSubscriptionField subscriptionField = (DefaultPlcSubscriptionField)subscriptionRequest.getField(fieldName);
                FirmataField field = (FirmataField)subscriptionField.getPlcField();
                result.put(fieldName, new ResponseItem(PlcResponseCode.OK, (Object)new FirmataSubscriptionHandle(this, fieldName, field)));
            }
            future.complete((PlcSubscriptionResponse)new DefaultPlcSubscriptionResponse(subscriptionRequest, result));
        }
        catch (PlcRuntimeException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        return null;
    }

    protected void decode(ConversationContext<FirmataMessage> context, FirmataMessage msg) {
        if (!this.connected.get()) {
            return;
        }
        if (msg instanceof FirmataMessageAnalogIO) {
            FirmataMessageAnalogIO analogIO = (FirmataMessageAnalogIO)msg;
            byte pin = analogIO.getPin();
            int analogValue = this.getAnalogValue(analogIO.getData());
            if (this.analogValues.get(pin) == null || analogValue != this.analogValues.get(pin).intValue()) {
                this.analogValues.put(Integer.valueOf(pin), new AtomicInteger(analogValue));
                this.publishAnalogEvents(pin, analogValue);
            }
        } else if (msg instanceof FirmataMessageDigitalIO) {
            FirmataMessageDigitalIO digitalIO = (FirmataMessageDigitalIO)msg;
            BitSet newDigitalValues = this.getDigitalValues(digitalIO.getPinBlock(), digitalIO.getData());
            BitSet changedBits = new BitSet();
            for (int i = 0; i < 8; ++i) {
                int bitPos = i + 8 * digitalIO.getPinBlock();
                if (this.digitalValues.get(bitPos) == newDigitalValues.get(bitPos)) continue;
                changedBits.set(bitPos, true);
                this.digitalValues.set(bitPos, newDigitalValues.get(bitPos));
            }
            this.publishDigitalEvents(changedBits, this.digitalValues);
        } else {
            LOGGER.debug(String.format("Unexpected message %s", msg.toString()));
        }
    }

    public void close(ConversationContext<FirmataMessage> context) {
        this.connected.set(false);
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> collection) {
        DefaultPlcConsumerRegistration consumerRegistration = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, collection.toArray(new PlcSubscriptionHandle[0]));
        this.consumers.put(consumerRegistration, consumer);
        return consumerRegistration;
    }

    public void unregister(PlcConsumerRegistration plcConsumerRegistration) {
        DefaultPlcConsumerRegistration consumerRegistration = (DefaultPlcConsumerRegistration)plcConsumerRegistration;
        this.consumers.remove(consumerRegistration);
    }

    protected void publishAnalogEvents(int pin, int value) {
        for (Map.Entry<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> entry : this.consumers.entrySet()) {
            DefaultPlcConsumerRegistration registration = entry.getKey();
            Consumer<PlcSubscriptionEvent> consumer = entry.getValue();
            for (PlcSubscriptionHandle handle : registration.getSubscriptionHandles()) {
                FirmataFieldAnalog analogField;
                FirmataSubscriptionHandle subscriptionHandle;
                if (!(handle instanceof FirmataSubscriptionHandle) || !((subscriptionHandle = (FirmataSubscriptionHandle)handle).getField() instanceof FirmataFieldAnalog) || (analogField = (FirmataFieldAnalog)subscriptionHandle.getField()).getAddress() > pin || analogField.getAddress() + analogField.getNumberOfElements() < pin) continue;
                ArrayList<PlcValue> values = new ArrayList<PlcValue>(analogField.getNumberOfElements());
                for (int i = analogField.getAddress(); i < analogField.getAddress() + analogField.getNumberOfElements(); ++i) {
                    if (this.analogValues.containsKey(i)) {
                        values.add((PlcValue)new PlcDINT(this.analogValues.get(i).intValue()));
                        continue;
                    }
                    values.add((PlcValue)new PlcDINT(-1));
                }
                this.sendUpdateEvents(consumer, subscriptionHandle.getName(), values);
            }
        }
    }

    protected void publishDigitalEvents(BitSet changedBits, BitSet bitValues) {
        if (changedBits.cardinality() == 0) {
            return;
        }
        for (Map.Entry<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> entry : this.consumers.entrySet()) {
            DefaultPlcConsumerRegistration registration = entry.getKey();
            Consumer<PlcSubscriptionEvent> consumer = entry.getValue();
            for (PlcSubscriptionHandle handle : registration.getSubscriptionHandles()) {
                FirmataFieldDigital digitalField;
                FirmataSubscriptionHandle subscriptionHandle;
                if (!(handle instanceof FirmataSubscriptionHandle) || !((subscriptionHandle = (FirmataSubscriptionHandle)handle).getField() instanceof FirmataFieldDigital) || !(digitalField = (FirmataFieldDigital)subscriptionHandle.getField()).getBitSet().intersects(changedBits)) continue;
                ArrayList<PlcValue> values = new ArrayList<PlcValue>(digitalField.getBitSet().cardinality());
                for (int i = 0; i < digitalField.getBitSet().length(); ++i) {
                    values.add((PlcValue)new PlcBOOL(bitValues.get(i)));
                }
                this.sendUpdateEvents(consumer, subscriptionHandle.getName(), values);
            }
        }
    }

    protected void sendUpdateEvents(Consumer<PlcSubscriptionEvent> consumer, String fieldName, List<PlcValue> values) {
        if (values.size() == 1) {
            DefaultPlcSubscriptionEvent event = new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap(fieldName, new ResponseItem(PlcResponseCode.OK, (Object)values.get(0))));
            consumer.accept((PlcSubscriptionEvent)event);
        } else {
            DefaultPlcSubscriptionEvent event = new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap(fieldName, new ResponseItem(PlcResponseCode.OK, (Object)new PlcList(values))));
            consumer.accept((PlcSubscriptionEvent)event);
        }
    }

    protected int getAnalogValue(List<Byte> data) {
        return (data.get(0) & 0xFF | data.get(1) << 7) & 0xFFFF;
    }

    protected int convertToSingleByteRepresentation(List<Byte> data) {
        byte result = data.get(0);
        result = (byte)(result | ((data.get(1) & 1) == 1 ? 128 : 0));
        return result & 0xFF;
    }

    protected BitSet getDigitalValues(int byteBlock, List<Byte> data) {
        int singleByte = this.convertToSingleByteRepresentation(data);
        if (byteBlock > 0) {
            singleByte *= 256 * byteBlock;
        }
        byte[] bitSetData = BigInteger.valueOf(singleByte).toByteArray();
        ArrayUtils.reverse((byte[])bitSetData);
        return BitSet.valueOf(bitSetData);
    }
}

