/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.firmata.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class SysexCommand implements Message {

  // Abstract accessors for discriminator values.
  public abstract Short getCommandType();

  public abstract Boolean getResponse();

  public SysexCommand() {
    super();
  }

  protected abstract void serializeSysexCommandChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SysexCommand");

    // Discriminator Field (commandType) (Used as input to a switch field)
    writeDiscriminatorField("commandType", getCommandType(), writeUnsignedShort(writeBuffer, 8));

    // Switch field (Serialize the sub-type)
    serializeSysexCommandChild(writeBuffer);

    writeBuffer.popContext("SysexCommand");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SysexCommand _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Discriminator Field (commandType)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static SysexCommand staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    Boolean response;
    if (args[0] instanceof Boolean) {
      response = (Boolean) args[0];
    } else if (args[0] instanceof String) {
      response = Boolean.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Boolean or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, response);
  }

  public static SysexCommand staticParse(ReadBuffer readBuffer, Boolean response)
      throws ParseException {
    readBuffer.pullContext("SysexCommand");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short commandType = readDiscriminatorField("commandType", readUnsignedShort(readBuffer, 8));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    SysexCommandBuilder builder = null;
    if (EvaluationHelper.equals(commandType, (short) 0x00)) {
      builder = SysexCommandExtendedId.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x69)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder =
          SysexCommandAnalogMappingQueryRequest.staticParseSysexCommandBuilder(
              readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x69)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder =
          SysexCommandAnalogMappingQueryResponse.staticParseSysexCommandBuilder(
              readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x6A)) {
      builder =
          SysexCommandAnalogMappingResponse.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x6B)) {
      builder = SysexCommandCapabilityQuery.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x6C)) {
      builder = SysexCommandCapabilityResponse.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x6D)) {
      builder = SysexCommandPinStateQuery.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x6E)) {
      builder = SysexCommandPinStateResponse.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x6F)) {
      builder = SysexCommandExtendedAnalog.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x71)) {
      builder = SysexCommandStringData.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x79)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder =
          SysexCommandReportFirmwareRequest.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x79)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder =
          SysexCommandReportFirmwareResponse.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x7A)) {
      builder = SysexCommandSamplingInterval.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x7E)) {
      builder = SysexCommandSysexNonRealtime.staticParseSysexCommandBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(commandType, (short) 0x7F)) {
      builder = SysexCommandSysexRealtime.staticParseSysexCommandBuilder(readBuffer, response);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "commandType="
              + commandType
              + " "
              + "response="
              + response
              + "]");
    }

    readBuffer.closeContext("SysexCommand");
    // Create the instance
    SysexCommand _sysexCommand = builder.build();
    return _sysexCommand;
  }

  public interface SysexCommandBuilder {
    SysexCommand build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SysexCommand)) {
      return false;
    }
    SysexCommand that = (SysexCommand) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
