/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessage;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class FirmataMessageDigitalIO
extends FirmataMessage
implements Message {
    protected final byte pinBlock;
    protected final List<Byte> data;

    @Override
    public Byte getMessageType() {
        return (byte)9;
    }

    public FirmataMessageDigitalIO(byte pinBlock, List<Byte> data) {
        this.pinBlock = pinBlock;
        this.data = data;
    }

    public byte getPinBlock() {
        return this.pinBlock;
    }

    public List<Byte> getData() {
        return this.data;
    }

    @Override
    protected void serializeFirmataMessageChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("FirmataMessageDigitalIO", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"pinBlock", (Object)this.pinBlock, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleTypeArrayField((String)"data", this.data, (DataWriter)DataWriterFactory.writeSignedByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        writeBuffer.popContext("FirmataMessageDigitalIO", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        FirmataMessageDigitalIO _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        if (this.data != null) {
            lengthInBits += 8 * this.data.size();
        }
        return lengthInBits;
    }

    public static FirmataMessage.FirmataMessageBuilder staticParseFirmataMessageBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("FirmataMessageDigitalIO", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte pinBlock = (Byte)FieldReaderFactory.readSimpleField((String)"pinBlock", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        List data = FieldReaderFactory.readCountArrayField((String)"data", (DataReader)DataReaderFactory.readSignedByte((ReadBuffer)readBuffer, (int)8), (long)2L, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("FirmataMessageDigitalIO", new WithReaderArgs[0]);
        return new FirmataMessageDigitalIOBuilderImpl(pinBlock, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirmataMessageDigitalIO)) {
            return false;
        }
        FirmataMessageDigitalIO that = (FirmataMessageDigitalIO)o;
        return this.getPinBlock() == that.getPinBlock() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPinBlock(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class FirmataMessageDigitalIOBuilderImpl
    implements FirmataMessage.FirmataMessageBuilder {
        private final byte pinBlock;
        private final List<Byte> data;

        public FirmataMessageDigitalIOBuilderImpl(byte pinBlock, List<Byte> data) {
            this.pinBlock = pinBlock;
            this.data = data;
        }

        @Override
        public FirmataMessageDigitalIO build() {
            FirmataMessageDigitalIO firmataMessageDigitalIO = new FirmataMessageDigitalIO(this.pinBlock, this.data);
            return firmataMessageDigitalIO;
        }
    }
}

