/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.iec608705104.readwrite.APDU;
import org.apache.plc4x.java.iec608705104.readwrite.configuration.Iec608705014Configuration;
import org.apache.plc4x.java.iec608705104.readwrite.configuration.Iec608705014TcpTransportConfiguration;
import org.apache.plc4x.java.iec608705104.readwrite.protocol.Iec608705104Protocol;
import org.apache.plc4x.java.iec608705104.readwrite.tag.Iec608705104TagHandler;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class Iec60870514PlcDriver
extends GeneratedDriverBase<APDU> {
    public String getProtocolCode() {
        return "iec-60870-5-104";
    }

    public String getProtocolName() {
        return "IEC 60870-5-104";
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return Iec608705014Configuration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(Iec608705014TcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("tcp");
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("tcp");
    }

    protected Iec608705104TagHandler getTagHandler() {
        return new Iec608705104TagHandler();
    }

    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected ProtocolStackConfigurer<APDU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(APDU.class, (readBuffer, objectArray) -> APDU.staticParse(readBuffer, objectArray)).withPacketSizeEstimator(ByteLengthEstimator.class).withCorruptPacketRemover(CorruptPackageCleaner.class).withProtocol(Iec608705104Protocol.class).littleEndian().build();
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 2) {
                return byteBuf.getUnsignedByte(byteBuf.readerIndex() + 1) + 2;
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != APDU.STARTBYTE.shortValue()) {
                byteBuf.readByte();
            }
        }
    }
}

