/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime;
import org.apache.plc4x.java.iec608705104.readwrite.TypeIdentification;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class InformationObject
implements Message {
    protected final int address;

    public abstract Byte getNumTimeByte();

    public InformationObject(int address) {
        this.address = address;
    }

    public int getAddress() {
        return this.address;
    }

    protected abstract void serializeInformationObjectChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("InformationObject", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"address", (Object)this.address, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)24), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        this.serializeInformationObjectChild(writeBuffer);
        writeBuffer.popContext("InformationObject", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        InformationObject _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += 24;
    }

    public static InformationObject staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Byte numTimeByte;
        TypeIdentification typeIdentification;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof TypeIdentification) {
            typeIdentification = (TypeIdentification)((Object)args[0]);
        } else if (args[0] instanceof String) {
            typeIdentification = TypeIdentification.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type TypeIdentification or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof Byte) {
            numTimeByte = (Byte)args[1];
        } else if (args[1] instanceof String) {
            numTimeByte = Byte.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type Byte or a string which is parseable but was " + args[1].getClass().getName());
        }
        return InformationObject.staticParse(readBuffer, typeIdentification, numTimeByte);
    }

    public static InformationObject staticParse(ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte) throws ParseException {
        readBuffer.pullContext("InformationObject", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int address = (Integer)FieldReaderFactory.readSimpleField((String)"address", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)24), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        InformationObjectBuilder builder = null;
        if (EvaluationHelper.equals((Object)numTimeByte, (Object)0)) {
            builder = InformationObjectWithoutTime.staticParseInformationObjectBuilder(readBuffer, typeIdentification, numTimeByte);
        } else if (EvaluationHelper.equals((Object)numTimeByte, (Object)3)) {
            builder = InformationObjectWithTreeByteTime.staticParseInformationObjectBuilder(readBuffer, typeIdentification, numTimeByte);
        } else if (EvaluationHelper.equals((Object)numTimeByte, (Object)7)) {
            builder = InformationObjectWithSevenByteTime.staticParseInformationObjectBuilder(readBuffer, typeIdentification, numTimeByte);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [numTimeByte=" + numTimeByte + "]");
        }
        readBuffer.closeContext("InformationObject", new WithReaderArgs[0]);
        InformationObject _informationObject = builder.build(address);
        return _informationObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InformationObject)) {
            return false;
        }
        InformationObject that = (InformationObject)o;
        return this.getAddress() == that.getAddress();
    }

    public int hashCode() {
        return Objects.hash(this.getAddress());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface InformationObjectBuilder {
        public InformationObject build(int var1);
    }
}

