/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum TypeIdentification {
    NOT_USED(0, 0),
    SINGLE_POINT_INFORMATION(1, 0),
    SINGLE_POINT_INFORMATION_WITH_TIME_TAG(2, 3),
    DOUBLE_POINT_INFORMATION(3, 0),
    DOUBLE_POINT_INFORMATION_WITH_TIME_TAG(4, 3),
    STEP_POSITION_INFORMATION(5, 0),
    STEP_POSITION_INFORMATION_WITH_TIME_TAG(6, 3),
    BITSTRING_OF_32_BIT(7, 0),
    BITSTRING_OF_32_BIT_WITH_TIME_TAG(8, 3),
    MEASURED_VALUE_NORMALISED_VALUE(9, 0),
    MEASURED_VALUE_NORMALIZED_VALUE_WITH_TIME_TAG(10, 3),
    MEASURED_VALUE_SCALED_VALUE(11, 0),
    MEASURED_VALUE_SCALED_VALUE_WITH_TIME_TAG(12, 3),
    MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER(13, 0),
    MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER_WITH_TIME_TAG(14, 3),
    INTEGRATED_TOTALS(15, 0),
    INTEGRATED_TOTALS_WITH_TIME_TAG(16, 3),
    EVENT_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG(17, 3),
    PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG(18, 3),
    PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG(19, 3),
    PACKED_SINGLE_POINT_INFORMATION_WITH_STATUS_CHANGE_DETECTION(20, 0),
    MEASURED_VALUE_NORMALIZED_VALUE_WITHOUT_QUALITY_DESCRIPTOR(21, 0),
    SINGLE_POINT_INFORMATION_WITH_TIME_TAG_CP56TIME2A(30, 7),
    DOUBLE_POINT_INFORMATION_WITH_TIME_TAG_CP56TIME2A(31, 7),
    STEP_POSITION_INFORMATION_WITH_TIME_TAG_CP56TIME2A(32, 7),
    BITSTRING_OF_32_BIT_WITH_TIME_TAG_CP56TIME2A(33, 7),
    MEASURED_VALUE_NORMALISED_VALUE_WITH_TIME_TAG_CP56TIME2A(34, 7),
    MEASURED_VALUE_SCALED_VALUE_WITH_TIME_TAG_CP56TIME2A(35, 7),
    MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER_WITH_TIME_TAG_CP56TIME2A(36, 7),
    INTEGRATED_TOTALS_WITH_TIME_TAG_CP56TIME2A(37, 7),
    EVENT_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG_CP56TIME2A(38, 7),
    PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG_CP56TIME2A(39, 7),
    PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG_CP56TIME2A(40, 7),
    SINGLE_COMMAND(45, 0),
    DOUBLE_COMMAND(46, 0),
    REGULATING_STEP_COMMAND(47, 0),
    SET_POINT_COMMAND_NORMALISED_VALUE(48, 0),
    SET_POINT_COMMAND_SCALED_VALUE(49, 0),
    SET_POINT_COMMAND_SHORT_FLOATING_POINT_NUMBER(50, 0),
    BITSTRING_32_BIT_COMMAND(51, 0),
    SINGLE_COMMAND_WITH_TIME_TAG_CP56TIME2A(58, 7),
    DOUBLE_COMMAND_WITH_TIME_TAG_CP56TIME2A(59, 7),
    REGULATING_STEP_COMMAND_WITH_TIME_TAG_CP56TIME2A(60, 7),
    MEASURED_VALUE_NORMALISED_VALUE_COMMAND_WITH_TIME_TAG_CP56TIME2A(61, 7),
    MEASURED_VALUE_SCALED_VALUE_COMMAND_WITH_TIME_TAG_CP56TIME2A(62, 7),
    MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER_COMMAND_WITH_TIME_TAG_CP56TIME2A(63, 7),
    BITSTRING_OF_32_BIT_COMMAND_WITH_TIME_TAG_CP56TIME2A(64, 7),
    END_OF_INITIALISATION(70, 0),
    INTERROGATION_COMMAND(100, 0),
    COUNTER_INTERROGATION_COMMAND(101, 0),
    READ_COMMAND(102, 0),
    CLOCK_SYNCHRONISATION_COMMAND(103, 0),
    TEST_COMMAND(104, 0),
    RESET_PROCESS_COMMAND(105, 0),
    DELAY_ACQUISITION_COMMAND(106, 0),
    TEST_COMMAND_WITH_TIME_TAG_CP56TIME2A(107, 0),
    PARAMETER_OF_MEASURED_VALUES_NORMALIZED_VALUE(110, 0),
    PARAMETER_OF_MEASURED_VALUES_SCALED_VALUE(111, 0),
    PARAMETER_OF_MEASURED_VALUES_SHORT_FLOATING_POINT_NUMBER(112, 0),
    PARAMETER_ACTIVATION(113, 0),
    FILE_READY(120, 0),
    SECTION_READY(121, 0),
    CALL_DIRECTORY_SELECT_FILE_CALL_FILE_CALL_SECTION(122, 0),
    LAST_SECTION_LAST_SEGMENT(123, 0),
    ACK_FILE_ACK_SECTION(124, 0),
    SEGMENT(125, 0),
    DIRECTORY(126, 7);

    private static final Map<Short, TypeIdentification> map;
    private final short value;
    private final byte numTimeBytes;

    static {
        map = new HashMap<Short, TypeIdentification>();
        TypeIdentification[] typeIdentificationArray = TypeIdentification.values();
        int n = typeIdentificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeIdentification value = typeIdentificationArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private TypeIdentification(short value, byte numTimeBytes) {
        this.value = value;
        this.numTimeBytes = numTimeBytes;
    }

    public short getValue() {
        return this.value;
    }

    public byte getNumTimeBytes() {
        return this.numTimeBytes;
    }

    public static TypeIdentification firstEnumForFieldNumTimeBytes(byte fieldValue) {
        TypeIdentification[] typeIdentificationArray = TypeIdentification.values();
        int n = typeIdentificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeIdentification _val = typeIdentificationArray[n2];
            if (_val.getNumTimeBytes() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<TypeIdentification> enumsForFieldNumTimeBytes(byte fieldValue) {
        ArrayList<TypeIdentification> _values = new ArrayList<TypeIdentification>();
        TypeIdentification[] typeIdentificationArray = TypeIdentification.values();
        int n = typeIdentificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeIdentification _val = typeIdentificationArray[n2];
            if (_val.getNumTimeBytes() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static TypeIdentification enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

