/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.iec608705104.readwrite.protocol;

import io.netty.channel.ChannelPipeline;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.iec608705104.readwrite.APDU;
import org.apache.plc4x.java.iec608705104.readwrite.APDUIFormat;
import org.apache.plc4x.java.iec608705104.readwrite.APDUSFormat;
import org.apache.plc4x.java.iec608705104.readwrite.APDUUFormatStartDataTransferActivation;
import org.apache.plc4x.java.iec608705104.readwrite.APDUUFormatStartDataTransferConfirmation;
import org.apache.plc4x.java.iec608705104.readwrite.APDUUFormatTestFrameActivation;
import org.apache.plc4x.java.iec608705104.readwrite.APDUUFormatTestFrameConfirmation;
import org.apache.plc4x.java.iec608705104.readwrite.ASDU;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObject;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime;
import org.apache.plc4x.java.iec608705104.readwrite.SevenOctetBinaryTime;
import org.apache.plc4x.java.iec608705104.readwrite.ThreeOctetBinaryTime;
import org.apache.plc4x.java.iec608705104.readwrite.configuration.Iec608705014Configuration;
import org.apache.plc4x.java.iec608705104.readwrite.messages.Iec608705104PlcSubscriptionEvent;
import org.apache.plc4x.java.iec608705104.readwrite.model.Iec608705104SubscriptionHandle;
import org.apache.plc4x.java.iec608705104.readwrite.protocol.Iec608705104TagParser;
import org.apache.plc4x.java.iec608705104.readwrite.tag.Iec608705104Tag;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.PlcBrowser;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;

public class Iec608705104Protocol
extends Plc4xProtocolBase<APDU>
implements HasConfiguration<Iec608705014Configuration>,
PlcSubscriber,
PlcBrowser {
    private Iec608705014Configuration configuration;
    private final RequestTransactionManager tm;
    private int unconfirmedPackets = 0;
    private final Map<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> consumers = new ConcurrentHashMap<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>>();

    public Iec608705104Protocol() {
        this.tm = new RequestTransactionManager(1);
    }

    public void setConfiguration(Iec608705014Configuration configuration) {
        this.configuration = configuration;
    }

    public void close(ConversationContext<APDU> context) {
        this.tm.shutdown();
    }

    public void onConnect(ConversationContext<APDU> context) {
        APDUUFormatTestFrameActivation testFrameActivation = new APDUUFormatTestFrameActivation(67);
        RequestTransactionManager.RequestTransaction testFrameTx = this.tm.startRequest();
        testFrameTx.submit(() -> {
            ConversationContext.ContextHandler contextHandler = context.sendRequest((Object)testFrameActivation).expectResponse(APDU.class, Duration.ofMillis(this.configuration.getRequestTimeout())).onTimeout(e -> {
                ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
            }).onError((p, e) -> {
                ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught(e);
            }).only(APDUUFormatTestFrameConfirmation.class).handle(testFrameResponse -> {
                testFrameTx.endRequest();
                APDUUFormatStartDataTransferActivation startDataTransferActivation = new APDUUFormatStartDataTransferActivation(7);
                RequestTransactionManager.RequestTransaction startDataTransferTx = this.tm.startRequest();
                startDataTransferTx.submit(() -> {
                    ConversationContext.ContextHandler contextHandler = context.sendRequest((Object)startDataTransferActivation).expectResponse(APDU.class, Duration.ofMillis(this.configuration.getRequestTimeout())).onTimeout(e -> {
                        ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught((Throwable)e);
                    }).onError((p, e) -> {
                        ChannelPipeline channelPipeline = context.getChannel().pipeline().fireExceptionCaught(e);
                    }).only(APDUUFormatStartDataTransferConfirmation.class).handle(startDataTransferResponse -> {
                        startDataTransferTx.endRequest();
                        context.fireConnected();
                    });
                });
            });
        });
    }

    protected void decode(ConversationContext<APDU> context, APDU msg) throws Exception {
        if (msg instanceof APDUUFormatTestFrameActivation) {
            APDUUFormatTestFrameConfirmation testFrameConfirmation = new APDUUFormatTestFrameConfirmation(131);
            context.sendToWire((Object)testFrameConfirmation);
        } else if (msg instanceof APDUIFormat) {
            APDUIFormat apduiFormat = (APDUIFormat)msg;
            ++this.unconfirmedPackets;
            if (this.unconfirmedPackets >= 8) {
                APDUSFormat confirmPacket = new APDUSFormat(1, apduiFormat.getReceiveSequenceNo() + 1);
                context.sendToWire((Object)confirmPacket);
                this.unconfirmedPackets = 0;
            }
            this.processData(apduiFormat.getAsdu());
        }
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        for (String tagName : subscriptionRequest.getTagNames()) {
            DefaultPlcSubscriptionTag tag = (DefaultPlcSubscriptionTag)subscriptionRequest.getTag(tagName);
            if (!(tag.getTag() instanceof Iec608705104Tag)) {
                values.put(tagName, new ResponseItem(PlcResponseCode.INVALID_ADDRESS, null));
                continue;
            }
            values.put(tagName, new ResponseItem(PlcResponseCode.OK, (Object)new Iec608705104SubscriptionHandle(this, (Iec608705104Tag)tag.getTag())));
        }
        return CompletableFuture.completedFuture(new DefaultPlcSubscriptionResponse(subscriptionRequest, values));
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> collection) {
        DefaultPlcConsumerRegistration consumerRegistration = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, collection.toArray(new PlcSubscriptionHandle[0]));
        this.consumers.put(consumerRegistration, consumer);
        return consumerRegistration;
    }

    public void unregister(PlcConsumerRegistration plcConsumerRegistration) {
        DefaultPlcConsumerRegistration consumerRegistration = (DefaultPlcConsumerRegistration)plcConsumerRegistration;
        this.consumers.remove(consumerRegistration);
    }

    protected void processData(ASDU asdu) {
        int asduAddress = asdu.getAsduAddressField();
        for (InformationObject informationObject : asdu.getInformationObjects()) {
            LocalDateTime eventTime;
            Object time;
            int objectAddress = informationObject.getAddress();
            Iec608705104Tag tag = new Iec608705104Tag(asduAddress, objectAddress);
            PlcValue plcValue = Iec608705104TagParser.parseTag(informationObject, asdu.getTypeIdentification());
            if (informationObject instanceof InformationObjectWithTreeByteTime) {
                InformationObjectWithTreeByteTime informationObjectWithTreeByteTime = (InformationObjectWithTreeByteTime)informationObject;
                time = informationObjectWithTreeByteTime.getCp24Time2a();
                eventTime = this.convertCp24Time2aToCalendar((ThreeOctetBinaryTime)time);
            } else if (informationObject instanceof InformationObjectWithSevenByteTime) {
                InformationObjectWithSevenByteTime informationObjectWithSevenByteTime = (InformationObjectWithSevenByteTime)informationObject;
                time = informationObjectWithSevenByteTime.getCp56Time2a();
                eventTime = this.convertCp56Time2aToCalendar((SevenOctetBinaryTime)time);
            } else {
                eventTime = LocalDateTime.now();
            }
            this.publishEvent(eventTime, tag, plcValue);
        }
    }

    protected LocalDateTime convertCp24Time2aToCalendar(ThreeOctetBinaryTime cp24Time2) {
        LocalDateTime now = LocalDateTime.now();
        return LocalDateTime.of(now.getYear(), now.getMonthValue(), now.getDayOfMonth(), now.getHour(), (int)cp24Time2.getMinutes(), cp24Time2.getMilliseconds() / 1000, cp24Time2.getMilliseconds() % 1000 * 1000000);
    }

    protected LocalDateTime convertCp56Time2aToCalendar(SevenOctetBinaryTime cp56Time2) {
        TimeZone localTimeZone = TimeZone.getDefault();
        Duration localTimeZoneOffsetFromUTC = Duration.ofMillis(localTimeZone.getRawOffset());
        if (cp56Time2.getDaylightSaving()) {
            Duration daylightSavingOffset = Duration.ofMillis(localTimeZone.getDSTSavings());
            localTimeZoneOffsetFromUTC = localTimeZoneOffsetFromUTC.plus(daylightSavingOffset);
        }
        return LocalDateTime.of(2000 + cp56Time2.getYear(), cp56Time2.getMonth(), (int)cp56Time2.getDay(), (int)cp56Time2.getHour(), (int)cp56Time2.getMinutes(), cp56Time2.getMilliseconds() / 1000, cp56Time2.getMilliseconds() % 1000 * 1000000).minus(localTimeZoneOffsetFromUTC);
    }

    protected void publishEvent(LocalDateTime timeStamp, Iec608705104Tag tag, PlcValue plcValue) {
        Iec608705104PlcSubscriptionEvent event = new Iec608705104PlcSubscriptionEvent(timeStamp.atZone(ZoneId.systemDefault()).toInstant(), Collections.singletonMap(tag.toString(), tag), Collections.singletonMap(tag.toString(), new ResponseItem(PlcResponseCode.OK, (Object)plcValue)));
        for (Map.Entry<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> entry : this.consumers.entrySet()) {
            DefaultPlcConsumerRegistration registration = entry.getKey();
            Consumer<PlcSubscriptionEvent> consumer = entry.getValue();
            for (PlcSubscriptionHandle handle : registration.getSubscriptionHandles()) {
                if (!(handle instanceof Iec608705104SubscriptionHandle)) continue;
                Iec608705104SubscriptionHandle subscriptionHandle = (Iec608705104SubscriptionHandle)handle;
                consumer.accept((PlcSubscriptionEvent)event);
            }
        }
    }
}

