/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.iec608705104.readwrite.protocol;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.iec608705104.readwrite.BinaryCounterReading;
import org.apache.plc4x.java.iec608705104.readwrite.BinaryStateInformation;
import org.apache.plc4x.java.iec608705104.readwrite.CauseOfInitialization;
import org.apache.plc4x.java.iec608705104.readwrite.DoubleCommand;
import org.apache.plc4x.java.iec608705104.readwrite.DoublePointInformation;
import org.apache.plc4x.java.iec608705104.readwrite.FixedTestBitPatternTwoOctet;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObject;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_BITSTRING_OF_32_BIT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_DOUBLE_POINT_INFORMATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_EVENT_OF_PROTECTION_EQUIPMENT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_INTEGRATED_TOTALS;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_MEASURED_VALUE_NORMALISED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_MEASURED_VALUE_SCALED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_SINGLE_POINT_INFORMATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_BITSTRING_OF_32_BIT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_DOUBLE_POINT_INFORMATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_EVENT_OF_PROTECTION_EQUIPMENT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_INTEGRATED_TOTALS;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_MEASURED_VALUE_NORMALIZED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_MEASURED_VALUE_SCALED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_SINGLE_POINT_INFORMATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithTreeByteTime_STEP_POSITION_INFORMATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_ACK_FILE_ACK_SECTION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_BITSTRING_32_BIT_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_BITSTRING_OF_32_BIT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_CALL_DIRECTORY_SELECT_FILE_CALL_FILE_CALL_SECTION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_COUNTER_INTERROGATION_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_DELAY_ACQUISITION_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_DIRECTORY;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_DOUBLE_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_DOUBLE_POINT_INFORMATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_END_OF_INITIALISATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_FILE_READY;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_INTEGRATED_TOTALS;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_INTERROGATION_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_MEASURED_VALUE_NORMALISED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_MEASURED_VALUE_NORMALIZED_VALUE_WITHOUT_QUALITY_DESCRIPTOR;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_MEASURED_VALUE_SCALED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_PACKED_SINGLE_POINT_INFORMATION_WITH_STATUS_CHANGE_DETECTION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_PARAMETER_ACTIVATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_NORMALIZED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_SCALED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_SHORT_FLOATING_POINT_NUMBER;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_READ_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_REGULATING_STEP_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_RESET_PROCESS_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_SECTION_READY;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_SEGMENT;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_SET_POINT_COMMAND_NORMALISED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_SET_POINT_COMMAND_SCALED_VALUE;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_SET_POINT_COMMAND_SHORT_FLOATING_POINT_NUMBER;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_SINGLE_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_SINGLE_POINT_INFORMATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_STEP_POSITION_INFORMATION;
import org.apache.plc4x.java.iec608705104.readwrite.InformationObjectWithoutTime_TEST_COMMAND;
import org.apache.plc4x.java.iec608705104.readwrite.NormalizedValue;
import org.apache.plc4x.java.iec608705104.readwrite.OutputCircuitInformation;
import org.apache.plc4x.java.iec608705104.readwrite.QualifierOfCommand;
import org.apache.plc4x.java.iec608705104.readwrite.QualifierOfCounterInterrogationCommand;
import org.apache.plc4x.java.iec608705104.readwrite.QualifierOfInterrogation;
import org.apache.plc4x.java.iec608705104.readwrite.QualifierOfParameterActivation;
import org.apache.plc4x.java.iec608705104.readwrite.QualifierOfParameterOfMeasuredValues;
import org.apache.plc4x.java.iec608705104.readwrite.QualifierOfResetProcessCommand;
import org.apache.plc4x.java.iec608705104.readwrite.QualifierOfSetPointCommand;
import org.apache.plc4x.java.iec608705104.readwrite.QualityDescriptor;
import org.apache.plc4x.java.iec608705104.readwrite.QualityDescriptorForPointsOfProtectionEquipment;
import org.apache.plc4x.java.iec608705104.readwrite.RegulatingStepCommand;
import org.apache.plc4x.java.iec608705104.readwrite.ScaledValue;
import org.apache.plc4x.java.iec608705104.readwrite.SevenOctetBinaryTime;
import org.apache.plc4x.java.iec608705104.readwrite.SingleCommand;
import org.apache.plc4x.java.iec608705104.readwrite.SingleEventOfProtectionEquipment;
import org.apache.plc4x.java.iec608705104.readwrite.SinglePointInformation;
import org.apache.plc4x.java.iec608705104.readwrite.StatusChangeDetection;
import org.apache.plc4x.java.iec608705104.readwrite.ThreeOctetBinaryTime;
import org.apache.plc4x.java.iec608705104.readwrite.TwoOctetBinaryTime;
import org.apache.plc4x.java.iec608705104.readwrite.TypeIdentification;
import org.apache.plc4x.java.iec608705104.readwrite.ValueWithTransientStateIndication;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcValueAdapter;
import org.apache.plc4x.java.spi.values.PlcWORD;

public class Iec608705104TagParser {
    public static PlcValue parseTag(InformationObject informationObject, TypeIdentification typeIdentification) {
        switch (typeIdentification) {
            case NOT_USED: {
                break;
            }
            case SINGLE_POINT_INFORMATION: {
                InformationObjectWithoutTime_SINGLE_POINT_INFORMATION castedObject = (InformationObjectWithoutTime_SINGLE_POINT_INFORMATION)informationObject;
                return Iec608705104TagParser.processSinglePointInformation(castedObject.getSiq());
            }
            case DOUBLE_POINT_INFORMATION: {
                InformationObjectWithoutTime_DOUBLE_POINT_INFORMATION castedObject = (InformationObjectWithoutTime_DOUBLE_POINT_INFORMATION)informationObject;
                return Iec608705104TagParser.processDoublePointInformation(castedObject.getDiq());
            }
            case STEP_POSITION_INFORMATION: {
                InformationObjectWithoutTime_STEP_POSITION_INFORMATION castedObject = (InformationObjectWithoutTime_STEP_POSITION_INFORMATION)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processValueWithTransientStateIndication(castedObject.getVti());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case BITSTRING_OF_32_BIT: {
                InformationObjectWithoutTime_BITSTRING_OF_32_BIT castedObject = (InformationObjectWithoutTime_BITSTRING_OF_32_BIT)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processBinaryStateInformation(castedObject.getBsi());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case MEASURED_VALUE_NORMALISED_VALUE: {
                InformationObjectWithoutTime_MEASURED_VALUE_NORMALISED_VALUE castedObject = (InformationObjectWithoutTime_MEASURED_VALUE_NORMALISED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processNormalizedValue(castedObject.getNva());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case MEASURED_VALUE_SCALED_VALUE: {
                InformationObjectWithoutTime_MEASURED_VALUE_SCALED_VALUE castedObject = (InformationObjectWithoutTime_MEASURED_VALUE_SCALED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processScaledValue(castedObject.getSva());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER: {
                InformationObjectWithoutTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER castedObject = (InformationObjectWithoutTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER)informationObject;
                PlcREAL plcValue = PlcREAL.of((Object)Float.valueOf(castedObject.getValue()));
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), (PlcValueAdapter)plcValue);
                return plcValue;
            }
            case INTEGRATED_TOTALS: {
                InformationObjectWithoutTime_INTEGRATED_TOTALS castedObject = (InformationObjectWithoutTime_INTEGRATED_TOTALS)informationObject;
                return Iec608705104TagParser.processBinaryCounterReading(castedObject.getBcr());
            }
            case PACKED_SINGLE_POINT_INFORMATION_WITH_STATUS_CHANGE_DETECTION: {
                InformationObjectWithoutTime_PACKED_SINGLE_POINT_INFORMATION_WITH_STATUS_CHANGE_DETECTION castedObject = (InformationObjectWithoutTime_PACKED_SINGLE_POINT_INFORMATION_WITH_STATUS_CHANGE_DETECTION)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processStatusChangeDetection(castedObject.getScd());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case MEASURED_VALUE_NORMALIZED_VALUE_WITHOUT_QUALITY_DESCRIPTOR: {
                InformationObjectWithoutTime_MEASURED_VALUE_NORMALIZED_VALUE_WITHOUT_QUALITY_DESCRIPTOR castedObject = (InformationObjectWithoutTime_MEASURED_VALUE_NORMALIZED_VALUE_WITHOUT_QUALITY_DESCRIPTOR)informationObject;
                return Iec608705104TagParser.processNormalizedValue(castedObject.getNva());
            }
            case SINGLE_COMMAND: {
                InformationObjectWithoutTime_SINGLE_COMMAND castedObject = (InformationObjectWithoutTime_SINGLE_COMMAND)informationObject;
                return Iec608705104TagParser.processSingleCommand(castedObject.getSco());
            }
            case DOUBLE_COMMAND: {
                InformationObjectWithoutTime_DOUBLE_COMMAND castedObject = (InformationObjectWithoutTime_DOUBLE_COMMAND)informationObject;
                return Iec608705104TagParser.processDoubleCommand(castedObject.getDco());
            }
            case REGULATING_STEP_COMMAND: {
                InformationObjectWithoutTime_REGULATING_STEP_COMMAND castedObject = (InformationObjectWithoutTime_REGULATING_STEP_COMMAND)informationObject;
                return Iec608705104TagParser.processRegulatingStepCommand(castedObject.getRco());
            }
            case SET_POINT_COMMAND_NORMALISED_VALUE: {
                InformationObjectWithoutTime_SET_POINT_COMMAND_NORMALISED_VALUE castedObject = (InformationObjectWithoutTime_SET_POINT_COMMAND_NORMALISED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processNormalizedValue(castedObject.getNva());
                Iec608705104TagParser.processQualifierOfSetPointCommand(castedObject.getQos(), plcValue);
                return plcValue;
            }
            case SET_POINT_COMMAND_SCALED_VALUE: {
                InformationObjectWithoutTime_SET_POINT_COMMAND_SCALED_VALUE castedObject = (InformationObjectWithoutTime_SET_POINT_COMMAND_SCALED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processScaledValue(castedObject.getSva());
                Iec608705104TagParser.processQualifierOfSetPointCommand(castedObject.getQos(), plcValue);
                return plcValue;
            }
            case SET_POINT_COMMAND_SHORT_FLOATING_POINT_NUMBER: {
                InformationObjectWithoutTime_SET_POINT_COMMAND_SHORT_FLOATING_POINT_NUMBER castedObject = (InformationObjectWithoutTime_SET_POINT_COMMAND_SHORT_FLOATING_POINT_NUMBER)informationObject;
                PlcREAL plcValue = PlcREAL.of((Object)Float.valueOf(castedObject.getValue()));
                Iec608705104TagParser.processQualifierOfSetPointCommand(castedObject.getQos(), (PlcValueAdapter)plcValue);
                return plcValue;
            }
            case BITSTRING_32_BIT_COMMAND: {
                InformationObjectWithoutTime_BITSTRING_32_BIT_COMMAND castedObject = (InformationObjectWithoutTime_BITSTRING_32_BIT_COMMAND)informationObject;
                return Iec608705104TagParser.processBinaryStateInformation(castedObject.getBsi());
            }
            case END_OF_INITIALISATION: {
                InformationObjectWithoutTime_END_OF_INITIALISATION castedObject = (InformationObjectWithoutTime_END_OF_INITIALISATION)informationObject;
                return Iec608705104TagParser.processCauseOfInitialization(castedObject.getCoi());
            }
            case INTERROGATION_COMMAND: {
                InformationObjectWithoutTime_INTERROGATION_COMMAND castedObject = (InformationObjectWithoutTime_INTERROGATION_COMMAND)informationObject;
                return Iec608705104TagParser.processQualifierOfInterrogation(castedObject.getQoi());
            }
            case COUNTER_INTERROGATION_COMMAND: {
                InformationObjectWithoutTime_COUNTER_INTERROGATION_COMMAND castedObject = (InformationObjectWithoutTime_COUNTER_INTERROGATION_COMMAND)informationObject;
                return Iec608705104TagParser.processQualifierOfCounterInterrogationCommand(castedObject.getQcc());
            }
            case READ_COMMAND: {
                InformationObjectWithoutTime_READ_COMMAND castedObject = (InformationObjectWithoutTime_READ_COMMAND)informationObject;
                break;
            }
            case CLOCK_SYNCHRONISATION_COMMAND: {
                InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND castedObject = (InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND)informationObject;
                return Iec608705104TagParser.processSevenOctetBinaryTime(castedObject.getCp56Time2a());
            }
            case TEST_COMMAND: {
                InformationObjectWithoutTime_TEST_COMMAND castedObject = (InformationObjectWithoutTime_TEST_COMMAND)informationObject;
                return Iec608705104TagParser.processFixedTestBitPatternTwoOctet(castedObject.getFbp());
            }
            case RESET_PROCESS_COMMAND: {
                InformationObjectWithoutTime_RESET_PROCESS_COMMAND castedObject = (InformationObjectWithoutTime_RESET_PROCESS_COMMAND)informationObject;
                return Iec608705104TagParser.processQualifierOfResetProcessCommand(castedObject.getQrp());
            }
            case DELAY_ACQUISITION_COMMAND: {
                InformationObjectWithoutTime_DELAY_ACQUISITION_COMMAND castedObject = (InformationObjectWithoutTime_DELAY_ACQUISITION_COMMAND)informationObject;
                return Iec608705104TagParser.processTwoOctetBinaryTime(castedObject.getCp16Time2a());
            }
            case PARAMETER_OF_MEASURED_VALUES_NORMALIZED_VALUE: {
                InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_NORMALIZED_VALUE castedObject = (InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_NORMALIZED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processNormalizedValue(castedObject.getNva());
                Iec608705104TagParser.processQualifierOfParameterOfMeasuredValues(castedObject.getQpm(), plcValue);
                return plcValue;
            }
            case PARAMETER_OF_MEASURED_VALUES_SCALED_VALUE: {
                InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_SCALED_VALUE castedObject = (InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_SCALED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processScaledValue(castedObject.getSva());
                Iec608705104TagParser.processQualifierOfParameterOfMeasuredValues(castedObject.getQpm(), plcValue);
                return plcValue;
            }
            case PARAMETER_OF_MEASURED_VALUES_SHORT_FLOATING_POINT_NUMBER: {
                InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_SHORT_FLOATING_POINT_NUMBER castedObject = (InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_SHORT_FLOATING_POINT_NUMBER)informationObject;
                PlcREAL plcValue = PlcREAL.of((Object)Float.valueOf(castedObject.getValue()));
                Iec608705104TagParser.processQualifierOfParameterOfMeasuredValues(castedObject.getQpm(), (PlcValueAdapter)plcValue);
                return plcValue;
            }
            case PARAMETER_ACTIVATION: {
                InformationObjectWithoutTime_PARAMETER_ACTIVATION castedObject = (InformationObjectWithoutTime_PARAMETER_ACTIVATION)informationObject;
                return Iec608705104TagParser.processQualifierOfParameterActivation(castedObject.getQpa());
            }
            case FILE_READY: {
                InformationObjectWithoutTime_FILE_READY castedObject = (InformationObjectWithoutTime_FILE_READY)informationObject;
                break;
            }
            case SECTION_READY: {
                InformationObjectWithoutTime_SECTION_READY castedObject = (InformationObjectWithoutTime_SECTION_READY)informationObject;
                break;
            }
            case CALL_DIRECTORY_SELECT_FILE_CALL_FILE_CALL_SECTION: {
                InformationObjectWithoutTime_CALL_DIRECTORY_SELECT_FILE_CALL_FILE_CALL_SECTION castedObject = (InformationObjectWithoutTime_CALL_DIRECTORY_SELECT_FILE_CALL_FILE_CALL_SECTION)informationObject;
                break;
            }
            case LAST_SECTION_LAST_SEGMENT: {
                InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT castedObject = (InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT)informationObject;
                break;
            }
            case ACK_FILE_ACK_SECTION: {
                InformationObjectWithoutTime_ACK_FILE_ACK_SECTION castedObject = (InformationObjectWithoutTime_ACK_FILE_ACK_SECTION)informationObject;
                break;
            }
            case SEGMENT: {
                InformationObjectWithoutTime_SEGMENT castedObject = (InformationObjectWithoutTime_SEGMENT)informationObject;
                break;
            }
            case DIRECTORY: {
                InformationObjectWithoutTime_DIRECTORY castedObject = (InformationObjectWithoutTime_DIRECTORY)informationObject;
                break;
            }
            case MEASURED_VALUE_SCALED_VALUE_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_MEASURED_VALUE_SCALED_VALUE castedObject = (InformationObjectWithTreeByteTime_MEASURED_VALUE_SCALED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processScaledValue(castedObject.getSva());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case SINGLE_POINT_INFORMATION_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_SINGLE_POINT_INFORMATION castedObject = (InformationObjectWithTreeByteTime_SINGLE_POINT_INFORMATION)informationObject;
                return Iec608705104TagParser.processSinglePointInformation(castedObject.getSiq());
            }
            case DOUBLE_POINT_INFORMATION_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_DOUBLE_POINT_INFORMATION castedObject = (InformationObjectWithTreeByteTime_DOUBLE_POINT_INFORMATION)informationObject;
                return Iec608705104TagParser.processDoublePointInformation(castedObject.getDiq());
            }
            case STEP_POSITION_INFORMATION_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_STEP_POSITION_INFORMATION castedObject = (InformationObjectWithTreeByteTime_STEP_POSITION_INFORMATION)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processValueWithTransientStateIndication(castedObject.getVti());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case BITSTRING_OF_32_BIT_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_BITSTRING_OF_32_BIT castedObject = (InformationObjectWithTreeByteTime_BITSTRING_OF_32_BIT)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processBinaryStateInformation(castedObject.getBsi());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case MEASURED_VALUE_NORMALIZED_VALUE_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_MEASURED_VALUE_NORMALIZED_VALUE castedObject = (InformationObjectWithTreeByteTime_MEASURED_VALUE_NORMALIZED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processNormalizedValue(castedObject.getNva());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER castedObject = (InformationObjectWithTreeByteTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER)informationObject;
                PlcREAL plcValue = PlcREAL.of((Object)Float.valueOf(castedObject.getValue()));
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), (PlcValueAdapter)plcValue);
                return plcValue;
            }
            case INTEGRATED_TOTALS_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_INTEGRATED_TOTALS castedObject = (InformationObjectWithTreeByteTime_INTEGRATED_TOTALS)informationObject;
                return Iec608705104TagParser.processBinaryCounterReading(castedObject.getBcr());
            }
            case EVENT_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_EVENT_OF_PROTECTION_EQUIPMENT castedObject = (InformationObjectWithTreeByteTime_EVENT_OF_PROTECTION_EQUIPMENT)informationObject;
                break;
            }
            case PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT castedObject = (InformationObjectWithTreeByteTime_PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT)informationObject;
                break;
            }
            case PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG: {
                InformationObjectWithTreeByteTime_PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT castedObject = (InformationObjectWithTreeByteTime_PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT)informationObject;
                break;
            }
            case SINGLE_POINT_INFORMATION_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_SINGLE_POINT_INFORMATION castedObject = (InformationObjectWithSevenByteTime_SINGLE_POINT_INFORMATION)informationObject;
                return Iec608705104TagParser.processSinglePointInformation(castedObject.getSiq());
            }
            case DOUBLE_POINT_INFORMATION_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_DOUBLE_POINT_INFORMATION castedObject = (InformationObjectWithSevenByteTime_DOUBLE_POINT_INFORMATION)informationObject;
                return Iec608705104TagParser.processDoublePointInformation(castedObject.getDiq());
            }
            case STEP_POSITION_INFORMATION_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION castedObject = (InformationObjectWithSevenByteTime_STEP_POSITION_INFORMATION)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processValueWithTransientStateIndication(castedObject.getVti());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case BITSTRING_OF_32_BIT_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_BITSTRING_OF_32_BIT castedObject = (InformationObjectWithSevenByteTime_BITSTRING_OF_32_BIT)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processBinaryStateInformation(castedObject.getBsi());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case MEASURED_VALUE_NORMALISED_VALUE_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_MEASURED_VALUE_NORMALISED_VALUE castedObject = (InformationObjectWithSevenByteTime_MEASURED_VALUE_NORMALISED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processNormalizedValue(castedObject.getNva());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case MEASURED_VALUE_SCALED_VALUE_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_MEASURED_VALUE_SCALED_VALUE castedObject = (InformationObjectWithSevenByteTime_MEASURED_VALUE_SCALED_VALUE)informationObject;
                PlcValueAdapter plcValue = Iec608705104TagParser.processScaledValue(castedObject.getSva());
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), plcValue);
                return plcValue;
            }
            case MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER castedObject = (InformationObjectWithSevenByteTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER)informationObject;
                PlcREAL plcValue = PlcREAL.of((Object)Float.valueOf(castedObject.getValue()));
                Iec608705104TagParser.processQualityDescriptor(castedObject.getQds(), (PlcValueAdapter)plcValue);
                return plcValue;
            }
            case INTEGRATED_TOTALS_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_INTEGRATED_TOTALS castedObject = (InformationObjectWithSevenByteTime_INTEGRATED_TOTALS)informationObject;
                return Iec608705104TagParser.processBinaryCounterReading(castedObject.getBcr());
            }
            case EVENT_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_EVENT_OF_PROTECTION_EQUIPMENT castedObject = (InformationObjectWithSevenByteTime_EVENT_OF_PROTECTION_EQUIPMENT)informationObject;
                break;
            }
            case PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT castedObject = (InformationObjectWithSevenByteTime_PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT)informationObject;
                break;
            }
            case PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG_CP56TIME2A: {
                InformationObjectWithSevenByteTime_PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT informationObjectWithSevenByteTime_PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT = (InformationObjectWithSevenByteTime_PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT)informationObject;
            }
        }
        throw new NotImplementedException("Datatype " + typeIdentification.name() + " not implemented.");
    }

    public static PlcValueAdapter processSinglePointInformation(SinglePointInformation siq) {
        PlcBOOL plcValue = PlcBOOL.of((Object)siq.getStausOn());
        plcValue.addMetaData("invalid", (PlcValue)PlcBOOL.of((Object)siq.getInvalid()));
        plcValue.addMetaData("notTopical", (PlcValue)PlcBOOL.of((Object)siq.getNotTopical()));
        plcValue.addMetaData("substituted", (PlcValue)PlcBOOL.of((Object)siq.getSubstituted()));
        plcValue.addMetaData("blocked", (PlcValue)PlcBOOL.of((Object)siq.getBlocked()));
        return plcValue;
    }

    public static PlcValueAdapter processDoublePointInformation(DoublePointInformation diq) {
        boolean firstPoint = (diq.getDpiCode() & 1) != 0;
        boolean secondPoint = (diq.getDpiCode() & 2) != 0;
        PlcList plcValue = new PlcList(Arrays.asList(PlcBOOL.of((Object)firstPoint), PlcBOOL.of((Object)secondPoint)));
        plcValue.addMetaData("invalid", (PlcValue)PlcBOOL.of((Object)diq.getInvalid()));
        plcValue.addMetaData("notTopical", (PlcValue)PlcBOOL.of((Object)diq.getNotTopical()));
        plcValue.addMetaData("substituted", (PlcValue)PlcBOOL.of((Object)diq.getSubstituted()));
        plcValue.addMetaData("blocked", (PlcValue)PlcBOOL.of((Object)diq.getBlocked()));
        return plcValue;
    }

    public static PlcValueAdapter processBinaryStateInformation(BinaryStateInformation bsi) {
        return null;
    }

    public static PlcValueAdapter processStatusChangeDetection(StatusChangeDetection scd) {
        return null;
    }

    public static void processQualityDescriptor(QualityDescriptor qds, PlcValueAdapter plcValue) {
        plcValue.addMetaData("invalid", (PlcValue)PlcBOOL.of((Object)qds.getInvalid()));
        plcValue.addMetaData("notTopical", (PlcValue)PlcBOOL.of((Object)qds.getNotTopical()));
        plcValue.addMetaData("substituted", (PlcValue)PlcBOOL.of((Object)qds.getSubstituted()));
        plcValue.addMetaData("blocked", (PlcValue)PlcBOOL.of((Object)qds.getBlocked()));
        plcValue.addMetaData("overflow", (PlcValue)PlcBOOL.of((Object)qds.getOverflow()));
    }

    public static PlcValueAdapter processValueWithTransientStateIndication(ValueWithTransientStateIndication vti) {
        PlcUSINT plcValue = PlcUSINT.of((Object)vti.getValue());
        plcValue.addMetaData("transientState", (PlcValue)PlcBOOL.of((Object)vti.getTransientState()));
        return plcValue;
    }

    public static PlcValueAdapter processNormalizedValue(NormalizedValue nva) {
        return PlcUINT.of((Object)nva.getValue());
    }

    public static PlcValueAdapter processScaledValue(ScaledValue sva) {
        return PlcUINT.of((Object)sva.getValue());
    }

    public static PlcValueAdapter processBinaryCounterReading(BinaryCounterReading bcr) {
        PlcUDINT plcValue = PlcUDINT.of((Object)bcr.getCounterValue());
        plcValue.addMetaData("counterValid", (PlcValue)PlcBOOL.of((Object)bcr.getCounterValid()));
        plcValue.addMetaData("counterAdjusted", (PlcValue)PlcBOOL.of((Object)bcr.getCounterAdjusted()));
        plcValue.addMetaData("carry", (PlcValue)PlcBOOL.of((Object)bcr.getCarry()));
        plcValue.addMetaData("sequenceNumber", (PlcValue)PlcUSINT.of((Object)bcr.getSequenceNumber()));
        return plcValue;
    }

    public static PlcValueAdapter processSingleEventOfProtectionEquipment(SingleEventOfProtectionEquipment sep) {
        PlcUSINT plcValue = PlcUSINT.of((Object)sep.getEventState());
        plcValue.addMetaData("invalid", (PlcValue)PlcBOOL.of((Object)sep.getInvalid()));
        plcValue.addMetaData("notTopical", (PlcValue)PlcBOOL.of((Object)sep.getNotTopical()));
        plcValue.addMetaData("substituted", (PlcValue)PlcBOOL.of((Object)sep.getSubstituted()));
        plcValue.addMetaData("blocked", (PlcValue)PlcBOOL.of((Object)sep.getBlocked()));
        plcValue.addMetaData("elapsedTimeInvalid", (PlcValue)PlcBOOL.of((Object)sep.getElapsedTimeInvalid()));
        return plcValue;
    }

    public static PlcValueAdapter processOutputCircuitInformation(OutputCircuitInformation oci) {
        HashMap<String, PlcBOOL> plcValues = new HashMap<String, PlcBOOL>();
        plcValues.put("stateOfOperationPhaseL3", PlcBOOL.of((Object)oci.getStateOfOperationPhaseL3()));
        plcValues.put("stateOfOperationPhaseL2", PlcBOOL.of((Object)oci.getStateOfOperationPhaseL2()));
        plcValues.put("stateOfOperationPhaseL1", PlcBOOL.of((Object)oci.getStateOfOperationPhaseL1()));
        plcValues.put("generalStartOfOperation", PlcBOOL.of((Object)oci.getGeneralStartOfOperation()));
        return new PlcStruct(plcValues);
    }

    public static void processQualityDescriptorForPointsOfProtectionEquipment(QualityDescriptorForPointsOfProtectionEquipment qdp, PlcValueAdapter plcValue) {
        plcValue.addMetaData("invalid", (PlcValue)PlcBOOL.of((Object)qdp.getInvalid()));
        plcValue.addMetaData("notTopical", (PlcValue)PlcBOOL.of((Object)qdp.getNotTopical()));
        plcValue.addMetaData("substituted", (PlcValue)PlcBOOL.of((Object)qdp.getSubstituted()));
        plcValue.addMetaData("blocked", (PlcValue)PlcBOOL.of((Object)qdp.getBlocked()));
        plcValue.addMetaData("elapsedTimeInvalid", (PlcValue)PlcBOOL.of((Object)qdp.getElapsedTimeInvalid()));
    }

    public static PlcValueAdapter processSingleCommand(SingleCommand sco) {
        return null;
    }

    public static PlcValueAdapter processDoubleCommand(DoubleCommand dco) {
        return null;
    }

    public static PlcValueAdapter processRegulatingStepCommand(RegulatingStepCommand rco) {
        return null;
    }

    public static PlcValueAdapter processSevenOctetBinaryTime(SevenOctetBinaryTime cp56Time2a) {
        return null;
    }

    public static PlcValueAdapter processThreeOctetBinaryTime(ThreeOctetBinaryTime cp24Time2a) {
        return null;
    }

    public static PlcValueAdapter processTwoOctetBinaryTime(TwoOctetBinaryTime cp16Time2a) {
        return null;
    }

    public static PlcValueAdapter processQualifierOfInterrogation(QualifierOfInterrogation qoi) {
        return PlcUINT.of((Object)qoi.getQualifierOfCommand());
    }

    public static PlcValueAdapter processQualifierOfCounterInterrogationCommand(QualifierOfCounterInterrogationCommand qcc) {
        return new PlcStruct(Map.of("freeze", PlcUSINT.of((Object)qcc.getFreeze()), "request", PlcUSINT.of((Object)qcc.getRequest())));
    }

    public static PlcValueAdapter processQualifierOfParameterOfMeasuredValues(QualifierOfParameterOfMeasuredValues qpm, PlcValueAdapter plcValue) {
        plcValue.addMetaData("parameterInOperation", (PlcValue)PlcBOOL.of((Object)qpm.getParameterInOperation()));
        plcValue.addMetaData("localParameterChange", (PlcValue)PlcBOOL.of((Object)qpm.getLocalParameterChange()));
        plcValue.addMetaData("kindOfParameter", (PlcValue)PlcUSINT.of((Object)qpm.getKindOfParameter()));
        return plcValue;
    }

    public static PlcValueAdapter processQualifierOfParameterActivation(QualifierOfParameterActivation qpa) {
        return PlcUINT.of((Object)qpa.getQualifier());
    }

    public static PlcValueAdapter processQualifierOfCommand(QualifierOfCommand qoc) {
        PlcUSINT plcValue = PlcUSINT.of((Object)qoc.getQualifier());
        plcValue.addMetaData("select", (PlcValue)PlcBOOL.of((Object)qoc.getSelect()));
        return plcValue;
    }

    public static PlcValueAdapter processQualifierOfResetProcessCommand(QualifierOfResetProcessCommand qrp) {
        return PlcUINT.of((Object)qrp.getQualifier());
    }

    public static void processQualifierOfSetPointCommand(QualifierOfSetPointCommand qos, PlcValueAdapter plcValue) {
        plcValue.addMetaData("select", (PlcValue)PlcBOOL.of((Object)qos.getSelect()));
        plcValue.addMetaData("qualifier", (PlcValue)PlcUSINT.of((Object)qos.getQualifier()));
    }

    public static PlcValueAdapter processCauseOfInitialization(CauseOfInitialization coi) {
        PlcUSINT plcValue = PlcUSINT.of((Object)coi.getQualifier());
        plcValue.addMetaData("select", (PlcValue)PlcBOOL.of((Object)coi.getSelect()));
        return plcValue;
    }

    public static PlcValueAdapter processFixedTestBitPatternTwoOctet(FixedTestBitPatternTwoOctet fbp) {
        return PlcWORD.of((Object)fbp.getPattern());
    }
}

