/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DIBDeviceInfo implements Message {

  // Properties.
  protected final short descriptionType;
  protected final KnxMedium knxMedium;
  protected final DeviceStatus deviceStatus;
  protected final KnxAddress knxAddress;
  protected final ProjectInstallationIdentifier projectInstallationIdentifier;
  protected final byte[] knxNetIpDeviceSerialNumber;
  protected final IPAddress knxNetIpDeviceMulticastAddress;
  protected final MACAddress knxNetIpDeviceMacAddress;
  protected final byte[] deviceFriendlyName;

  public DIBDeviceInfo(
      short descriptionType,
      KnxMedium knxMedium,
      DeviceStatus deviceStatus,
      KnxAddress knxAddress,
      ProjectInstallationIdentifier projectInstallationIdentifier,
      byte[] knxNetIpDeviceSerialNumber,
      IPAddress knxNetIpDeviceMulticastAddress,
      MACAddress knxNetIpDeviceMacAddress,
      byte[] deviceFriendlyName) {
    super();
    this.descriptionType = descriptionType;
    this.knxMedium = knxMedium;
    this.deviceStatus = deviceStatus;
    this.knxAddress = knxAddress;
    this.projectInstallationIdentifier = projectInstallationIdentifier;
    this.knxNetIpDeviceSerialNumber = knxNetIpDeviceSerialNumber;
    this.knxNetIpDeviceMulticastAddress = knxNetIpDeviceMulticastAddress;
    this.knxNetIpDeviceMacAddress = knxNetIpDeviceMacAddress;
    this.deviceFriendlyName = deviceFriendlyName;
  }

  public short getDescriptionType() {
    return descriptionType;
  }

  public KnxMedium getKnxMedium() {
    return knxMedium;
  }

  public DeviceStatus getDeviceStatus() {
    return deviceStatus;
  }

  public KnxAddress getKnxAddress() {
    return knxAddress;
  }

  public ProjectInstallationIdentifier getProjectInstallationIdentifier() {
    return projectInstallationIdentifier;
  }

  public byte[] getKnxNetIpDeviceSerialNumber() {
    return knxNetIpDeviceSerialNumber;
  }

  public IPAddress getKnxNetIpDeviceMulticastAddress() {
    return knxNetIpDeviceMulticastAddress;
  }

  public MACAddress getKnxNetIpDeviceMacAddress() {
    return knxNetIpDeviceMacAddress;
  }

  public byte[] getDeviceFriendlyName() {
    return deviceFriendlyName;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("DIBDeviceInfo");

    // Implicit Field (structureLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    short structureLength = (short) (getLengthInBytes());
    writeImplicitField("structureLength", structureLength, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (descriptionType)
    writeSimpleField("descriptionType", descriptionType, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (knxMedium)
    writeSimpleEnumField(
        "knxMedium",
        "KnxMedium",
        knxMedium,
        new DataWriterEnumDefault<>(
            KnxMedium::getValue, KnxMedium::name, writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (deviceStatus)
    writeSimpleField("deviceStatus", deviceStatus, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (knxAddress)
    writeSimpleField("knxAddress", knxAddress, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (projectInstallationIdentifier)
    writeSimpleField(
        "projectInstallationIdentifier",
        projectInstallationIdentifier,
        new DataWriterComplexDefault<>(writeBuffer));

    // Array Field (knxNetIpDeviceSerialNumber)
    writeByteArrayField(
        "knxNetIpDeviceSerialNumber", knxNetIpDeviceSerialNumber, writeByteArray(writeBuffer, 8));

    // Simple Field (knxNetIpDeviceMulticastAddress)
    writeSimpleField(
        "knxNetIpDeviceMulticastAddress",
        knxNetIpDeviceMulticastAddress,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (knxNetIpDeviceMacAddress)
    writeSimpleField(
        "knxNetIpDeviceMacAddress",
        knxNetIpDeviceMacAddress,
        new DataWriterComplexDefault<>(writeBuffer));

    // Array Field (deviceFriendlyName)
    writeByteArrayField("deviceFriendlyName", deviceFriendlyName, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("DIBDeviceInfo");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    DIBDeviceInfo _value = this;

    // Implicit Field (structureLength)
    lengthInBits += 8;

    // Simple field (descriptionType)
    lengthInBits += 8;

    // Simple field (knxMedium)
    lengthInBits += 8;

    // Simple field (deviceStatus)
    lengthInBits += deviceStatus.getLengthInBits();

    // Simple field (knxAddress)
    lengthInBits += knxAddress.getLengthInBits();

    // Simple field (projectInstallationIdentifier)
    lengthInBits += projectInstallationIdentifier.getLengthInBits();

    // Array field
    if (knxNetIpDeviceSerialNumber != null) {
      lengthInBits += 8 * knxNetIpDeviceSerialNumber.length;
    }

    // Simple field (knxNetIpDeviceMulticastAddress)
    lengthInBits += knxNetIpDeviceMulticastAddress.getLengthInBits();

    // Simple field (knxNetIpDeviceMacAddress)
    lengthInBits += knxNetIpDeviceMacAddress.getLengthInBits();

    // Array field
    if (deviceFriendlyName != null) {
      lengthInBits += 8 * deviceFriendlyName.length;
    }

    return lengthInBits;
  }

  public static DIBDeviceInfo staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static DIBDeviceInfo staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("DIBDeviceInfo");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short structureLength = readImplicitField("structureLength", readUnsignedShort(readBuffer, 8));

    short descriptionType = readSimpleField("descriptionType", readUnsignedShort(readBuffer, 8));

    KnxMedium knxMedium =
        readEnumField(
            "knxMedium",
            "KnxMedium",
            new DataReaderEnumDefault<>(KnxMedium::enumForValue, readUnsignedShort(readBuffer, 8)));

    DeviceStatus deviceStatus =
        readSimpleField(
            "deviceStatus",
            new DataReaderComplexDefault<>(() -> DeviceStatus.staticParse(readBuffer), readBuffer));

    KnxAddress knxAddress =
        readSimpleField(
            "knxAddress",
            new DataReaderComplexDefault<>(() -> KnxAddress.staticParse(readBuffer), readBuffer));

    ProjectInstallationIdentifier projectInstallationIdentifier =
        readSimpleField(
            "projectInstallationIdentifier",
            new DataReaderComplexDefault<>(
                () -> ProjectInstallationIdentifier.staticParse(readBuffer), readBuffer));

    byte[] knxNetIpDeviceSerialNumber =
        readBuffer.readByteArray("knxNetIpDeviceSerialNumber", Math.toIntExact(6));

    IPAddress knxNetIpDeviceMulticastAddress =
        readSimpleField(
            "knxNetIpDeviceMulticastAddress",
            new DataReaderComplexDefault<>(() -> IPAddress.staticParse(readBuffer), readBuffer));

    MACAddress knxNetIpDeviceMacAddress =
        readSimpleField(
            "knxNetIpDeviceMacAddress",
            new DataReaderComplexDefault<>(() -> MACAddress.staticParse(readBuffer), readBuffer));

    byte[] deviceFriendlyName = readBuffer.readByteArray("deviceFriendlyName", Math.toIntExact(30));

    readBuffer.closeContext("DIBDeviceInfo");
    // Create the instance
    DIBDeviceInfo _dIBDeviceInfo;
    _dIBDeviceInfo =
        new DIBDeviceInfo(
            descriptionType,
            knxMedium,
            deviceStatus,
            knxAddress,
            projectInstallationIdentifier,
            knxNetIpDeviceSerialNumber,
            knxNetIpDeviceMulticastAddress,
            knxNetIpDeviceMacAddress,
            deviceFriendlyName);
    return _dIBDeviceInfo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DIBDeviceInfo)) {
      return false;
    }
    DIBDeviceInfo that = (DIBDeviceInfo) o;
    return (getDescriptionType() == that.getDescriptionType())
        && (getKnxMedium() == that.getKnxMedium())
        && (getDeviceStatus() == that.getDeviceStatus())
        && (getKnxAddress() == that.getKnxAddress())
        && (getProjectInstallationIdentifier() == that.getProjectInstallationIdentifier())
        && (getKnxNetIpDeviceSerialNumber() == that.getKnxNetIpDeviceSerialNumber())
        && (getKnxNetIpDeviceMulticastAddress() == that.getKnxNetIpDeviceMulticastAddress())
        && (getKnxNetIpDeviceMacAddress() == that.getKnxNetIpDeviceMacAddress())
        && (getDeviceFriendlyName() == that.getDeviceFriendlyName())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getDescriptionType(),
        getKnxMedium(),
        getDeviceStatus(),
        getKnxAddress(),
        getProjectInstallationIdentifier(),
        getKnxNetIpDeviceSerialNumber(),
        getKnxNetIpDeviceMulticastAddress(),
        getKnxNetIpDeviceMacAddress(),
        getDeviceFriendlyName());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
