/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum KnxInterfaceObjectType {
  OT_UNKNOWN((int) 0, (String) "U", (String) "Unknown Interface Object Type"),
  OT_GENERAL((int) 1, (String) "G", (String) "General Interface Object Type"),
  OT_DEVICE((int) 2, (String) "0", (String) "Device Object"),
  OT_ADDRESS_TABLE((int) 3, (String) "1", (String) "Addresstable Object"),
  OT_ASSOCIATION_TABLE((int) 4, (String) "2", (String) "Associationtable Object"),
  OT_APPLICATION_PROGRAM((int) 5, (String) "3", (String) "Applicationprogram Object"),
  OT_INTERACE_PROGRAM((int) 6, (String) "4", (String) "Interfaceprogram Object"),
  OT_EIBOBJECT_ASSOCIATATION_TABLE(
      (int) 7, (String) "5", (String) "KNX-Object Associationtable Object"),
  OT_ROUTER((int) 8, (String) "6", (String) "Router Object"),
  OT_LTE_ADDRESS_ROUTING_TABLE((int) 9, (String) "7", (String) "LTE Address Routing Table Object"),
  OT_CEMI_SERVER((int) 10, (String) "8", (String) "cEMI Server Object"),
  OT_GROUP_OBJECT_TABLE((int) 11, (String) "9", (String) "Group Object Table Object"),
  OT_POLLING_MASTER((int) 12, (String) "10", (String) "Polling Master"),
  OT_KNXIP_PARAMETER((int) 13, (String) "11", (String) "KNXnet/IP Parameter Object"),
  OT_FILE_SERVER((int) 14, (String) "13", (String) "File Server Object"),
  OT_SECURITY((int) 15, (String) "17", (String) "Security Object"),
  OT_RF_MEDIUM((int) 16, (String) "19", (String) "RF Medium Object"),
  OT_INDOOR_BRIGHTNESS_SENSOR((int) 17, (String) "409", (String) "Indoor Brightness Sensor"),
  OT_INDOOR_LUMINANCE_SENSOR((int) 18, (String) "410", (String) "Indoor Luminance Sensor"),
  OT_LIGHT_SWITCHING_ACTUATOR_BASIC(
      (int) 19, (String) "417", (String) "Light Switching Actuator Basic"),
  OT_DIMMING_ACTUATOR_BASIC((int) 20, (String) "418", (String) "Dimming Actuator Basic"),
  OT_DIMMING_SENSOR_BASIC((int) 21, (String) "420", (String) "Dimming Sensor Basic"),
  OT_SWITCHING_SENSOR_BASIC((int) 22, (String) "421", (String) "Switching Sensor Basic"),
  OT_SUNBLIND_ACTUATOR_BASIC((int) 23, (String) "800", (String) "Sunblind Actuator Basic"),
  OT_SUNBLIND_SENSOR_BASIC((int) 24, (String) "801", (String) "Sunblind Sensor Basic");
  private static final Map<Integer, KnxInterfaceObjectType> map;

  static {
    map = new HashMap<>();
    for (KnxInterfaceObjectType value : KnxInterfaceObjectType.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private int value;
  private String code;
  private String name;

  KnxInterfaceObjectType(int value, String code, String name) {
    this.value = value;
    this.code = code;
    this.name = name;
  }

  public int getValue() {
    return value;
  }

  public String getCode() {
    return code;
  }

  public static KnxInterfaceObjectType firstEnumForFieldCode(String fieldValue) {
    for (KnxInterfaceObjectType _val : KnxInterfaceObjectType.values()) {
      if (_val.getCode() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxInterfaceObjectType> enumsForFieldCode(String fieldValue) {
    List<KnxInterfaceObjectType> _values = new ArrayList();
    for (KnxInterfaceObjectType _val : KnxInterfaceObjectType.values()) {
      if (_val.getCode() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getName() {
    return name;
  }

  public static KnxInterfaceObjectType firstEnumForFieldName(String fieldValue) {
    for (KnxInterfaceObjectType _val : KnxInterfaceObjectType.values()) {
      if (_val.getName() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxInterfaceObjectType> enumsForFieldName(String fieldValue) {
    List<KnxInterfaceObjectType> _values = new ArrayList();
    for (KnxInterfaceObjectType _val : KnxInterfaceObjectType.values()) {
      if (_val.getName() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static KnxInterfaceObjectType enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
