/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum KnxManufacturer {
  M_UNKNOWN((int) 0, (int) 0, (String) "Unknown Manufacturer"),
  M_SIEMENS((int) 1, (int) 1, (String) "Siemens"),
  M_ABB((int) 2, (int) 2, (String) "ABB"),
  M_ALBRECHT_JUNG((int) 3, (int) 4, (String) "Albrecht Jung"),
  M_BTICINO((int) 4, (int) 5, (String) "Bticino"),
  M_BERKER((int) 5, (int) 6, (String) "Berker"),
  M_BUSCH_JAEGER_ELEKTRO((int) 6, (int) 7, (String) "Busch-Jaeger Elektro"),
  M_GIRA_GIERSIEPEN((int) 7, (int) 8, (String) "GIRA Giersiepen"),
  M_HAGER_ELECTRO((int) 8, (int) 9, (String) "Hager Electro"),
  M_INSTA_GMBH((int) 9, (int) 10, (String) "Insta GmbH"),
  M_LEGRAND_APPAREILLAGE_ELECTRIQUE((int) 10, (int) 11, (String) "LEGRAND Appareillage électrique"),
  M_MERTEN((int) 11, (int) 12, (String) "Merten"),
  M_ABB_SPA_SACE_DIVISION((int) 12, (int) 14, (String) "ABB SpA-SACE Division"),
  M_SIEDLE_AND_SOEHNE((int) 13, (int) 22, (String) "Siedle & Söhne"),
  M_EBERLE((int) 14, (int) 24, (String) "Eberle"),
  M_GEWISS((int) 15, (int) 25, (String) "GEWISS"),
  M_ALBERT_ACKERMANN((int) 16, (int) 27, (String) "Albert Ackermann"),
  M_SCHUPA_GMBH((int) 17, (int) 28, (String) "Schupa GmbH"),
  M_ABB_SCHWEIZ((int) 18, (int) 29, (String) "ABB SCHWEIZ"),
  M_FELLER((int) 19, (int) 30, (String) "Feller"),
  M_GLAMOX_AS((int) 20, (int) 31, (String) "Glamox AS"),
  M_DEHN_AND_SOEHNE((int) 21, (int) 32, (String) "DEHN & SÖHNE"),
  M_CRABTREE((int) 22, (int) 33, (String) "CRABTREE"),
  M_EVOKNX((int) 23, (int) 34, (String) "eVoKNX"),
  M_PAUL_HOCHKOEPPER((int) 24, (int) 36, (String) "Paul Hochköpper"),
  M_ALTENBURGER_ELECTRONIC((int) 25, (int) 37, (String) "Altenburger Electronic"),
  M_GRAESSLIN((int) 26, (int) 41, (String) "Grässlin"),
  M_SIMON_42((int) 27, (int) 42, (String) "Simon"),
  M_VIMAR((int) 28, (int) 44, (String) "VIMAR"),
  M_MOELLER_GEBAEUDEAUTOMATION_KG((int) 29, (int) 45, (String) "Moeller Gebäudeautomation KG"),
  M_ELTAKO((int) 30, (int) 46, (String) "Eltako"),
  M_BOSCH_SIEMENS_HAUSHALTSGERAETE((int) 31, (int) 49, (String) "Bosch-Siemens Haushaltsgeräte"),
  M_RITTO_GMBHANDCO_KG((int) 32, (int) 52, (String) "RITTO GmbH&Co.KG"),
  M_POWER_CONTROLS((int) 33, (int) 53, (String) "Power Controls"),
  M_ZUMTOBEL((int) 34, (int) 55, (String) "ZUMTOBEL"),
  M_PHOENIX_CONTACT((int) 35, (int) 57, (String) "Phoenix Contact"),
  M_WAGO_KONTAKTTECHNIK((int) 36, (int) 61, (String) "WAGO Kontakttechnik"),
  M_KNXPRESSO((int) 37, (int) 62, (String) "knXpresso"),
  M_WIELAND_ELECTRIC((int) 38, (int) 66, (String) "Wieland Electric"),
  M_HERMANN_KLEINHUIS((int) 39, (int) 67, (String) "Hermann Kleinhuis"),
  M_STIEBEL_ELTRON((int) 40, (int) 69, (String) "Stiebel Eltron"),
  M_TEHALIT((int) 41, (int) 71, (String) "Tehalit"),
  M_THEBEN_AG((int) 42, (int) 72, (String) "Theben AG"),
  M_WILHELM_RUTENBECK((int) 43, (int) 73, (String) "Wilhelm Rutenbeck"),
  M_WINKHAUS((int) 44, (int) 75, (String) "Winkhaus"),
  M_ROBERT_BOSCH((int) 45, (int) 76, (String) "Robert Bosch"),
  M_SOMFY((int) 46, (int) 78, (String) "Somfy"),
  M_WOERTZ((int) 47, (int) 80, (String) "Woertz"),
  M_VIESSMANN_WERKE((int) 48, (int) 81, (String) "Viessmann Werke"),
  M_IMI_HYDRONIC_ENGINEERING((int) 49, (int) 82, (String) "IMI Hydronic Engineering"),
  M_JOH__VAILLANT((int) 50, (int) 83, (String) "Joh. Vaillant"),
  M_AMP_DEUTSCHLAND((int) 51, (int) 85, (String) "AMP Deutschland"),
  M_BOSCH_THERMOTECHNIK_GMBH((int) 52, (int) 89, (String) "Bosch Thermotechnik GmbH"),
  M_SEF___ECOTEC((int) 53, (int) 90, (String) "SEF - ECOTEC"),
  M_DORMA_GMBH_Plus_CO__KG((int) 54, (int) 92, (String) "DORMA GmbH + Co. KG"),
  M_WINDOWMASTER_AS((int) 55, (int) 93, (String) "WindowMaster A/S"),
  M_WALTHER_WERKE((int) 56, (int) 94, (String) "Walther Werke"),
  M_ORAS((int) 57, (int) 95, (String) "ORAS"),
  M_DAETWYLER((int) 58, (int) 97, (String) "Dätwyler"),
  M_ELECTRAK((int) 59, (int) 98, (String) "Electrak"),
  M_TECHEM((int) 60, (int) 99, (String) "Techem"),
  M_SCHNEIDER_ELECTRIC_INDUSTRIES_SAS(
      (int) 61, (int) 100, (String) "Schneider Electric Industries SAS"),
  M_WHD_WILHELM_HUBER_Plus_SOEHNE((int) 62, (int) 101, (String) "WHD Wilhelm Huber + Söhne"),
  M_BISCHOFF_ELEKTRONIK((int) 63, (int) 102, (String) "Bischoff Elektronik"),
  M_JEPAZ((int) 64, (int) 104, (String) "JEPAZ"),
  M_RTS_AUTOMATION((int) 65, (int) 105, (String) "RTS Automation"),
  M_EIBMARKT_GMBH((int) 66, (int) 106, (String) "EIBMARKT GmbH"),
  M_WAREMA_RENKHOFF_SE((int) 67, (int) 107, (String) "WAREMA Renkhoff SE"),
  M_EELECTRON((int) 68, (int) 108, (String) "Eelectron"),
  M_BELDEN_WIRE_AND_CABLE_B_V_((int) 69, (int) 109, (String) "Belden Wire & Cable B.V."),
  M_BECKER_ANTRIEBE_GMBH((int) 70, (int) 110, (String) "Becker-Antriebe GmbH"),
  M_J_STEHLEPlusSOEHNE_GMBH((int) 71, (int) 111, (String) "J.Stehle+Söhne GmbH"),
  M_AGFEO((int) 72, (int) 112, (String) "AGFEO"),
  M_ZENNIO((int) 73, (int) 113, (String) "Zennio"),
  M_TAPKO_TECHNOLOGIES((int) 74, (int) 114, (String) "TAPKO Technologies"),
  M_HDL((int) 75, (int) 115, (String) "HDL"),
  M_UPONOR((int) 76, (int) 116, (String) "Uponor"),
  M_SE_LIGHTMANAGEMENT_AG((int) 77, (int) 117, (String) "se Lightmanagement AG"),
  M_ARCUS_EDS((int) 78, (int) 118, (String) "Arcus-eds"),
  M_INTESIS((int) 79, (int) 119, (String) "Intesis"),
  M_HERHOLDT_CONTROLS_SRL((int) 80, (int) 120, (String) "Herholdt Controls srl"),
  M_NIKO_ZUBLIN((int) 81, (int) 121, (String) "Niko-Zublin"),
  M_DURABLE_TECHNOLOGIES((int) 82, (int) 122, (String) "Durable Technologies"),
  M_INNOTEAM((int) 83, (int) 123, (String) "Innoteam"),
  M_ISE_GMBH((int) 84, (int) 124, (String) "ise GmbH"),
  M_TEAM_FOR_TRONICS((int) 85, (int) 125, (String) "TEAM FOR TRONICS"),
  M_CIAT((int) 86, (int) 126, (String) "CIAT"),
  M_REMEHA_BV((int) 87, (int) 127, (String) "Remeha BV"),
  M_ESYLUX((int) 88, (int) 128, (String) "ESYLUX"),
  M_BASALTE((int) 89, (int) 129, (String) "BASALTE"),
  M_VESTAMATIC((int) 90, (int) 130, (String) "Vestamatic"),
  M_MDT_TECHNOLOGIES((int) 91, (int) 131, (String) "MDT technologies"),
  M_WARENDORFER_KUECHEN_GMBH((int) 92, (int) 132, (String) "Warendorfer Küchen GmbH"),
  M_VIDEO_STAR((int) 93, (int) 133, (String) "Video-Star"),
  M_SITEK((int) 94, (int) 134, (String) "Sitek"),
  M_CONTROLTRONIC((int) 95, (int) 135, (String) "CONTROLtronic"),
  M_FUNCTION_TECHNOLOGY((int) 96, (int) 136, (String) "function Technology"),
  M_AMX((int) 97, (int) 137, (String) "AMX"),
  M_ELDAT((int) 98, (int) 138, (String) "ELDAT"),
  M_PANASONIC((int) 99, (int) 139, (String) "Panasonic"),
  M_PULSE_TECHNOLOGIES((int) 100, (int) 140, (String) "Pulse Technologies"),
  M_CRESTRON((int) 101, (int) 141, (String) "Crestron"),
  M_STEINEL_PROFESSIONAL((int) 102, (int) 142, (String) "STEINEL professional"),
  M_BILTON_LED_LIGHTING((int) 103, (int) 143, (String) "BILTON LED Lighting"),
  M_DENRO_AG((int) 104, (int) 144, (String) "denro AG"),
  M_GEPRO((int) 105, (int) 145, (String) "GePro"),
  M_PREUSSEN_AUTOMATION((int) 106, (int) 146, (String) "preussen automation"),
  M_ZOPPAS_INDUSTRIES((int) 107, (int) 147, (String) "Zoppas Industries"),
  M_MACTECH((int) 108, (int) 148, (String) "MACTECH"),
  M_TECHNO_TREND((int) 109, (int) 149, (String) "TECHNO-TREND"),
  M_FS_CABLES((int) 110, (int) 150, (String) "FS Cables"),
  M_DELTA_DORE((int) 111, (int) 151, (String) "Delta Dore"),
  M_EISSOUND((int) 112, (int) 152, (String) "Eissound"),
  M_CISCO((int) 113, (int) 153, (String) "Cisco"),
  M_DINUY((int) 114, (int) 154, (String) "Dinuy"),
  M_IKNIX((int) 115, (int) 155, (String) "iKNiX"),
  M_RADEMACHER_GERAETE_ELEKTRONIK_GMBH(
      (int) 116, (int) 156, (String) "Rademacher Geräte-Elektronik GmbH"),
  M_EGI_ELECTROACUSTICA_GENERAL_IBERICA(
      (int) 117, (int) 157, (String) "EGi Electroacustica General Iberica"),
  M_BES___INGENIUM((int) 118, (int) 158, (String) "Bes – Ingenium"),
  M_ELABNET((int) 119, (int) 159, (String) "ElabNET"),
  M_BLUMOTIX((int) 120, (int) 160, (String) "Blumotix"),
  M_HUNTER_DOUGLAS((int) 121, (int) 161, (String) "Hunter Douglas"),
  M_APRICUM((int) 122, (int) 162, (String) "APRICUM"),
  M_TIANSU_AUTOMATION((int) 123, (int) 163, (String) "TIANSU Automation"),
  M_BUBENDORFF((int) 124, (int) 164, (String) "Bubendorff"),
  M_MBS_GMBH((int) 125, (int) 165, (String) "MBS GmbH"),
  M_ENERTEX_BAYERN_GMBH((int) 126, (int) 166, (String) "Enertex Bayern GmbH"),
  M_BMS((int) 127, (int) 167, (String) "BMS"),
  M_SINAPSI((int) 128, (int) 168, (String) "Sinapsi"),
  M_EMBEDDED_SYSTEMS_SIA((int) 129, (int) 169, (String) "Embedded Systems SIA"),
  M_KNX1((int) 130, (int) 170, (String) "KNX1"),
  M_TOKKA((int) 131, (int) 171, (String) "Tokka"),
  M_NANOSENSE((int) 132, (int) 172, (String) "NanoSense"),
  M_PEAR_AUTOMATION_GMBH((int) 133, (int) 173, (String) "PEAR Automation GmbH"),
  M_DGA((int) 134, (int) 174, (String) "DGA"),
  M_LUTRON((int) 135, (int) 175, (String) "Lutron"),
  M_AIRZONE___ALTRA((int) 136, (int) 176, (String) "AIRZONE – ALTRA"),
  M_LITHOSS_DESIGN_SWITCHES((int) 137, (int) 177, (String) "Lithoss Design Switches"),
  M_THREEATEL((int) 138, (int) 178, (String) "3ATEL"),
  M_PHILIPS_CONTROLS((int) 139, (int) 179, (String) "Philips Controls"),
  M_VELUX_AS((int) 140, (int) 180, (String) "VELUX A/S"),
  M_LOYTEC((int) 141, (int) 181, (String) "LOYTEC"),
  M_EKINEX_S_P_A_((int) 142, (int) 182, (String) "Ekinex S.p.A."),
  M_SIRLAN_TECHNOLOGIES((int) 143, (int) 183, (String) "SIRLAN Technologies"),
  M_PROKNX_SAS((int) 144, (int) 184, (String) "ProKNX SAS"),
  M_IT_GMBH((int) 145, (int) 185, (String) "IT GmbH"),
  M_RENSON((int) 146, (int) 186, (String) "RENSON"),
  M_HEP_GROUP((int) 147, (int) 187, (String) "HEP Group"),
  M_BALMART((int) 148, (int) 188, (String) "Balmart"),
  M_GFS_GMBH((int) 149, (int) 189, (String) "GFS GmbH"),
  M_SCHENKER_STOREN_AG((int) 150, (int) 190, (String) "Schenker Storen AG"),
  M_ALGODUE_ELETTRONICA_S_R_L_((int) 151, (int) 191, (String) "Algodue Elettronica S.r.L."),
  M_ABB_FRANCE((int) 152, (int) 192, (String) "ABB France"),
  M_MAINTRONIC((int) 153, (int) 193, (String) "maintronic"),
  M_VANTAGE((int) 154, (int) 194, (String) "Vantage"),
  M_FORESIS((int) 155, (int) 195, (String) "Foresis"),
  M_RESEARCH_AND_PRODUCTION_ASSOCIATION_SEM(
      (int) 156, (int) 196, (String) "Research & Production Association SEM"),
  M_WEINZIERL_ENGINEERING_GMBH((int) 157, (int) 197, (String) "Weinzierl Engineering GmbH"),
  M_MOEHLENHOFF_WAERMETECHNIK_GMBH((int) 158, (int) 198, (String) "Möhlenhoff Wärmetechnik GmbH"),
  M_PKC_GROUP_OYJ((int) 159, (int) 199, (String) "PKC-GROUP Oyj"),
  M_B_E_G_((int) 160, (int) 200, (String) "B.E.G."),
  M_ELSNER_ELEKTRONIK_GMBH((int) 161, (int) 201, (String) "Elsner Elektronik GmbH"),
  M_SIEMENS_BUILDING_TECHNOLOGIES_HKCHINA_LTD_(
      (int) 162, (int) 202, (String) "Siemens Building Technologies (HK/China) Ltd."),
  M_EUTRAC((int) 163, (int) 204, (String) "Eutrac"),
  M_GUSTAV_HENSEL_GMBH_AND_CO__KG((int) 164, (int) 205, (String) "Gustav Hensel GmbH & Co. KG"),
  M_GARO_AB((int) 165, (int) 206, (String) "GARO AB"),
  M_WALDMANN_LICHTTECHNIK((int) 166, (int) 207, (String) "Waldmann Lichttechnik"),
  M_SCHUECO((int) 167, (int) 208, (String) "SCHÜCO"),
  M_EMU((int) 168, (int) 209, (String) "EMU"),
  M_JNET_SYSTEMS_AG((int) 169, (int) 210, (String) "JNet Systems AG"),
  M_TOTAL_SOLUTION_GMBH((int) 170, (int) 211, (String) "Total Solution GmbH"),
  M_O_Y_L__ELECTRONICS((int) 171, (int) 214, (String) "O.Y.L. Electronics"),
  M_GALAX_SYSTEM((int) 172, (int) 215, (String) "Galax System"),
  M_DISCH((int) 173, (int) 216, (String) "Disch"),
  M_AUCOTEAM((int) 174, (int) 217, (String) "Aucoteam"),
  M_LUXMATE_CONTROLS((int) 175, (int) 218, (String) "Luxmate Controls"),
  M_DANFOSS((int) 176, (int) 219, (String) "Danfoss"),
  M_AST_GMBH((int) 177, (int) 220, (String) "AST GmbH"),
  M_WILA_LEUCHTEN((int) 178, (int) 222, (String) "WILA Leuchten"),
  M_BPlusB_AUTOMATIONS__UND_STEUERUNGSTECHNIK(
      (int) 179, (int) 223, (String) "b+b Automations- und Steuerungstechnik"),
  M_LINGG_AND_JANKE((int) 180, (int) 225, (String) "Lingg & Janke"),
  M_SAUTER((int) 181, (int) 227, (String) "Sauter"),
  M_SIMU((int) 182, (int) 228, (String) "SIMU"),
  M_THEBEN_HTS_AG((int) 183, (int) 232, (String) "Theben HTS AG"),
  M_AMANN_GMBH((int) 184, (int) 233, (String) "Amann GmbH"),
  M_BERG_ENERGIEKONTROLLSYSTEME_GMBH(
      (int) 185, (int) 234, (String) "BERG Energiekontrollsysteme GmbH"),
  M_HUEPPE_FORM_SONNENSCHUTZSYSTEME_GMBH(
      (int) 186, (int) 235, (String) "Hüppe Form Sonnenschutzsysteme GmbH"),
  M_OVENTROP_KG((int) 187, (int) 237, (String) "Oventrop KG"),
  M_GRIESSER_AG((int) 188, (int) 238, (String) "Griesser AG"),
  M_IPAS_GMBH((int) 189, (int) 239, (String) "IPAS GmbH"),
  M_ELERO_GMBH((int) 190, (int) 240, (String) "elero GmbH"),
  M_ARDAN_PRODUCTION_AND_INDUSTRIAL_CONTROLS_LTD_(
      (int) 191, (int) 241, (String) "Ardan Production and Industrial Controls Ltd."),
  M_METEC_MESSTECHNIK_GMBH((int) 192, (int) 242, (String) "Metec Meßtechnik GmbH"),
  M_ELKA_ELEKTRONIK_GMBH((int) 193, (int) 244, (String) "ELKA-Elektronik GmbH"),
  M_ELEKTROANLAGEN_D__NAGEL((int) 194, (int) 245, (String) "ELEKTROANLAGEN D. NAGEL"),
  M_TRIDONIC_BAUELEMENTE_GMBH((int) 195, (int) 246, (String) "Tridonic Bauelemente GmbH"),
  M_STENGLER_GESELLSCHAFT((int) 196, (int) 248, (String) "Stengler Gesellschaft"),
  M_SCHNEIDER_ELECTRIC_MG((int) 197, (int) 249, (String) "Schneider Electric (MG)"),
  M_KNX_ASSOCIATION((int) 198, (int) 250, (String) "KNX Association"),
  M_VIVO((int) 199, (int) 251, (String) "VIVO"),
  M_HUGO_MUELLER_GMBH_AND_CO_KG((int) 200, (int) 252, (String) "Hugo Müller GmbH & Co KG"),
  M_SIEMENS_HVAC((int) 201, (int) 253, (String) "Siemens HVAC"),
  M_APT((int) 202, (int) 254, (String) "APT"),
  M_HIGHDOM((int) 203, (int) 256, (String) "HighDom"),
  M_TOP_SERVICES((int) 204, (int) 257, (String) "Top Services"),
  M_AMBIHOME((int) 205, (int) 258, (String) "ambiHome"),
  M_DATEC_ELECTRONIC_AG((int) 206, (int) 259, (String) "DATEC electronic AG"),
  M_ABUS_SECURITY_CENTER((int) 207, (int) 260, (String) "ABUS Security-Center"),
  M_LITE_PUTER((int) 208, (int) 261, (String) "Lite-Puter"),
  M_TANTRON_ELECTRONIC((int) 209, (int) 262, (String) "Tantron Electronic"),
  M_INTERRA((int) 210, (int) 263, (String) "Interra"),
  M_DKX_TECH((int) 211, (int) 264, (String) "DKX Tech"),
  M_VIATRON((int) 212, (int) 265, (String) "Viatron"),
  M_NAUTIBUS((int) 213, (int) 266, (String) "Nautibus"),
  M_ON_SEMICONDUCTOR((int) 214, (int) 267, (String) "ON Semiconductor"),
  M_LONGCHUANG((int) 215, (int) 268, (String) "Longchuang"),
  M_AIR_ON_AG((int) 216, (int) 269, (String) "Air-On AG"),
  M_IB_COMPANY_GMBH((int) 217, (int) 270, (String) "ib-company GmbH"),
  M_SATION_FACTORY((int) 218, (int) 271, (String) "Sation Factory"),
  M_AGENTILO_GMBH((int) 219, (int) 272, (String) "Agentilo GmbH"),
  M_MAKEL_ELEKTRIK((int) 220, (int) 273, (String) "Makel Elektrik"),
  M_HELIOS_VENTILATOREN((int) 221, (int) 274, (String) "Helios Ventilatoren"),
  M_OTTO_SOLUTIONS_PTE_LTD((int) 222, (int) 275, (String) "Otto Solutions Pte Ltd"),
  M_AIRMASTER((int) 223, (int) 276, (String) "Airmaster"),
  M_VALLOX_GMBH((int) 224, (int) 277, (String) "Vallox GmbH"),
  M_DALITEK((int) 225, (int) 278, (String) "Dalitek"),
  M_ASIN((int) 226, (int) 279, (String) "ASIN"),
  M_BRIDGES_INTELLIGENCE_TECHNOLOGY_INC_(
      (int) 227, (int) 280, (String) "Bridges Intelligence Technology Inc."),
  M_ARBONIA((int) 228, (int) 281, (String) "ARBONIA"),
  M_KERMI((int) 229, (int) 282, (String) "KERMI"),
  M_PROLUX((int) 230, (int) 283, (String) "PROLUX"),
  M_CLICHOME((int) 231, (int) 284, (String) "ClicHome"),
  M_COMMAX((int) 232, (int) 285, (String) "COMMAX"),
  M_EAE((int) 233, (int) 286, (String) "EAE"),
  M_TENSE((int) 234, (int) 287, (String) "Tense"),
  M_SEYOUNG_ELECTRONICS((int) 235, (int) 288, (String) "Seyoung Electronics"),
  M_LIFEDOMUS((int) 236, (int) 289, (String) "Lifedomus"),
  M_EUROTRONIC_TECHNOLOGY_GMBH((int) 237, (int) 290, (String) "EUROtronic Technology GmbH"),
  M_TCI((int) 238, (int) 291, (String) "tci"),
  M_RISHUN_ELECTRONIC((int) 239, (int) 292, (String) "Rishun Electronic"),
  M_ZIPATO((int) 240, (int) 293, (String) "Zipato"),
  M_CM_SECURITY_GMBH_AND_CO_KG((int) 241, (int) 294, (String) "cm-security GmbH & Co KG"),
  M_QING_CABLES((int) 242, (int) 295, (String) "Qing Cables"),
  M_LABIO((int) 243, (int) 296, (String) "LABIO"),
  M_COSTER_TECNOLOGIE_ELETTRONICHE_S_P_A_(
      (int) 244, (int) 297, (String) "Coster Tecnologie Elettroniche S.p.A."),
  M_E_G_E((int) 245, (int) 298, (String) "E.G.E"),
  M_NETXAUTOMATION((int) 246, (int) 299, (String) "NETxAutomation"),
  M_TECALOR((int) 247, (int) 300, (String) "tecalor"),
  M_URMET_ELECTRONICS_HUIZHOU_LTD_(
      (int) 248, (int) 301, (String) "Urmet Electronics (Huizhou) Ltd."),
  M_PEIYING_BUILDING_CONTROL((int) 249, (int) 302, (String) "Peiying Building Control"),
  M_BPT_S_P_A__A_SOCIO_UNICO((int) 250, (int) 303, (String) "BPT S.p.A. a Socio Unico"),
  M_KANONTEC___KANONBUS((int) 251, (int) 304, (String) "Kanontec - KanonBUS"),
  M_ISER_TECH((int) 252, (int) 305, (String) "ISER Tech"),
  M_FINELINE((int) 253, (int) 306, (String) "Fineline"),
  M_CP_ELECTRONICS_LTD((int) 254, (int) 307, (String) "CP Electronics Ltd"),
  M_NIKO_SERVODAN_AS((int) 255, (int) 308, (String) "Niko-Servodan A/S"),
  M_SIMON_309((int) 256, (int) 309, (String) "Simon"),
  M_GM_MODULAR_PVT__LTD_((int) 257, (int) 310, (String) "GM modular pvt. Ltd."),
  M_FU_CHENG_INTELLIGENCE((int) 258, (int) 311, (String) "FU CHENG Intelligence"),
  M_NEXKON((int) 259, (int) 312, (String) "NexKon"),
  M_FEEL_S_R_L((int) 260, (int) 313, (String) "FEEL s.r.l"),
  M_NOT_ASSIGNED_314((int) 261, (int) 314, (String) "Not Assigned"),
  M_SHENZHEN_FANHAI_SANJIANG_ELECTRONICS_CO___LTD_(
      (int) 262, (int) 315, (String) "Shenzhen Fanhai Sanjiang Electronics Co., Ltd."),
  M_JIUZHOU_GREEBLE((int) 263, (int) 316, (String) "Jiuzhou Greeble"),
  M_AUMUELLER_AUMATIC_GMBH((int) 264, (int) 317, (String) "Aumüller Aumatic GmbH"),
  M_ETMAN_ELECTRIC((int) 265, (int) 318, (String) "Etman Electric"),
  M_BLACK_NOVA((int) 266, (int) 319, (String) "Black Nova"),
  M_ZIDATECH_AG((int) 267, (int) 320, (String) "ZidaTech AG"),
  M_IDGS_BVBA((int) 268, (int) 321, (String) "IDGS bvba"),
  M_DAKANIMO((int) 269, (int) 322, (String) "dakanimo"),
  M_TREBOR_AUTOMATION_AB((int) 270, (int) 323, (String) "Trebor Automation AB"),
  M_SATEL_SP__Z_O_O_((int) 271, (int) 324, (String) "Satel sp. z o.o."),
  M_RUSSOUND__INC_((int) 272, (int) 325, (String) "Russound, Inc."),
  M_MIDEA_HEATING_AND_VENTILATING_EQUIPMENT_CO_LTD(
      (int) 273, (int) 326, (String) "Midea Heating & Ventilating Equipment CO LTD"),
  M_CONSORZIO_TERRANUOVA((int) 274, (int) 327, (String) "Consorzio Terranuova"),
  M_WOLF_HEIZTECHNIK_GMBH((int) 275, (int) 328, (String) "Wolf Heiztechnik GmbH"),
  M_SONTEC((int) 276, (int) 329, (String) "SONTEC"),
  M_BELCOM_CABLES_LTD_((int) 277, (int) 330, (String) "Belcom Cables Ltd."),
  M_GUANGZHOU_SEAWIN_ELECTRICAL_TECHNOLOGIES_CO___LTD_(
      (int) 278, (int) 331, (String) "Guangzhou SeaWin Electrical Technologies Co., Ltd."),
  M_ACREL((int) 279, (int) 332, (String) "Acrel"),
  M_FRANKE_AQUAROTTER_GMBH((int) 280, (int) 333, (String) "Franke Aquarotter GmbH"),
  M_ORION_SYSTEMS((int) 281, (int) 334, (String) "Orion Systems"),
  M_SCHRACK_TECHNIK_GMBH((int) 282, (int) 335, (String) "Schrack Technik GmbH"),
  M_INSPRID((int) 283, (int) 336, (String) "INSPRID"),
  M_SUNRICHER((int) 284, (int) 337, (String) "Sunricher"),
  M_MENRED_AUTOMATION_SYSTEMSHANGHAI_CO__LTD_(
      (int) 285, (int) 338, (String) "Menred automation system(shanghai) Co.,Ltd."),
  M_AUREX((int) 286, (int) 339, (String) "Aurex"),
  M_JOSEF_BARTHELME_GMBH_AND_CO__KG((int) 287, (int) 340, (String) "Josef Barthelme GmbH & Co. KG"),
  M_ARCHITECTURE_NUMERIQUE((int) 288, (int) 341, (String) "Architecture Numerique"),
  M_UP_GROUP((int) 289, (int) 342, (String) "UP GROUP"),
  M_TEKNOS_AVINNO((int) 290, (int) 343, (String) "Teknos-Avinno"),
  M_NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY(
      (int) 291, (int) 344, (String) "Ningbo Dooya Mechanic & Electronic Technology"),
  M_THERMOKON_SENSORTECHNIK_GMBH((int) 292, (int) 345, (String) "Thermokon Sensortechnik GmbH"),
  M_BELIMO_AUTOMATION_AG((int) 293, (int) 346, (String) "BELIMO Automation AG"),
  M_ZEHNDER_GROUP_INTERNATIONAL_AG((int) 294, (int) 347, (String) "Zehnder Group International AG"),
  M_SKS_KINKEL_ELEKTRONIK((int) 295, (int) 348, (String) "sks Kinkel Elektronik"),
  M_ECE_WURMITZER_GMBH((int) 296, (int) 349, (String) "ECE Wurmitzer GmbH"),
  M_LARS((int) 297, (int) 350, (String) "LARS"),
  M_URC((int) 298, (int) 351, (String) "URC"),
  M_LIGHTCONTROL((int) 299, (int) 352, (String) "LightControl"),
  M_SHENZHEN_YM((int) 300, (int) 353, (String) "ShenZhen YM"),
  M_MEAN_WELL_ENTERPRISES_CO__LTD_((int) 301, (int) 354, (String) "MEAN WELL Enterprises Co. Ltd."),
  M_OSIX((int) 302, (int) 355, (String) "OSix"),
  M_AYPRO_TECHNOLOGY((int) 303, (int) 356, (String) "AYPRO Technology"),
  M_HEFEI_ECOLITE_SOFTWARE((int) 304, (int) 357, (String) "Hefei Ecolite Software"),
  M_ENNO((int) 305, (int) 358, (String) "Enno"),
  M_OHOSURE((int) 306, (int) 359, (String) "OHOSURE"),
  M_GAREFOWL((int) 307, (int) 360, (String) "Garefowl"),
  M_GEZE((int) 308, (int) 361, (String) "GEZE"),
  M_LG_ELECTRONICS_INC_((int) 309, (int) 362, (String) "LG Electronics Inc."),
  M_SMC_INTERIORS((int) 310, (int) 363, (String) "SMC interiors"),
  M_NOT_ASSIGNED_364((int) 311, (int) 364, (String) "Not Assigned"),
  M_SCS_CABLE((int) 312, (int) 365, (String) "SCS Cable"),
  M_HOVAL((int) 313, (int) 366, (String) "Hoval"),
  M_CANST((int) 314, (int) 367, (String) "CANST"),
  M_HANGZHOU_BERLIN((int) 315, (int) 368, (String) "HangZhou Berlin"),
  M_EVN_LICHTTECHNIK((int) 316, (int) 369, (String) "EVN-Lichttechnik"),
  M_RUTEC((int) 317, (int) 370, (String) "rutec"),
  M_FINDER((int) 318, (int) 371, (String) "Finder"),
  M_FUJITSU_GENERAL_LIMITED((int) 319, (int) 372, (String) "Fujitsu General Limited"),
  M_ZF_FRIEDRICHSHAFEN_AG((int) 320, (int) 373, (String) "ZF Friedrichshafen AG"),
  M_CREALED((int) 321, (int) 374, (String) "Crealed"),
  M_MILES_MAGIC_AUTOMATION_PRIVATE_LIMITED(
      (int) 322, (int) 375, (String) "Miles Magic Automation Private Limited"),
  M_EPlus((int) 323, (int) 376, (String) "E+"),
  M_ITALCOND((int) 324, (int) 377, (String) "Italcond"),
  M_SATION((int) 325, (int) 378, (String) "SATION"),
  M_NEWBEST((int) 326, (int) 379, (String) "NewBest"),
  M_GDS_DIGITAL_SYSTEMS((int) 327, (int) 380, (String) "GDS DIGITAL SYSTEMS"),
  M_IDDERO((int) 328, (int) 381, (String) "Iddero"),
  M_MBNLED((int) 329, (int) 382, (String) "MBNLED"),
  M_VITRUM((int) 330, (int) 383, (String) "VITRUM"),
  M_EKEY_BIOMETRIC_SYSTEMS_GMBH((int) 331, (int) 384, (String) "ekey biometric systems GmbH"),
  M_AMC((int) 332, (int) 385, (String) "AMC"),
  M_TRILUX_GMBH_AND_CO__KG((int) 333, (int) 386, (String) "TRILUX GmbH & Co. KG"),
  M_WEXCEDO((int) 334, (int) 387, (String) "WExcedo"),
  M_VEMER_SPA((int) 335, (int) 388, (String) "VEMER SPA"),
  M_ALEXANDER_BUERKLE_GMBH_AND_CO_KG(
      (int) 336, (int) 389, (String) "Alexander Bürkle GmbH & Co KG"),
  M_CITRON((int) 337, (int) 390, (String) "Citron"),
  M_SHENZHEN_HEGUANG((int) 338, (int) 391, (String) "Shenzhen HeGuang"),
  M_NOT_ASSIGNED_392((int) 339, (int) 392, (String) "Not Assigned"),
  M_TRANE_B_V_B_A((int) 340, (int) 393, (String) "TRANE B.V.B.A"),
  M_CAREL((int) 341, (int) 394, (String) "CAREL"),
  M_PROLITE_CONTROLS((int) 342, (int) 395, (String) "Prolite Controls"),
  M_BOSMER((int) 343, (int) 396, (String) "BOSMER"),
  M_EUCHIPS((int) 344, (int) 397, (String) "EUCHIPS"),
  M_CONNECT_THINKA_CONNECT((int) 345, (int) 398, (String) "connect (Thinka connect)"),
  M_PEAKNX_A_DOGAWIST_COMPANY((int) 346, (int) 399, (String) "PEAKnx a DOGAWIST company"),
  M_ACEMATIC((int) 347, (int) 400, (String) "ACEMATIC"),
  M_ELAUSYS((int) 348, (int) 401, (String) "ELAUSYS"),
  M_ITK_ENGINEERING_AG((int) 349, (int) 402, (String) "ITK Engineering AG"),
  M_INTEGRA_METERING_AG((int) 350, (int) 403, (String) "INTEGRA METERING AG"),
  M_FMS_HOSPITALITY_PTE_LTD((int) 351, (int) 404, (String) "FMS Hospitality Pte Ltd"),
  M_NUVO((int) 352, (int) 405, (String) "Nuvo"),
  M_U__LUX_GMBH((int) 353, (int) 406, (String) "u::Lux GmbH"),
  M_BRUMBERG_LEUCHTEN((int) 354, (int) 407, (String) "Brumberg Leuchten"),
  M_LIME((int) 355, (int) 408, (String) "Lime"),
  M_GREAT_EMPIRE_INTERNATIONAL_GROUP_CO___LTD_(
      (int) 356, (int) 409, (String) "Great Empire International Group Co., Ltd."),
  M_KAVOSHPISHRO_ASIA((int) 357, (int) 410, (String) "Kavoshpishro Asia"),
  M_V2_SPA((int) 358, (int) 411, (String) "V2 SpA"),
  M_JOHNSON_CONTROLS((int) 359, (int) 412, (String) "Johnson Controls"),
  M_ARKUD((int) 360, (int) 413, (String) "Arkud"),
  M_IRIDIUM_LTD_((int) 361, (int) 414, (String) "Iridium Ltd."),
  M_BSMART((int) 362, (int) 415, (String) "bsmart"),
  M_BAB_TECHNOLOGIE_GMBH((int) 363, (int) 416, (String) "BAB TECHNOLOGIE GmbH"),
  M_NICE_SPA((int) 364, (int) 417, (String) "NICE Spa"),
  M_REDFISH_GROUP_PTY_LTD((int) 365, (int) 418, (String) "Redfish Group Pty Ltd"),
  M_SABIANA_SPA((int) 366, (int) 419, (String) "SABIANA spa"),
  M_UBEE_INTERACTIVE_EUROPE((int) 367, (int) 420, (String) "Ubee Interactive Europe"),
  M_REXEL((int) 368, (int) 421, (String) "Rexel"),
  M_GES_TEKNIK_A_S_((int) 369, (int) 422, (String) "Ges Teknik A.S."),
  M_AVE_S_P_A_((int) 370, (int) 423, (String) "Ave S.p.A."),
  M_ZHUHAI_LTECH_TECHNOLOGY_CO___LTD_(
      (int) 371, (int) 424, (String) "Zhuhai Ltech Technology Co., Ltd."),
  M_ARCOM((int) 372, (int) 425, (String) "ARCOM"),
  M_VIA_TECHNOLOGIES__INC_((int) 373, (int) 426, (String) "VIA Technologies, Inc."),
  M_FEELSMART_((int) 374, (int) 427, (String) "FEELSMART."),
  M_SUPCON((int) 375, (int) 428, (String) "SUPCON"),
  M_MANIC((int) 376, (int) 429, (String) "MANIC"),
  M_TDE_GMBH((int) 377, (int) 430, (String) "TDE GmbH"),
  M_NANJING_SHUFAN_INFORMATION_TECHNOLOGY_CO__LTD_(
      (int) 378, (int) 431, (String) "Nanjing Shufan Information technology Co.,Ltd."),
  M_EWTECH((int) 379, (int) 432, (String) "EWTech"),
  M_KLUGER_AUTOMATION_GMBH((int) 380, (int) 433, (String) "Kluger Automation GmbH"),
  M_JOONGANG_CONTROL((int) 381, (int) 434, (String) "JoongAng Control"),
  M_GREENCONTROLS_TECHNOLOGY_SDN__BHD_(
      (int) 382, (int) 435, (String) "GreenControls Technology Sdn. Bhd."),
  M_IME_S_P_A_((int) 383, (int) 436, (String) "IME S.p.a."),
  M_SICHUAN_HAODING((int) 384, (int) 437, (String) "SiChuan HaoDing"),
  M_MINDJAGA_LTD_((int) 385, (int) 438, (String) "Mindjaga Ltd."),
  M_RUILI_SMART_CONTROL((int) 386, (int) 439, (String) "RuiLi Smart Control"),
  M_CODESYS_GMBH((int) 387, (int) 440, (String) "CODESYS GmbH"),
  M_MOORGEN_DEUTSCHLAND_GMBH((int) 388, (int) 441, (String) "Moorgen Deutschland GmbH"),
  M_CULLMANN_TECH((int) 389, (int) 442, (String) "CULLMANN TECH"),
  M_MERCK_WINDOW_TECHNOLOGIES_B_V_((int) 390, (int) 443, (String) "Merck Window Technologies B.V."),
  M_ABEGO((int) 391, (int) 444, (String) "ABEGO"),
  M_MYGEKKO((int) 392, (int) 445, (String) "myGEKKO"),
  M_ERGO3_SARL((int) 393, (int) 446, (String) "Ergo3 Sarl"),
  M_STMICROELECTRONICS_INTERNATIONAL_N_V_(
      (int) 394, (int) 447, (String) "STmicroelectronics International N.V."),
  M_CJC_SYSTEMS((int) 395, (int) 448, (String) "cjc systems"),
  M_SUDOKU((int) 396, (int) 449, (String) "Sudoku"),
  M_AZ_E_LITE_PTE_LTD((int) 397, (int) 451, (String) "AZ e-lite Pte Ltd"),
  M_ARLIGHT((int) 398, (int) 452, (String) "Arlight"),
  M_GRUENBECK_WASSERAUFBEREITUNG_GMBH(
      (int) 399, (int) 453, (String) "Grünbeck Wasseraufbereitung GmbH"),
  M_MODULE_ELECTRONIC((int) 400, (int) 454, (String) "Module Electronic"),
  M_KOPLAT((int) 401, (int) 455, (String) "KOPLAT"),
  M_GUANGZHOU_LETOUR_LIFE_TECHNOLOGY_CO___LTD(
      (int) 402, (int) 456, (String) "Guangzhou Letour Life Technology Co., Ltd"),
  M_ILEVIA((int) 403, (int) 457, (String) "ILEVIA"),
  M_LN_SYSTEMTEQ((int) 404, (int) 458, (String) "LN SYSTEMTEQ"),
  M_HISENSE_SMARTHOME((int) 405, (int) 459, (String) "Hisense SmartHome"),
  M_FLINK_AUTOMATION_SYSTEM((int) 406, (int) 460, (String) "Flink Automation System"),
  M_XXTER_BV((int) 407, (int) 461, (String) "xxter bv"),
  M_LYNXUS_TECHNOLOGY((int) 408, (int) 462, (String) "lynxus technology"),
  M_ROBOT_S_A_((int) 409, (int) 463, (String) "ROBOT S.A."),
  M_SHENZHEN_ATTE_SMART_LIFE_CO__LTD_(
      (int) 410, (int) 464, (String) "Shenzhen Atte Smart Life Co.,Ltd."),
  M_NOBLESSE((int) 411, (int) 465, (String) "Noblesse"),
  M_ADVANCED_DEVICES((int) 412, (int) 466, (String) "Advanced Devices"),
  M_ATRINA_BUILDING_AUTOMATION_CO__LTD(
      (int) 413, (int) 467, (String) "Atrina Building Automation Co. Ltd"),
  M_GUANGDONG_DAMING_LAFFEY_ELECTRIC_CO___LTD_(
      (int) 414, (int) 468, (String) "Guangdong Daming Laffey electric Co., Ltd."),
  M_WESTERSTRAND_URFABRIK_AB((int) 415, (int) 469, (String) "Westerstrand Urfabrik AB"),
  M_CONTROL4_CORPORATE((int) 416, (int) 470, (String) "Control4 Corporate"),
  M_ONTROL((int) 417, (int) 471, (String) "Ontrol"),
  M_STARNET((int) 418, (int) 472, (String) "Starnet"),
  M_BETA_CAVI((int) 419, (int) 473, (String) "BETA CAVI"),
  M_EASEMORE((int) 420, (int) 474, (String) "EaseMore"),
  M_VIVALDI_SRL((int) 421, (int) 475, (String) "Vivaldi srl"),
  M_GREE_ELECTRIC_APPLIANCES_INC__OF_ZHUHAI(
      (int) 422, (int) 476, (String) "Gree Electric Appliances,Inc. of Zhuhai"),
  M_HWISCON((int) 423, (int) 477, (String) "HWISCON"),
  M_SHANGHAI_ELECON_INTELLIGENT_TECHNOLOGY_CO___LTD_(
      (int) 424, (int) 478, (String) "Shanghai ELECON Intelligent Technology Co., Ltd."),
  M_KAMPMANN((int) 425, (int) 479, (String) "Kampmann"),
  M_IMPOLUX_GMBH_LEDIMAX((int) 426, (int) 480, (String) "Impolux GmbH / LEDIMAX"),
  M_EVAUX((int) 427, (int) 481, (String) "Evaux"),
  M_WEBRO_CABLES_AND_CONNECTORS_LIMITED(
      (int) 428, (int) 482, (String) "Webro Cables & Connectors Limited"),
  M_SHANGHAI_E_TECH_SOLUTION((int) 429, (int) 483, (String) "Shanghai E-tech Solution"),
  M_GUANGZHOU_HOKO_ELECTRIC_CO__LTD_(
      (int) 430, (int) 484, (String) "Guangzhou HOKO Electric Co.,Ltd."),
  M_LAMMIN_HIGH_TECH_CO__LTD((int) 431, (int) 485, (String) "LAMMIN HIGH TECH CO.,LTD"),
  M_SHENZHEN_MERRYTEK_TECHNOLOGY_CO___LTD(
      (int) 432, (int) 486, (String) "Shenzhen Merrytek Technology Co., Ltd"),
  M_I_LUXUS((int) 433, (int) 487, (String) "I-Luxus"),
  M_ELMOS_SEMICONDUCTOR_AG((int) 434, (int) 488, (String) "Elmos Semiconductor AG"),
  M_EMCOM_TECHNOLOGY_INC((int) 435, (int) 489, (String) "EmCom Technology Inc"),
  M_PROJECT_INNOVATIONS_GMBH((int) 436, (int) 490, (String) "project innovations GmbH"),
  M_ITC((int) 437, (int) 491, (String) "Itc"),
  M_ABB_LV_INSTALLATION_MATERIALS_COMPANY_LTD__BEIJING(
      (int) 438, (int) 492, (String) "ABB LV Installation Materials Company Ltd, Beijing"),
  M_MAICO((int) 439, (int) 493, (String) "Maico"),
  M_ELAN_SRL((int) 440, (int) 495, (String) "ELAN SRL"),
  M_MINHHA_TECHNOLOGY_CO__LTD((int) 441, (int) 496, (String) "MinhHa Technology co.,Ltd"),
  M_ZHEJIANG_TIANJIE_INDUSTRIAL_CORP_(
      (int) 442, (int) 497, (String) "Zhejiang Tianjie Industrial CORP."),
  M_IAUTOMATION_PTY_LIMITED((int) 443, (int) 498, (String) "iAutomation Pty Limited"),
  M_EXTRON((int) 444, (int) 499, (String) "Extron"),
  M_FREEDOMPRO((int) 445, (int) 500, (String) "Freedompro"),
  M_ONEHOME((int) 446, (int) 501, (String) "1Home"),
  M_EOS_SAUNATECHNIK_GMBH((int) 447, (int) 502, (String) "EOS Saunatechnik GmbH"),
  M_KUSATEK_GMBH((int) 448, (int) 503, (String) "KUSATEK GmbH"),
  M_EISBAER_SCADA((int) 449, (int) 504, (String) "EisBär Scada"),
  M_AUTOMATISMI_BENINCA_S_P_A_((int) 450, (int) 505, (String) "AUTOMATISMI BENINCA S.P.A."),
  M_BLENDOM((int) 451, (int) 506, (String) "Blendom"),
  M_MADEL_AIR_TECHNICAL_DIFFUSION((int) 452, (int) 507, (String) "Madel Air Technical diffusion"),
  M_NIKO((int) 453, (int) 508, (String) "NIKO"),
  M_BOSCH_REXROTH_AG((int) 454, (int) 509, (String) "Bosch Rexroth AG"),
  M_CANDM_PRODUCTS((int) 455, (int) 512, (String) "C&M Products"),
  M_HOERMANN_KG_VERKAUFSGESELLSCHAFT(
      (int) 456, (int) 513, (String) "Hörmann KG Verkaufsgesellschaft"),
  M_SHANGHAI_RAJAYASA_CO__LTD((int) 457, (int) 514, (String) "Shanghai Rajayasa co.,LTD"),
  M_SUZUKI((int) 458, (int) 515, (String) "SUZUKI"),
  M_SILENT_GLISS_INTERNATIONAL_LTD_(
      (int) 459, (int) 516, (String) "Silent Gliss International Ltd."),
  M_BEE_CONTROLS_ADGSC_GROUP((int) 460, (int) 517, (String) "BEE Controls (ADGSC Group)"),
  M_XDTECGMBH((int) 461, (int) 518, (String) "xDTecGmbH"),
  M_OSRAM((int) 462, (int) 519, (String) "OSRAM"),
  M_LEBENOR((int) 463, (int) 520, (String) "Lebenor"),
  M_AUTOMANENG((int) 464, (int) 521, (String) "automaneng"),
  M_HONEYWELL_AUTOMATION_SOLUTION_CONTROLCHINA(
      (int) 465, (int) 522, (String) "Honeywell Automation Solution control(China)"),
  M_HANGZHOU_BINTHEN_INTELLIGENCE_TECHNOLOGY_CO__LTD(
      (int) 466, (int) 523, (String) "Hangzhou binthen Intelligence Technology Co.,Ltd"),
  M_ETA_HEIZTECHNIK((int) 467, (int) 524, (String) "ETA Heiztechnik"),
  M_DIVUS_GMBH((int) 468, (int) 525, (String) "DIVUS GmbH"),
  M_NANJING_TAIJIESAI_INTELLIGENT_TECHNOLOGY_CO__LTD_(
      (int) 469, (int) 526, (String) "Nanjing Taijiesai Intelligent Technology Co. Ltd."),
  M_LUNATONE((int) 470, (int) 527, (String) "Lunatone"),
  M_ZHEJIANG_SCTECH_BUILDING_INTELLIGENT(
      (int) 471, (int) 528, (String) "ZHEJIANG SCTECH BUILDING INTELLIGENT"),
  M_FOSHAN_QITE_TECHNOLOGY_CO___LTD_(
      (int) 472, (int) 529, (String) "Foshan Qite Technology Co., Ltd."),
  M_NOKE((int) 473, (int) 530, (String) "NOKE"),
  M_LANDCOM((int) 474, (int) 531, (String) "LANDCOM"),
  M_STORK_AS((int) 475, (int) 532, (String) "Stork AS"),
  M_HANGZHOU_SHENDU_TECHNOLOGY_CO___LTD_(
      (int) 476, (int) 533, (String) "Hangzhou Shendu Technology Co., Ltd."),
  M_COOLAUTOMATION((int) 477, (int) 534, (String) "CoolAutomation"),
  M_APRSTERN((int) 478, (int) 535, (String) "Aprstern"),
  M_SONNEN((int) 479, (int) 536, (String) "sonnen"),
  M_DNAKE((int) 480, (int) 537, (String) "DNAKE"),
  M_NEUBERGER_GEBAEUDEAUTOMATION_GMBH(
      (int) 481, (int) 538, (String) "Neuberger Gebäudeautomation GmbH"),
  M_STILIGER((int) 482, (int) 539, (String) "Stiliger"),
  M_BERGHOF_AUTOMATION_GMBH((int) 483, (int) 540, (String) "Berghof Automation GmbH"),
  M_TOTAL_AUTOMATION_AND_CONTROLS_GMBH(
      (int) 484, (int) 541, (String) "Total Automation and controls GmbH"),
  M_DOVIT((int) 485, (int) 542, (String) "dovit"),
  M_INSTALIGHTING_GMBH((int) 486, (int) 543, (String) "Instalighting GmbH"),
  M_UNI_TEC((int) 487, (int) 544, (String) "UNI-TEC"),
  M_CASATUNES((int) 488, (int) 545, (String) "CasaTunes"),
  M_EMT((int) 489, (int) 546, (String) "EMT"),
  M_SENFFICIENT((int) 490, (int) 547, (String) "Senfficient"),
  M_AUROLITE_ELECTRICAL_PANYU_GUANGZHOU_LIMITED(
      (int) 491, (int) 548, (String) "Aurolite electrical panyu guangzhou limited"),
  M_ABB_XIAMEN_SMART_TECHNOLOGY_CO___LTD_(
      (int) 492, (int) 549, (String) "ABB Xiamen Smart Technology Co., Ltd."),
  M_SAMSON_ELECTRIC_WIRE((int) 493, (int) 550, (String) "Samson Electric Wire"),
  M_T_TOUCHING((int) 494, (int) 551, (String) "T-Touching"),
  M_CORE_SMART_HOME((int) 495, (int) 552, (String) "Core Smart Home"),
  M_GREENCONNECT_SOLUTIONS_SA((int) 496, (int) 553, (String) "GreenConnect Solutions SA"),
  M_ELETTRONICA_CONDUTTORI((int) 497, (int) 554, (String) "ELETTRONICA CONDUTTORI"),
  M_MKFC((int) 498, (int) 555, (String) "MKFC"),
  M_AUTOMATIONPlus((int) 499, (int) 556, (String) "Automation+"),
  M_BLUE_AND_RED((int) 500, (int) 557, (String) "blue and red"),
  M_FROGBLUE((int) 501, (int) 558, (String) "frogblue"),
  M_SAVESOR((int) 502, (int) 559, (String) "SAVESOR"),
  M_APP_TECH((int) 503, (int) 560, (String) "App Tech"),
  M_SENSORTEC_AG((int) 504, (int) 561, (String) "sensortec AG"),
  M_NYSA_TECHNOLOGY_AND_SOLUTIONS((int) 505, (int) 562, (String) "nysa technology & solutions"),
  M_FARADITE((int) 506, (int) 563, (String) "FARADITE"),
  M_OPTIMUS((int) 507, (int) 564, (String) "Optimus"),
  M_KTS_S_R_L_((int) 508, (int) 565, (String) "KTS s.r.l."),
  M_RAMCRO_SPA((int) 509, (int) 566, (String) "Ramcro SPA"),
  M_WUHAN_WISECREATE_UNIVERSE_TECHNOLOGY_CO___LTD(
      (int) 510, (int) 567, (String) "Wuhan WiseCreate Universe Technology Co., Ltd"),
  M_BEMI_SMART_HOME_LTD((int) 511, (int) 568, (String) "BEMI Smart Home Ltd"),
  M_ARDOMUS((int) 512, (int) 569, (String) "Ardomus"),
  M_CHANGXING((int) 513, (int) 570, (String) "ChangXing"),
  M_E_CONTROLS((int) 514, (int) 571, (String) "E-Controls"),
  M_AIB_TECHNOLOGY((int) 515, (int) 572, (String) "AIB Technology"),
  M_NVC((int) 516, (int) 573, (String) "NVC"),
  M_KBOX((int) 517, (int) 574, (String) "Kbox"),
  M_CNS((int) 518, (int) 575, (String) "CNS"),
  M_TYBA((int) 519, (int) 576, (String) "Tyba"),
  M_ATREL((int) 520, (int) 577, (String) "Atrel"),
  M_SIMON_ELECTRIC_CHINA_CO___LTD((int) 521, (int) 578, (String) "Simon Electric (China) Co., LTD"),
  M_KORDZ_GROUP((int) 522, (int) 579, (String) "Kordz Group"),
  M_ND_ELECTRIC((int) 523, (int) 580, (String) "ND Electric"),
  M_CONTROLIUM((int) 524, (int) 581, (String) "Controlium"),
  M_FAMO_GMBH_AND_CO__KG((int) 525, (int) 582, (String) "FAMO GmbH & Co. KG"),
  M_CDN_SMART((int) 526, (int) 583, (String) "CDN Smart"),
  M_HESTON((int) 527, (int) 584, (String) "Heston"),
  M_ESLA_CONEXIONES_S_L_((int) 528, (int) 585, (String) "ESLA CONEXIONES S.L."),
  M_WEISHAUPT((int) 529, (int) 586, (String) "Weishaupt"),
  M_ASTRUM_TECHNOLOGY((int) 530, (int) 587, (String) "ASTRUM TECHNOLOGY"),
  M_WUERTH_ELEKTRONIK_STELVIO_KONTEK_S_P_A_(
      (int) 531, (int) 588, (String) "WUERTH ELEKTRONIK STELVIO KONTEK S.p.A."),
  M_NANOTECO_CORPORATION((int) 532, (int) 589, (String) "NANOTECO corporation"),
  M_NIETIAN((int) 533, (int) 590, (String) "Nietian"),
  M_SUMSIR((int) 534, (int) 591, (String) "Sumsir"),
  M_ORBIS_TECNOLOGIA_ELECTRICA_SA((int) 535, (int) 592, (String) "ORBIS TECNOLOGIA ELECTRICA SA"),
  M_NANJING_ZHONGYI_IOT_TECHNOLOGY_CO___LTD_(
      (int) 536, (int) 593, (String) "Nanjing Zhongyi IoT Technology Co., Ltd."),
  M_ANLIPS((int) 537, (int) 594, (String) "Anlips"),
  M_GUANGDONG_PAK_CORPORATION_CO___LTD(
      (int) 538, (int) 595, (String) "GUANGDONG PAK CORPORATION CO., LTD"),
  M_BVK_TECHNOLOGY((int) 539, (int) 596, (String) "BVK Technology"),
  M_SOLOMIO_SRL((int) 540, (int) 597, (String) "Solomio srl"),
  M_DOMOTICA_LABS((int) 541, (int) 598, (String) "Domotica Labs"),
  M_NVC_INTERNATIONAL((int) 542, (int) 599, (String) "NVC International"),
  M_BA((int) 543, (int) 600, (String) "BA"),
  M_IRIS_CERAMICA_GROUP((int) 544, (int) 601, (String) "Iris Ceramica Group"),
  M_WIREEO((int) 545, (int) 602, (String) "Wireeo"),
  M_NVCLIGHTING((int) 546, (int) 603, (String) "nvclighting"),
  M_JINAN_TIAN_DA_SHENG_INFORMATION_TECHNOLOGY_CO_(
      (int) 547, (int) 604, (String) "Jinan Tian Da Sheng Information Technology Co."),
  M_ARMITI_TRADING((int) 548, (int) 605, (String) "Armiti trading"),
  M_ELEK((int) 549, (int) 606, (String) "ELEK"),
  M_ACCORDIA_SA((int) 550, (int) 607, (String) "Accordia sa"),
  M_OURICAN((int) 551, (int) 608, (String) "OURICAN"),
  M_INLIWOSE((int) 552, (int) 609, (String) "INLIWOSE"),
  M_BOSCH_SHANGHAI_SMART_LIFE_TECHNOLOGY_LTD_(
      (int) 553, (int) 610, (String) "Bosch (Shanghai) Smart Life Technology Ltd."),
  M_SHK_KNX((int) 554, (int) 611, (String) "SHK KNX"),
  M_AMPIO((int) 555, (int) 612, (String) "Ampio"),
  M_MINGXING_WISDOM((int) 556, (int) 613, (String) "Mingxing Wisdom"),
  M_ALTEN_SW_GMBH((int) 557, (int) 614, (String) "ALTEN SW GmbH"),
  M_V_Y_C_SRL((int) 558, (int) 615, (String) "V.Y.C.srl"),
  M_TERMINUS_GROUP((int) 559, (int) 616, (String) "TERMINUS GROUP"),
  M_WONDERFUL_CITY_TECHNOLOGY((int) 560, (int) 617, (String) "Wonderful City Technology"),
  M_QBICTECHNOLOGY((int) 561, (int) 618, (String) "QbicTechnology"),
  M_EMBEDDED_AUTOMATION_EQUIPMENT_SHANGHAI_LIMITED(
      (int) 562, (int) 619, (String) "Embedded Automation Equipment (Shanghai) Limited"),
  M_ONEWORK((int) 563, (int) 620, (String) "onework"),
  M_PL_LINK((int) 564, (int) 621, (String) "PL LINK"),
  M_FASEL_GMBH_ELEKTRONIK((int) 565, (int) 622, (String) "Fasel GmbH Elektronik"),
  M_GOLDENHOME_SMART((int) 566, (int) 623, (String) "GoldenHome Smart"),
  M_GOLDMEDAL((int) 567, (int) 624, (String) "Goldmedal"),
  M_CannX((int) 568, (int) 625, (String) "Can'nX"),
  M_EGI___EARTH_GOODNESS((int) 569, (int) 627, (String) "EGI - Earth Goodness"),
  M_VIEGA_GMBH_AND_CO__KG((int) 570, (int) 628, (String) "Viega GmbH & Co. KG"),
  M_FREDON_DIGITAL_BUILDINGS((int) 571, (int) 629, (String) "Fredon Digital Buildings"),
  M_HELUKABEL_THAILAND_CO__LTD_((int) 572, (int) 630, (String) "Helukabel (Thailand) Co.,Ltd."),
  M_ACE_TECHNOLOGY((int) 573, (int) 631, (String) "ACE Technology"),
  M_MEX_ELECTRIC_TECHNOLOGY_SHANGHAI_CO___LTD(
      (int) 574, (int) 632, (String) "MEX Electric Technology (Shanghai) Co., Ltd"),
  M_SUMAMO((int) 575, (int) 633, (String) "SUMAMO"),
  M_SVIT((int) 576, (int) 634, (String) "SVIT"),
  M_TECGET((int) 577, (int) 635, (String) "tecget"),
  M_XEROPOINT((int) 578, (int) 636, (String) "Xeropoint"),
  M_HONEYWELL_BUILDING_TECHNOLOGIES(
      (int) 579, (int) 637, (String) "Honeywell Building Technologies"),
  M_COMFORTCLICK((int) 580, (int) 638, (String) "ComfortClick"),
  M_DORBAS_ELECTRIC((int) 581, (int) 639, (String) "DORBAS ELECTRIC"),
  M_REMKO_GMBH_AND_CO__KG((int) 582, (int) 640, (String) "REMKO GmbH & Co. KG"),
  M_SHENZHEN_CONGXUN_INTELLIGENT_TECHNOLOGY_CO___LTD(
      (int) 583, (int) 641, (String) "Shenzhen Congxun Intelligent Technology Co., LTD"),
  M_ANDAS((int) 584, (int) 642, (String) "ANDAS"),
  M_HEFEI_CHUANG_YUE_INTELLIGENT_TECHNOLOGY_CO__LTD(
      (int) 585, (int) 643, (String) "Hefei Chuang Yue Intelligent Technology Co.,LTD"),
  M_LARFE((int) 586, (int) 644, (String) "Larfe"),
  M_DONGGUAN_MUHCCI_ELECTRICAL((int) 587, (int) 645, (String) "Dongguan Muhcci Electrical"),
  M_STEC((int) 588, (int) 646, (String) "STEC"),
  M_ARIGO_SOFTWARE_GMBH((int) 589, (int) 647, (String) "ARIGO Software GmbH"),
  M_FEISHELEC((int) 590, (int) 648, (String) "Feishelec"),
  M_GORDIC((int) 591, (int) 649, (String) "GORDIC"),
  M_DELTA_ELECTRONICS((int) 592, (int) 650, (String) "Delta Electronics"),
  M_SHANGHAI_LEWIN_INTELLIGENT_TECHNOLOGY_CO__LTD_(
      (int) 593, (int) 651, (String) "Shanghai Lewin Intelligent Technology Co.,Ltd."),
  M_KG_POWER((int) 594, (int) 652, (String) "KG-POWER"),
  M_ZHEJIANG_MOORGEN_INTELLIGENT_TECHNOLOGY_CO___LTD(
      (int) 595, (int) 653, (String) "Zhejiang Moorgen Intelligent Technology Co., Ltd"),
  M_GUANGDONG_KANWAY((int) 596, (int) 654, (String) "Guangdong Kanway"),
  M_PHOENIX_CONTACT_2((int) 597, (int) 655, (String) "Phoenix Contact"),
  M_RAMIREZ_ENGINEERING_GMBH((int) 598, (int) 656, (String) "RAMIREZ Engineering GmbH"),
  M_ZHONGSHAN_TAIYANG_IMPANDEXP__CO_LTD(
      (int) 599, (int) 657, (String) "Zhongshan Taiyang IMP&EXP. CO LTD"),
  M_ABB___RESERVED((int) 600, (int) 43954, (String) "ABB - reserved"),
  M_BUSCH_JAEGER_ELEKTRO___RESERVED(
      (int) 601, (int) 43959, (String) "Busch-Jaeger Elektro - reserved");
  private static final Map<Integer, KnxManufacturer> map;

  static {
    map = new HashMap<>();
    for (KnxManufacturer value : KnxManufacturer.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private int value;
  private int number;
  private String name;

  KnxManufacturer(int value, int number, String name) {
    this.value = value;
    this.number = number;
    this.name = name;
  }

  public int getValue() {
    return value;
  }

  public int getNumber() {
    return number;
  }

  public static KnxManufacturer firstEnumForFieldNumber(int fieldValue) {
    for (KnxManufacturer _val : KnxManufacturer.values()) {
      if (_val.getNumber() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxManufacturer> enumsForFieldNumber(int fieldValue) {
    List<KnxManufacturer> _values = new ArrayList();
    for (KnxManufacturer _val : KnxManufacturer.values()) {
      if (_val.getNumber() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getName() {
    return name;
  }

  public static KnxManufacturer firstEnumForFieldName(String fieldValue) {
    for (KnxManufacturer _val : KnxManufacturer.values()) {
      if (_val.getName() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxManufacturer> enumsForFieldName(String fieldValue) {
    List<KnxManufacturer> _values = new ArrayList();
    for (KnxManufacturer _val : KnxManufacturer.values()) {
      if (_val.getName() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static KnxManufacturer enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
