/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

// Code generated by code-generation. DO NOT EDIT.

public class KnxProperty {

  private static final Logger LOGGER = LoggerFactory.getLogger(KnxProperty.class);

  public static PlcValue staticParse(
      ReadBuffer readBuffer, KnxPropertyDataType propertyType, Short dataLengthInBytes)
      throws ParseException {
    if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_CONTROL)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_CHAR)) { // SINT

      // Simple Field (value)
      Byte value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readSignedByte("", 8);

      return new PlcSINT(value);
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_UNSIGNED_CHAR)) { // USINT

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_INT)) { // INT

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_UNSIGNED_INT)
        && EvaluationHelper.equals(dataLengthInBytes, 4)) { // UDINT

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_UNSIGNED_INT)) { // UINT

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_KNX_FLOAT)) { // REAL

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_DATE)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 3);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (dayOfMonth)
      Short dayOfMonth = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (month)
      Byte month = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 1);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (year)
      Short year = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 7);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("dayOfMonth", new PlcINT(dayOfMonth));
      _map.put("month", new PlcSINT(month));
      _map.put("year", new PlcINT(year));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_TIME)) { // Struct

      // Simple Field (day)
      Byte day = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 3);

      // Simple Field (hour)
      Short hour = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 5);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (minutes)
      Short minutes = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 6);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (seconds)
      Short seconds = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 6);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("day", new PlcSINT(day));
      _map.put("hour", new PlcINT(hour));
      _map.put("minutes", new PlcINT(minutes));
      _map.put("seconds", new PlcINT(seconds));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_LONG)) { // DINT

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_UNSIGNED_LONG)) { // UDINT

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_FLOAT)) { // REAL

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_DOUBLE)) { // LREAL

      // Simple Field (value)
      Double value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readDouble("", 64);

      return new PlcLREAL(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_CHAR_BLOCK)) { // List
      // Array field (value)
      // Count array
      if (10 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (10)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 10;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS)) { // Struct
      // Array field (groupAddress)
      // Count array
      if (2 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (2) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> groupAddress;
      {
        int itemCount = (int) 2;
        groupAddress = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          groupAddress.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      // Simple Field (disable)
      Boolean disable = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 3);
        if (reserved != (byte) 0x0) {
          LOGGER.info(
              "Expected constant value " + 0x0 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (pollingSoftNr)
      Byte pollingSoftNr = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 4);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("groupAddress", new PlcList(groupAddress));
      _map.put("disable", new PlcBOOL(disable));
      _map.put("pollingSoftNr", new PlcSINT(pollingSoftNr));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK)) { // List
      // Array field (value)
      // Count array
      if (5 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (5) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 5;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_DATE_TIME)) { // Struct

      // Simple Field (year)
      Short year = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (month)
      Byte month = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 3);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (dayofmonth)
      Short dayofmonth = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Simple Field (dayofweek)
      Byte dayofweek = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 3);

      // Simple Field (hourofday)
      Short hourofday = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (minutes)
      Short minutes = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 6);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (seconds)
      Short seconds = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 6);

      // Simple Field (fault)
      Boolean fault = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (workingDay)
      Boolean workingDay = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noWd)
      Boolean noWd = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noYear)
      Boolean noYear = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noDate)
      Boolean noDate = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noDayOfWeek)
      Boolean noDayOfWeek = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noTime)
      Boolean noTime = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (standardSummerTime)
      Boolean standardSummerTime = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (qualityOfClock)
      Boolean qualityOfClock = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("year", new PlcINT(year));
      _map.put("month", new PlcSINT(month));
      _map.put("dayofmonth", new PlcINT(dayofmonth));
      _map.put("dayofweek", new PlcSINT(dayofweek));
      _map.put("hourofday", new PlcINT(hourofday));
      _map.put("minutes", new PlcINT(minutes));
      _map.put("seconds", new PlcINT(seconds));
      _map.put("fault", new PlcBOOL(fault));
      _map.put("workingDay", new PlcBOOL(workingDay));
      _map.put("noWd", new PlcBOOL(noWd));
      _map.put("noYear", new PlcBOOL(noYear));
      _map.put("noDate", new PlcBOOL(noDate));
      _map.put("noDayOfWeek", new PlcBOOL(noDayOfWeek));
      _map.put("noTime", new PlcBOOL(noTime));
      _map.put("standardSummerTime", new PlcBOOL(standardSummerTime));
      _map.put("qualityOfClock", new PlcBOOL(qualityOfClock));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_01)) { // List
      // Array field (value)
      // Count array
      if (1 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (1) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 1;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_02)) { // List
      // Array field (value)
      // Count array
      if (2 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (2) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 2;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_03)) { // List
      // Array field (value)
      // Count array
      if (3 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (3) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 3;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_04)) { // List
      // Array field (value)
      // Count array
      if (4 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (4) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 4;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_05)) { // List
      // Array field (value)
      // Count array
      if (5 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (5) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 5;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_06)) { // List
      // Array field (value)
      // Count array
      if (6 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (6) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 6;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_07)) { // List
      // Array field (value)
      // Count array
      if (7 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (7) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 7;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_08)) { // List
      // Array field (value)
      // Count array
      if (8 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (8) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 8;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_09)) { // List
      // Array field (value)
      // Count array
      if (9 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (9) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 9;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_10)) { // List
      // Array field (value)
      // Count array
      if (10 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (10)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 10;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_11)) { // List
      // Array field (value)
      // Count array
      if (11 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (11)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 11;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_12)) { // List
      // Array field (value)
      // Count array
      if (12 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (12)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 12;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_13)) { // List
      // Array field (value)
      // Count array
      if (13 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (13)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 13;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_14)) { // List
      // Array field (value)
      // Count array
      if (14 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (14)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 14;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_15)) { // List
      // Array field (value)
      // Count array
      if (15 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (15)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 15;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_16)) { // List
      // Array field (value)
      // Count array
      if (16 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (16)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 16;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_17)) { // List
      // Array field (value)
      // Count array
      if (17 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (17)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 17;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_18)) { // List
      // Array field (value)
      // Count array
      if (18 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (18)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 18;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_19)) { // List
      // Array field (value)
      // Count array
      if (19 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (19)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 19;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_20)) { // List
      // Array field (value)
      // Count array
      if (20 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (20)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 20;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_VERSION)) { // Struct

      // Simple Field (magicNumber)
      Short magicNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Simple Field (versionNumber)
      Short versionNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Simple Field (revisionNumber)
      Short revisionNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 6);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("magicNumber", new PlcINT(magicNumber));
      _map.put("versionNumber", new PlcINT(versionNumber));
      _map.put("revisionNumber", new PlcINT(revisionNumber));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_ALARM_INFO)) { // Struct

      // Simple Field (logNumber)
      Short logNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (alarmPriority)
      Short alarmPriority = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (applicationArea)
      Short applicationArea = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (errorClass)
      Short errorClass = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (errorcodeSup)
      Boolean errorcodeSup = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (alarmtextSup)
      Boolean alarmtextSup = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (timestampSup)
      Boolean timestampSup = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (ackSup)
      Boolean ackSup = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (locked)
      Boolean locked = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (alarmunack)
      Boolean alarmunack = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (inalarm)
      Boolean inalarm = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("logNumber", new PlcINT(logNumber));
      _map.put("alarmPriority", new PlcINT(alarmPriority));
      _map.put("applicationArea", new PlcINT(applicationArea));
      _map.put("errorClass", new PlcINT(errorClass));
      _map.put("errorcodeSup", new PlcBOOL(errorcodeSup));
      _map.put("alarmtextSup", new PlcBOOL(alarmtextSup));
      _map.put("timestampSup", new PlcBOOL(timestampSup));
      _map.put("ackSup", new PlcBOOL(ackSup));
      _map.put("locked", new PlcBOOL(locked));
      _map.put("alarmunack", new PlcBOOL(alarmunack));
      _map.put("inalarm", new PlcBOOL(inalarm));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_BINARY_INFORMATION)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_BITSET8)) { // List
      // Array field (value)
      // Count array
      if (8 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of " + (8) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 8;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcBOOL(
                  (Boolean) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_BITSET16)) { // List
      // Array field (value)
      // Count array
      if (16 > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (16)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) 16;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcBOOL(
                  (Boolean) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("")));
        }
      }

      return new PlcList(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_ENUM8)) { // USINT

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_SCALING)) { // USINT

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else { // List
      // Array field (value)
      // Count array
      if (dataLengthInBytes > Integer.MAX_VALUE) {
        throw new ParseException(
            "Array count of "
                + (dataLengthInBytes)
                + " exceeds the maximum allowed count of "
                + Integer.MAX_VALUE);
      }
      List<PlcValue> value;
      {
        int itemCount = (int) dataLengthInBytes;
        value = new LinkedList<>();
        for (int curItem = 0; curItem < itemCount; curItem++) {
          value.add(
              new PlcSINT(
                  (Byte) /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readByte("")));
        }
      }

      return new PlcList(value);
    }
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer,
      PlcValue _value,
      KnxPropertyDataType propertyType,
      Short dataLengthInBytes)
      throws SerializationException {
    staticSerialize(writeBuffer, _value, propertyType, dataLengthInBytes, ByteOrder.BIG_ENDIAN);
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer,
      PlcValue _value,
      KnxPropertyDataType propertyType,
      Short dataLengthInBytes,
      ByteOrder byteOrder)
      throws SerializationException {
    if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_CONTROL)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_CHAR)) { // SINT
      // Simple Field (value)
      byte value = (byte) _value.getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeSignedByte("", 8, ((Number) (value)).byteValue());
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_UNSIGNED_CHAR)) { // USINT
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_INT)) { // INT
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_UNSIGNED_INT)
        && EvaluationHelper.equals(dataLengthInBytes, 4)) { // UDINT
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_UNSIGNED_INT)) { // UINT
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_KNX_FLOAT)) { // REAL
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_DATE)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (byte) 0x00).byteValue());
      // Simple Field (dayOfMonth)
      short dayOfMonth = (short) _value.getStruct().get("dayOfMonth").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (dayOfMonth)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (month)
      byte month = (byte) _value.getStruct().get("month").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (month)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 1, ((Number) (byte) 0x00).byteValue());
      // Simple Field (year)
      short year = (short) _value.getStruct().get("year").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 7, ((Number) (year)).shortValue());
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_TIME)) { // Struct
      // Simple Field (day)
      byte day = (byte) _value.getStruct().get("day").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (day)).byteValue());
      // Simple Field (hour)
      short hour = (short) _value.getStruct().get("hour").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 5, ((Number) (hour)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (minutes)
      short minutes = (short) _value.getStruct().get("minutes").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 6, ((Number) (minutes)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (seconds)
      short seconds = (short) _value.getStruct().get("seconds").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 6, ((Number) (seconds)).shortValue());
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_LONG)) { // DINT
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_UNSIGNED_LONG)) { // UDINT
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_FLOAT)) { // REAL
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_DOUBLE)) { // LREAL
      // Simple Field (value)
      double value = (double) _value.getDouble();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeDouble("", 64, (value));
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_CHAR_BLOCK)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS)) { // Struct
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getStruct().get("groupAddress").getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

      // Simple Field (disable)
      boolean disable = (boolean) _value.getStruct().get("disable").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (disable));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (byte) 0x0).byteValue());
      // Simple Field (pollingSoftNr)
      byte pollingSoftNr = (byte) _value.getStruct().get("pollingSoftNr").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 4, ((Number) (pollingSoftNr)).byteValue());
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_DATE_TIME)) { // Struct
      // Simple Field (year)
      short year = (short) _value.getStruct().get("year").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (year)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (month)
      byte month = (byte) _value.getStruct().get("month").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (month)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (byte) 0x00).byteValue());
      // Simple Field (dayofmonth)
      short dayofmonth = (short) _value.getStruct().get("dayofmonth").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (dayofmonth)).shortValue());
      // Simple Field (dayofweek)
      byte dayofweek = (byte) _value.getStruct().get("dayofweek").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (dayofweek)).byteValue());
      // Simple Field (hourofday)
      short hourofday = (short) _value.getStruct().get("hourofday").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (hourofday)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (minutes)
      short minutes = (short) _value.getStruct().get("minutes").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 6, ((Number) (minutes)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (seconds)
      short seconds = (short) _value.getStruct().get("seconds").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 6, ((Number) (seconds)).shortValue());
      // Simple Field (fault)
      boolean fault = (boolean) _value.getStruct().get("fault").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (fault));
      // Simple Field (workingDay)
      boolean workingDay = (boolean) _value.getStruct().get("workingDay").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (workingDay));
      // Simple Field (noWd)
      boolean noWd = (boolean) _value.getStruct().get("noWd").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noWd));
      // Simple Field (noYear)
      boolean noYear = (boolean) _value.getStruct().get("noYear").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noYear));
      // Simple Field (noDate)
      boolean noDate = (boolean) _value.getStruct().get("noDate").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noDate));
      // Simple Field (noDayOfWeek)
      boolean noDayOfWeek = (boolean) _value.getStruct().get("noDayOfWeek").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noDayOfWeek));
      // Simple Field (noTime)
      boolean noTime = (boolean) _value.getStruct().get("noTime").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noTime));
      // Simple Field (standardSummerTime)
      boolean standardSummerTime =
          (boolean) _value.getStruct().get("standardSummerTime").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (standardSummerTime));
      // Simple Field (qualityOfClock)
      boolean qualityOfClock = (boolean) _value.getStruct().get("qualityOfClock").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (qualityOfClock));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_01)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_02)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_03)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_04)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_05)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_06)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_07)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_08)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_09)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_10)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_11)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_12)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_13)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_14)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_15)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_16)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_17)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_18)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_19)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_20)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_VERSION)) { // Struct
      // Simple Field (magicNumber)
      short magicNumber = (short) _value.getStruct().get("magicNumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (magicNumber)).shortValue());
      // Simple Field (versionNumber)
      short versionNumber = (short) _value.getStruct().get("versionNumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (versionNumber)).shortValue());
      // Simple Field (revisionNumber)
      short revisionNumber = (short) _value.getStruct().get("revisionNumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (revisionNumber)).shortValue());
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_ALARM_INFO)) { // Struct
      // Simple Field (logNumber)
      short logNumber = (short) _value.getStruct().get("logNumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (logNumber)).shortValue());
      // Simple Field (alarmPriority)
      short alarmPriority = (short) _value.getStruct().get("alarmPriority").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (alarmPriority)).shortValue());
      // Simple Field (applicationArea)
      short applicationArea = (short) _value.getStruct().get("applicationArea").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (applicationArea)).shortValue());
      // Simple Field (errorClass)
      short errorClass = (short) _value.getStruct().get("errorClass").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (errorClass)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (errorcodeSup)
      boolean errorcodeSup = (boolean) _value.getStruct().get("errorcodeSup").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (errorcodeSup));
      // Simple Field (alarmtextSup)
      boolean alarmtextSup = (boolean) _value.getStruct().get("alarmtextSup").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (alarmtextSup));
      // Simple Field (timestampSup)
      boolean timestampSup = (boolean) _value.getStruct().get("timestampSup").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (timestampSup));
      // Simple Field (ackSup)
      boolean ackSup = (boolean) _value.getStruct().get("ackSup").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (ackSup));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (locked)
      boolean locked = (boolean) _value.getStruct().get("locked").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (locked));
      // Simple Field (alarmunack)
      boolean alarmunack = (boolean) _value.getStruct().get("alarmunack").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (alarmunack));
      // Simple Field (inalarm)
      boolean inalarm = (boolean) _value.getStruct().get("inalarm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (inalarm));
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_BINARY_INFORMATION)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_BITSET8)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        Boolean value = (Boolean) val.getBoolean();
        /*TODO: migrate me*/
        /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_BITSET16)) { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        Boolean value = (Boolean) val.getBoolean();
        /*TODO: migrate me*/
        /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
      }

    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_ENUM8)) { // USINT
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_SCALING)) { // USINT
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else { // List
      PlcList values = (PlcList) _value;

      for (PlcValue val : ((List<PlcValue>) values.getList())) {
        byte[] value = (byte[]) val.getRaw();
        writeBuffer.writeByteArray("", value);
      }
    }
  }

  public static int getLengthInBytes(
      PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes) {
    return (int) Math.ceil((float) getLengthInBits(_value, propertyType, dataLengthInBytes) / 8.0);
  }

  public static int getLengthInBits(
      PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes) {
    int sizeInBits = 0;
    if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_CONTROL)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_CHAR)) { // SINT
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_UNSIGNED_CHAR)) { // USINT
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_INT)) { // INT
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_UNSIGNED_INT)
        && EvaluationHelper.equals(dataLengthInBytes, 4)) { // UDINT
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_UNSIGNED_INT)) { // UINT
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_KNX_FLOAT)) { // REAL
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_DATE)) { // Struct
      // Reserved Field
      sizeInBits += 3;
      // Simple Field (dayOfMonth)
      sizeInBits += 5;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (month)
      sizeInBits += 4;
      // Reserved Field
      sizeInBits += 1;
      // Simple Field (year)
      sizeInBits += 7;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_TIME)) { // Struct
      // Simple Field (day)
      sizeInBits += 3;
      // Simple Field (hour)
      sizeInBits += 5;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (minutes)
      sizeInBits += 6;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (seconds)
      sizeInBits += 6;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_LONG)) { // DINT
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_UNSIGNED_LONG)) { // UDINT
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_FLOAT)) { // REAL
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_DOUBLE)) { // LREAL
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_CHAR_BLOCK)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS)) { // Struct
      PlcList values = (PlcList) _value;
      // TODO: Finish this!
      // Simple Field (disable)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 3;
      // Simple Field (pollingSoftNr)
      sizeInBits += 4;
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_DATE_TIME)) { // Struct
      // Simple Field (year)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (month)
      sizeInBits += 4;
      // Reserved Field
      sizeInBits += 3;
      // Simple Field (dayofmonth)
      sizeInBits += 5;
      // Simple Field (dayofweek)
      sizeInBits += 3;
      // Simple Field (hourofday)
      sizeInBits += 5;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (minutes)
      sizeInBits += 6;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (seconds)
      sizeInBits += 6;
      // Simple Field (fault)
      sizeInBits += 1;
      // Simple Field (workingDay)
      sizeInBits += 1;
      // Simple Field (noWd)
      sizeInBits += 1;
      // Simple Field (noYear)
      sizeInBits += 1;
      // Simple Field (noDate)
      sizeInBits += 1;
      // Simple Field (noDayOfWeek)
      sizeInBits += 1;
      // Simple Field (noTime)
      sizeInBits += 1;
      // Simple Field (standardSummerTime)
      sizeInBits += 1;
      // Simple Field (qualityOfClock)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 7;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_01)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_02)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_03)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_04)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_05)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_06)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_07)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_08)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_09)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_10)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_11)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_12)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_13)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_14)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_15)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_16)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_17)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_18)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_19)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_GENERIC_20)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_VERSION)) { // Struct
      // Simple Field (magicNumber)
      sizeInBits += 5;
      // Simple Field (versionNumber)
      sizeInBits += 5;
      // Simple Field (revisionNumber)
      sizeInBits += 6;
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_ALARM_INFO)) { // Struct
      // Simple Field (logNumber)
      sizeInBits += 8;
      // Simple Field (alarmPriority)
      sizeInBits += 8;
      // Simple Field (applicationArea)
      sizeInBits += 8;
      // Simple Field (errorClass)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (errorcodeSup)
      sizeInBits += 1;
      // Simple Field (alarmtextSup)
      sizeInBits += 1;
      // Simple Field (timestampSup)
      sizeInBits += 1;
      // Simple Field (ackSup)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (locked)
      sizeInBits += 1;
      // Simple Field (alarmunack)
      sizeInBits += 1;
      // Simple Field (inalarm)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        propertyType, KnxPropertyDataType.PDT_BINARY_INFORMATION)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_BITSET8)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 1;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_BITSET16)) { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 1;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_ENUM8)) { // USINT
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(propertyType, KnxPropertyDataType.PDT_SCALING)) { // USINT
      // Simple Field (value)
      sizeInBits += 8;
    } else { // List
      PlcList values = (PlcList) _value;
      sizeInBits += values.getList().size() * 8;
    }
    return sizeInBits;
  }
}
