/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MPropReadCon extends CEMI implements Message {

  // Accessors for discriminator values.
  public Short getMessageCode() {
    return (short) 0xFB;
  }

  // Properties.
  protected final int interfaceObjectType;
  protected final short objectInstance;
  protected final short propertyId;
  protected final byte numberOfElements;
  protected final int startIndex;
  protected final int data;

  // Arguments.
  protected final Integer size;

  public MPropReadCon(
      int interfaceObjectType,
      short objectInstance,
      short propertyId,
      byte numberOfElements,
      int startIndex,
      int data,
      Integer size) {
    super(size);
    this.interfaceObjectType = interfaceObjectType;
    this.objectInstance = objectInstance;
    this.propertyId = propertyId;
    this.numberOfElements = numberOfElements;
    this.startIndex = startIndex;
    this.data = data;
    this.size = size;
  }

  public int getInterfaceObjectType() {
    return interfaceObjectType;
  }

  public short getObjectInstance() {
    return objectInstance;
  }

  public short getPropertyId() {
    return propertyId;
  }

  public byte getNumberOfElements() {
    return numberOfElements;
  }

  public int getStartIndex() {
    return startIndex;
  }

  public int getData() {
    return data;
  }

  @Override
  protected void serializeCEMIChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("MPropReadCon");

    // Simple Field (interfaceObjectType)
    writeSimpleField("interfaceObjectType", interfaceObjectType, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (objectInstance)
    writeSimpleField("objectInstance", objectInstance, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (propertyId)
    writeSimpleField("propertyId", propertyId, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (numberOfElements)
    writeSimpleField("numberOfElements", numberOfElements, writeUnsignedByte(writeBuffer, 4));

    // Simple Field (startIndex)
    writeSimpleField("startIndex", startIndex, writeUnsignedInt(writeBuffer, 12));

    // Simple Field (data)
    writeSimpleField("data", data, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("MPropReadCon");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MPropReadCon _value = this;

    // Simple field (interfaceObjectType)
    lengthInBits += 16;

    // Simple field (objectInstance)
    lengthInBits += 8;

    // Simple field (propertyId)
    lengthInBits += 8;

    // Simple field (numberOfElements)
    lengthInBits += 4;

    // Simple field (startIndex)
    lengthInBits += 12;

    // Simple field (data)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static MPropReadConBuilder staticParseBuilder(ReadBuffer readBuffer, Integer size)
      throws ParseException {
    readBuffer.pullContext("MPropReadCon");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int interfaceObjectType =
        readSimpleField("interfaceObjectType", readUnsignedInt(readBuffer, 16));

    short objectInstance = readSimpleField("objectInstance", readUnsignedShort(readBuffer, 8));

    short propertyId = readSimpleField("propertyId", readUnsignedShort(readBuffer, 8));

    byte numberOfElements = readSimpleField("numberOfElements", readUnsignedByte(readBuffer, 4));

    int startIndex = readSimpleField("startIndex", readUnsignedInt(readBuffer, 12));

    int data = readSimpleField("data", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("MPropReadCon");
    // Create the instance
    return new MPropReadConBuilder(
        interfaceObjectType, objectInstance, propertyId, numberOfElements, startIndex, data, size);
  }

  public static class MPropReadConBuilder implements CEMI.CEMIBuilder {
    private final int interfaceObjectType;
    private final short objectInstance;
    private final short propertyId;
    private final byte numberOfElements;
    private final int startIndex;
    private final int data;
    private final Integer size;

    public MPropReadConBuilder(
        int interfaceObjectType,
        short objectInstance,
        short propertyId,
        byte numberOfElements,
        int startIndex,
        int data,
        Integer size) {

      this.interfaceObjectType = interfaceObjectType;
      this.objectInstance = objectInstance;
      this.propertyId = propertyId;
      this.numberOfElements = numberOfElements;
      this.startIndex = startIndex;
      this.data = data;
      this.size = size;
    }

    public MPropReadCon build(Integer size) {

      MPropReadCon mPropReadCon =
          new MPropReadCon(
              interfaceObjectType,
              objectInstance,
              propertyId,
              numberOfElements,
              startIndex,
              data,
              size);
      return mPropReadCon;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MPropReadCon)) {
      return false;
    }
    MPropReadCon that = (MPropReadCon) o;
    return (getInterfaceObjectType() == that.getInterfaceObjectType())
        && (getObjectInstance() == that.getObjectInstance())
        && (getPropertyId() == that.getPropertyId())
        && (getNumberOfElements() == that.getNumberOfElements())
        && (getStartIndex() == that.getStartIndex())
        && (getData() == that.getData())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getInterfaceObjectType(),
        getObjectInstance(),
        getPropertyId(),
        getNumberOfElements(),
        getStartIndex(),
        getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
