/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.ets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.knxnetip.ets.filehandlers.Ets5FileHandler;
import org.apache.plc4x.java.knxnetip.ets.filehandlers.Ets6FileHandler;
import org.apache.plc4x.java.knxnetip.ets.filehandlers.EtsFileHandler;
import org.apache.plc4x.java.knxnetip.ets.model.AddressType;
import org.apache.plc4x.java.knxnetip.ets.model.EtsModel;
import org.apache.plc4x.java.knxnetip.ets.model.Function;
import org.apache.plc4x.java.knxnetip.ets.model.GroupAddress;
import org.apache.plc4x.java.knxnetip.readwrite.KnxDatapointType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EtsParser {
    public EtsModel parse(File knxprojFile, String password) {
        EtsModel etsModel;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder builder = factory.newDocumentBuilder();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        ZipFile zipFile = new ZipFile(knxprojFile);
        try {
            Document projectDoc;
            Document projectHeaderDoc;
            Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
            FileHeader knxMasterFileHeader = zipFile.getFileHeader("knx_master.xml");
            if (knxMasterFileHeader == null) {
                throw new PlcRuntimeException("Error accessing knx_master.xml file.");
            }
            zipFile.extractFile("knx_master.xml", tempDir.toFile().getAbsolutePath());
            File knxMasterFile = new File(tempDir.toFile(), "knx_master.xml");
            Scanner scanner = new Scanner(knxMasterFile);
            String etsSchemaVersion = null;
            while (scanner.hasNextLine()) {
                String curLine = scanner.nextLine();
                if (!curLine.contains("http://knx.org/xml/project/")) continue;
                etsSchemaVersion = curLine.substring(curLine.indexOf("http://knx.org/xml/project/") + "http://knx.org/xml/project/".length());
                etsSchemaVersion = etsSchemaVersion.substring(0, etsSchemaVersion.indexOf("\""));
                break;
            }
            EtsFileHandler fileHandler = "21".equals(etsSchemaVersion) ? new Ets6FileHandler() : new Ets5FileHandler();
            String projectNumber = this.getProjectNumber(zipFile);
            FileHeader projectFileHeader = zipFile.getFileHeader(projectNumber + "/project.xml");
            if (projectFileHeader == null) {
                FileHeader encryptedProjectFileHeader = zipFile.getFileHeader(projectNumber + ".zip");
                if (encryptedProjectFileHeader == null) {
                    throw new PlcRuntimeException(String.format("Error accessing project header file. Project file '%s/project.xml' and '%s.zip' don't exist.", projectNumber, projectNumber));
                }
                zipFile.extractFile(projectNumber + ".zip", tempDir.toFile().getAbsolutePath());
                File tempFile = new File(tempDir.toFile(), projectNumber + ".zip");
                try (ZipFile projectZipFile = fileHandler.getProjectFiles(tempFile, password);){
                    FileHeader compressedProjectFileHeader = projectZipFile.getFileHeader("project.xml");
                    if (compressedProjectFileHeader == null) {
                        throw new PlcRuntimeException(String.format("Error accessing project header file: Project file 'project.xml' inside '%s.zip'.", projectNumber));
                    }
                    projectHeaderDoc = builder.parse((InputStream)projectZipFile.getInputStream(compressedProjectFileHeader));
                    FileHeader projectFileFileHeader = projectZipFile.getFileHeader("0.xml");
                    if (projectFileFileHeader == null) {
                        throw new PlcRuntimeException("Error accessing project file.");
                    }
                    projectDoc = builder.parse((InputStream)projectZipFile.getInputStream(projectFileFileHeader));
                }
            } else {
                projectHeaderDoc = builder.parse((InputStream)zipFile.getInputStream(projectFileHeader));
                FileHeader projectFileFileHeader = zipFile.getFileHeader(projectNumber + "/0.xml");
                if (projectFileFileHeader == null) {
                    throw new PlcRuntimeException("Error accessing project file.");
                }
                projectDoc = builder.parse((InputStream)zipFile.getInputStream(projectFileFileHeader));
            }
            XPathExpression xpathGroupAddressStyle = xPath.compile("/KNX/Project/ProjectInformation/@GroupAddressStyle");
            Attr groupAddressStyle = (Attr)xpathGroupAddressStyle.evaluate(projectHeaderDoc, XPathConstants.NODE);
            byte groupAddressStyleCode = this.getGroupAddressLevel(groupAddressStyle.getTextContent());
            FileHeader knxMasterDataFileFileHeader = zipFile.getFileHeader("knx_master.xml");
            if (knxMasterDataFileFileHeader == null) {
                throw new PlcRuntimeException("Error accessing KNX master file.");
            }
            Document knxMasterDoc = builder.parse((InputStream)zipFile.getInputStream(knxMasterDataFileFileHeader));
            XPathExpression xpathDatapointSubtype = xPath.compile("//DatapointSubtype");
            NodeList datapointSubtypeNodes = (NodeList)xpathDatapointSubtype.evaluate(knxMasterDoc, XPathConstants.NODESET);
            TreeMap<String, KnxDatapointType> knxDatapointTypeMap = new TreeMap<String, KnxDatapointType>();
            for (KnxDatapointType value : KnxDatapointType.values()) {
                knxDatapointTypeMap.put(value.getDatapointMainType().getNumber() + "#" + value.getNumber(), value);
            }
            HashMap<String, AddressType> addressTypes = new HashMap<String, AddressType>();
            for (int i = 0; i < datapointSubtypeNodes.getLength(); ++i) {
                Element datapointSubtypeNode = (Element)datapointSubtypeNodes.item(i);
                String id = datapointSubtypeNode.getAttribute("Id");
                int subType = Integer.parseInt(datapointSubtypeNode.getAttribute("Number"));
                int mainType = Integer.parseInt(((Element)datapointSubtypeNode.getParentNode().getParentNode()).getAttribute("Number"));
                String name = datapointSubtypeNode.getAttribute("Text");
                addressTypes.put(id, new AddressType(id, mainType, subType, name));
            }
            HashMap<String, String> topologyNames = new HashMap<String, String>();
            XPathExpression topology = xPath.compile("//Topology");
            Element topologyElement = (Element)topology.evaluate(projectDoc, XPathConstants.NODE);
            NodeList areas = topologyElement.getElementsByTagName("Area");
            for (int a = 0; a < areas.getLength(); ++a) {
                Element areaNode = (Element)areas.item(a);
                String curAreaAddress = areaNode.getAttribute("Address");
                topologyNames.put(curAreaAddress, areaNode.getAttribute("Name"));
                NodeList lines = areaNode.getElementsByTagName("Line");
                for (int l = 0; l < lines.getLength(); ++l) {
                    Element lineNode = (Element)lines.item(l);
                    String curLineAddress = curAreaAddress + "/" + lineNode.getAttribute("Address");
                    topologyNames.put(curLineAddress, lineNode.getAttribute("Name"));
                }
            }
            HashMap<String, Function> groupAddressRefs = new HashMap<String, Function>();
            XPathExpression xpathGroupAddressRef = xPath.compile("//GroupAddressRef");
            NodeList groupAddressRefNodes = (NodeList)xpathGroupAddressRef.evaluate(projectDoc, XPathConstants.NODESET);
            for (int i = 0; i < groupAddressRefNodes.getLength(); ++i) {
                Element groupAddressRefNode = (Element)groupAddressRefNodes.item(i);
                String refId = groupAddressRefNode.getAttribute("RefId");
                Element functionNode = (Element)groupAddressRefNode.getParentNode();
                String functionName = functionNode.getAttribute("Name");
                String functionTypeId = functionNode.getAttribute("Type");
                Element spaceNode = (Element)functionNode.getParentNode();
                String spaceName = spaceNode.getAttribute("Name");
                Function function = new Function(refId, functionName, functionTypeId, spaceName);
                groupAddressRefs.put(refId, function);
            }
            XPathExpression xpathGroupAddresses = xPath.compile("//GroupAddress");
            NodeList groupAddressNodes = (NodeList)xpathGroupAddresses.evaluate(projectDoc, XPathConstants.NODESET);
            HashMap<String, GroupAddress> groupAddresses = new HashMap<String, GroupAddress>();
            for (int i = 0; i < groupAddressNodes.getLength(); ++i) {
                Element groupAddressNode = (Element)groupAddressNodes.item(i);
                String id = groupAddressNode.getAttribute("Id");
                Function function = (Function)groupAddressRefs.get(id);
                int addressInt = Integer.parseInt(groupAddressNode.getAttribute("Address"));
                String knxGroupAddress = EtsModel.parseGroupAddress(groupAddressStyleCode, addressInt);
                String name = groupAddressNode.getAttribute("Name");
                String typeString = groupAddressNode.getAttribute("DatapointType");
                AddressType addressType = (AddressType)addressTypes.get(typeString);
                if (addressType == null) continue;
                KnxDatapointType datapointType = (KnxDatapointType)((Object)knxDatapointTypeMap.get(addressType.getMainType() + "#" + addressType.getSubType()));
                GroupAddress groupAddress = new GroupAddress(knxGroupAddress, name, datapointType, function);
                groupAddresses.put(knxGroupAddress, groupAddress);
            }
            etsModel = new EtsModel(groupAddressStyleCode, groupAddresses, topologyNames);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new PlcRuntimeException((Throwable)e);
            }
        }
        zipFile.close();
        return etsModel;
    }

    private byte getGroupAddressLevel(String knxprojValue) {
        if ("ThreeLevel".equals(knxprojValue)) {
            return 3;
        }
        if ("TwoLevel".equals(knxprojValue)) {
            return 2;
        }
        if ("Free".equals(knxprojValue)) {
            return 1;
        }
        throw new PlcRuntimeException("Unsupported GroupAddressStyle=" + knxprojValue);
    }

    private String getProjectNumber(ZipFile zipFile) throws ZipException {
        Pattern pattern = Pattern.compile("^P-[\\dA-F]{4}", 2);
        for (FileHeader fileHeader : zipFile.getFileHeaders()) {
            Matcher matcher = pattern.matcher(fileHeader.getFileName());
            if (!matcher.find()) continue;
            return matcher.group();
        }
        throw new PlcRuntimeException("Error determining project number.");
    }
}

