/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ComObjectValueType {
    BIT1(0, 1),
    BIT2(1, 1),
    BIT3(2, 1),
    BIT4(3, 1),
    BIT5(4, 1),
    BIT6(5, 1),
    BIT7(6, 1),
    BYTE1(7, 1),
    BYTE2(8, 2),
    BYTE3(9, 3),
    BYTE4(10, 4),
    BYTE6(11, 6),
    BYTE8(12, 8),
    BYTE10(13, 10),
    BYTE14(14, 14);

    private static final Map<Short, ComObjectValueType> map;
    private short value;
    private short sizeInBytes;

    private ComObjectValueType(short value, short sizeInBytes) {
        this.value = value;
        this.sizeInBytes = sizeInBytes;
    }

    public short getValue() {
        return this.value;
    }

    public short getSizeInBytes() {
        return this.sizeInBytes;
    }

    public static ComObjectValueType firstEnumForFieldSizeInBytes(short fieldValue) {
        for (ComObjectValueType _val : ComObjectValueType.values()) {
            if (_val.getSizeInBytes() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<ComObjectValueType> enumsForFieldSizeInBytes(short fieldValue) {
        ArrayList<ComObjectValueType> _values = new ArrayList<ComObjectValueType>();
        for (ComObjectValueType _val : ComObjectValueType.values()) {
            if (_val.getSizeInBytes() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static ComObjectValueType enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Short, ComObjectValueType>();
        for (ComObjectValueType value : ComObjectValueType.values()) {
            map.put(value.getValue(), value);
        }
    }
}

