/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.CEMIPriority;
import org.apache.plc4x.java.knxnetip.readwrite.KnxAddress;
import org.apache.plc4x.java.knxnetip.readwrite.LDataFrame;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class LPollData
extends LDataFrame
implements Message {
    protected final KnxAddress sourceAddress;
    protected final byte[] targetAddress;
    protected final short numberExpectedPollData;
    private Byte reservedField0;

    @Override
    public Boolean getNotAckFrame() {
        return true;
    }

    @Override
    public Boolean getPolling() {
        return true;
    }

    public LPollData(boolean frameType, boolean notRepeated, CEMIPriority priority, boolean acknowledgeRequested, boolean errorFlag, KnxAddress sourceAddress, byte[] targetAddress, short numberExpectedPollData) {
        super(frameType, notRepeated, priority, acknowledgeRequested, errorFlag);
        this.sourceAddress = sourceAddress;
        this.targetAddress = targetAddress;
        this.numberExpectedPollData = numberExpectedPollData;
    }

    public KnxAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public byte[] getTargetAddress() {
        return this.targetAddress;
    }

    public short getNumberExpectedPollData() {
        return this.numberExpectedPollData;
    }

    @Override
    protected void serializeLDataFrameChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("LPollData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sourceAddress", (Object)this.sourceAddress, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"targetAddress", (byte[])this.targetAddress, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (byte)0), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"numberExpectedPollData", (Object)this.numberExpectedPollData, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)6), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("LPollData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        LPollData _value = this;
        lengthInBits += this.sourceAddress.getLengthInBits();
        if (this.targetAddress != null) {
            lengthInBits += 8 * this.targetAddress.length;
        }
        lengthInBits += 4;
        return lengthInBits += 6;
    }

    public static LPollDataBuilder staticParseBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("LPollData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        KnxAddress sourceAddress = (KnxAddress)FieldReaderFactory.readSimpleField((String)"sourceAddress", (DataReader)new DataReaderComplexDefault(() -> KnxAddress.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] targetAddress = readBuffer.readByteArray("targetAddress", Math.toIntExact(2L), new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        short numberExpectedPollData = (Short)FieldReaderFactory.readSimpleField((String)"numberExpectedPollData", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)6), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("LPollData", new WithReaderArgs[0]);
        return new LPollDataBuilder(sourceAddress, targetAddress, numberExpectedPollData, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LPollData)) {
            return false;
        }
        LPollData that = (LPollData)o;
        return this.getSourceAddress() == that.getSourceAddress() && this.getTargetAddress() == that.getTargetAddress() && this.getNumberExpectedPollData() == that.getNumberExpectedPollData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSourceAddress(), this.getTargetAddress(), this.getNumberExpectedPollData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class LPollDataBuilder
    implements LDataFrame.LDataFrameBuilder {
        private final KnxAddress sourceAddress;
        private final byte[] targetAddress;
        private final short numberExpectedPollData;
        private final Byte reservedField0;

        public LPollDataBuilder(KnxAddress sourceAddress, byte[] targetAddress, short numberExpectedPollData, Byte reservedField0) {
            this.sourceAddress = sourceAddress;
            this.targetAddress = targetAddress;
            this.numberExpectedPollData = numberExpectedPollData;
            this.reservedField0 = reservedField0;
        }

        @Override
        public LPollData build(boolean frameType, boolean notRepeated, CEMIPriority priority, boolean acknowledgeRequested, boolean errorFlag) {
            LPollData lPollData = new LPollData(frameType, notRepeated, priority, acknowledgeRequested, errorFlag, this.sourceAddress, this.targetAddress, this.numberExpectedPollData);
            lPollData.reservedField0 = this.reservedField0;
            return lPollData;
        }
    }
}

