/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum SupportedPhysicalMedia {
    OTHER(0, true, "used_for_undefined_physical_medium"),
    OIL_METER(1, true, "measures_volume_of_oil"),
    ELECTRICITY_METER(2, true, "measures_electric_energy"),
    GAS_METER(3, true, "measures_volume_of_gaseous_energy"),
    HEAT_METER(4, true, "heat_energy_measured_in_outlet_pipe"),
    STEAM_METER(5, true, "measures_weight_of_hot_steam"),
    WARM_WATER_METER(6, true, "measured_heated_water_volume"),
    WATER_METER(7, true, "measured_water_volume"),
    HEAT_COST_ALLOCATOR(8, true, "measured_relative_cumulated_heat_consumption"),
    COMPRESSED_AIR(9, false, "measures_weight_of_compressed_air"),
    COOLING_LOAD_METER_INLET(10, true, "cooling_energy_measured_in_inlet_pipe"),
    COOLING_LOAD_METER_OUTLET(11, true, "cooling_energy_measured_in_outlet_pipe"),
    HEAT_INLET(12, true, "heat_energy_measured_in_inlet_pipe"),
    HEAT_AND_COOL(13, true, "measures_both_heat_and_cool"),
    BUS_OR_SYSTEM(14, false, "no_meter"),
    UNKNOWN_DEVICE_TYPE(15, false, "used_for_undefined_physical_medium"),
    BREAKER(32, true, "status_of_electric_energy_supply"),
    VALVE(33, true, "status_of_supply_of_Gas_or_water"),
    WASTE_WATER_METER(40, true, "measured_volume_of_disposed_water"),
    GARBAGE(41, true, "measured_weight_of_disposed_rubbish"),
    RADIO_CONVERTER(55, false, "enables_the_radio_transmission_of_a_meter_without_a_radio_interface");

    private static final Map<Short, SupportedPhysicalMedia> map;
    private short value;
    private boolean knxSupport;
    private String description;

    private SupportedPhysicalMedia(short value, boolean knxSupport, String description) {
        this.value = value;
        this.knxSupport = knxSupport;
        this.description = description;
    }

    public short getValue() {
        return this.value;
    }

    public boolean getKnxSupport() {
        return this.knxSupport;
    }

    public static SupportedPhysicalMedia firstEnumForFieldKnxSupport(boolean fieldValue) {
        for (SupportedPhysicalMedia _val : SupportedPhysicalMedia.values()) {
            if (_val.getKnxSupport() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<SupportedPhysicalMedia> enumsForFieldKnxSupport(boolean fieldValue) {
        ArrayList<SupportedPhysicalMedia> _values = new ArrayList<SupportedPhysicalMedia>();
        for (SupportedPhysicalMedia _val : SupportedPhysicalMedia.values()) {
            if (_val.getKnxSupport() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public String getDescription() {
        return this.description;
    }

    public static SupportedPhysicalMedia firstEnumForFieldDescription(String fieldValue) {
        for (SupportedPhysicalMedia _val : SupportedPhysicalMedia.values()) {
            if (_val.getDescription() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<SupportedPhysicalMedia> enumsForFieldDescription(String fieldValue) {
        ArrayList<SupportedPhysicalMedia> _values = new ArrayList<SupportedPhysicalMedia>();
        for (SupportedPhysicalMedia _val : SupportedPhysicalMedia.values()) {
            if (_val.getDescription() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static SupportedPhysicalMedia enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Short, SupportedPhysicalMedia>();
        for (SupportedPhysicalMedia value : SupportedPhysicalMedia.values()) {
            map.put(value.getValue(), value);
        }
    }
}

