/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.configuration;

import org.apache.plc4x.java.knxnetip.readwrite.KnxLayer;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.Description;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.IntDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.StringDefaultValue;
import org.apache.plc4x.java.spi.configuration.exceptions.ConfigurationException;

public class KnxNetIpConfiguration
implements PlcConnectionConfiguration {
    @ConfigurationParameter(value="knxproj-file-path")
    @Description(value="Path to the `knxproj` file. The default KNXnet/IP protocol doesn't provide all the information needed to be able to fully decode the messages.")
    public String knxprojFilePath;
    @ConfigurationParameter(value="knxproj-password")
    @Description(value="Optional password needed to read the knxproj file.")
    public String knxprojPassword;
    @ConfigurationParameter(value="group-address-num-levels")
    @IntDefaultValue(value=3)
    @Description(value="KNX Addresses can be encoded in multiple ways. Which encoding is used, is too not provided by the protocol itself so it has to be provided externally:\n\n- 3 Levels: {main-group (5 bit)}/{middle-group (3 bit)}/{sub-group (8 bit)}\n- 2 Levels: {main-group (5 bit)}/{sub-group (11 bit)}\n- 1 Level: {sub-group (16 bit)}\n\nThe default is 3 levels. If the `knxproj-file-path` this information is provided by the file.")
    public int groupAddressNumLevels = 3;
    @ConfigurationParameter(value="connection-type")
    @StringDefaultValue(value="LINK_LAYER")
    @Description(value="Type of connection used to communicate. Possible values are:\n\n- 'LINK_LAYER' (default): The client becomes a participant of the KNX bus and gets it's own individual KNX address.\n- 'RAW': The client gets unmanaged access to the bus (be careful with this)\n- 'BUSMONITOR': The client operates as a busmonitor where he can't actively participate on the bus. Only one 'BUSMONITOR' connection is allowed at the same time on a KNXnet/IP gateway.")
    public String connectionType = "LINK_LAYER";

    public String getKnxprojFilePath() {
        return this.knxprojFilePath;
    }

    public void setKnxprojFilePath(String knxprojFilePath) {
        this.knxprojFilePath = knxprojFilePath;
    }

    public String getKnxprojPassword() {
        return this.knxprojPassword;
    }

    public void setKnxprojPassword(String knxprojPassword) {
        this.knxprojPassword = knxprojPassword;
    }

    public int getGroupAddressNumLevels() {
        return this.groupAddressNumLevels;
    }

    public void setGroupAddressNumLevels(int groupAddressNumLevels) {
        this.groupAddressNumLevels = groupAddressNumLevels;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        try {
            KnxLayer.valueOf("TUNNEL_" + connectionType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Value provided for connection-type invalid.");
        }
        this.connectionType = connectionType.toUpperCase();
    }

    public String toString() {
        return "Configuration{knxprojFilePath=" + this.knxprojFilePath + ", " + "groupAddressNumLevels=" + this.groupAddressNumLevels + '}';
    }
}

