/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.mock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcDriver;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.mock.connection.MockConnection;
import org.apache.plc4x.java.mock.field.MockField;

public class MockDriver
implements PlcDriver {
    private Map<String, PlcConnection> connectionMap = new ConcurrentHashMap<String, PlcConnection>();

    public String getProtocolCode() {
        return "mock";
    }

    public String getProtocolName() {
        return "Mock Protocol Implementation";
    }

    public PlcConnection getConnection(String url) throws PlcConnectionException {
        return this.getConnection(url, null);
    }

    public PlcConnection getConnection(String url, PlcAuthentication authentication) throws PlcConnectionException {
        String deviceName = url.substring(5);
        if (deviceName.isEmpty()) {
            throw new PlcConnectionException("Invalid URL: no device name given.");
        }
        return this.connectionMap.computeIfAbsent(deviceName, name -> new MockConnection(authentication));
    }

    public MockField prepareField(String query) {
        return MockField.of(query);
    }
}

