/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.mock.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseRequestInterceptor;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcPingRequest;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.metadata.PlcConnectionMetadata;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.mock.connection.MockDevice;
import org.apache.plc4x.java.mock.tag.MockTagHandler;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcPingRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcPingResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcBrowser;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockConnection
implements PlcConnection,
PlcReader,
PlcWriter,
PlcSubscriber,
PlcBrowser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockConnection.class);
    private final PlcAuthentication authentication;
    private MockDevice device;

    public MockConnection(PlcAuthentication authentication) {
        this.authentication = authentication;
    }

    public MockDevice getDevice() {
        return this.device;
    }

    public void setDevice(MockDevice device) {
        LOGGER.info("Set Mock Device on Mock Connection {} with device {}", (Object)this, (Object)device);
        this.device = device;
    }

    public void connect() {
    }

    public CompletableFuture<? extends PlcPingResponse> ping() {
        return CompletableFuture.completedFuture(new DefaultPlcPingResponse((PlcPingRequest)new DefaultPlcPingRequest(null), PlcResponseCode.OK));
    }

    public boolean isConnected() {
        return this.device != null;
    }

    public void close() {
        LOGGER.info("Closing MockConnection with device {}", (Object)this.device);
    }

    public PlcConnectionMetadata getMetadata() {
        return new PlcConnectionMetadata(){

            public boolean canRead() {
                return true;
            }

            public boolean canWrite() {
                return true;
            }

            public boolean canSubscribe() {
                return true;
            }

            public boolean canBrowse() {
                return true;
            }
        };
    }

    public PlcBrowseRequest.Builder browseRequestBuilder() {
        return new DefaultPlcBrowseRequest.Builder((PlcBrowser)this, (PlcTagHandler)new MockTagHandler());
    }

    public CompletableFuture<PlcBrowseResponse> browse(PlcBrowseRequest browseRequest) {
        return CompletableFuture.supplyAsync(() -> {
            Validate.notNull((Object)this.device, (String)"No device is set in the mock connection!", (Object[])new Object[0]);
            LOGGER.debug("Sending browse request to MockDevice");
            return new DefaultPlcBrowseResponse(browseRequest, Collections.emptyMap(), Collections.emptyMap());
        });
    }

    public CompletableFuture<PlcBrowseResponse> browseWithInterceptor(PlcBrowseRequest browseRequest, PlcBrowseRequestInterceptor interceptor) {
        return CompletableFuture.supplyAsync(() -> {
            Validate.notNull((Object)this.device, (String)"No device is set in the mock connection!", (Object[])new Object[0]);
            LOGGER.debug("Sending browse request to MockDevice");
            return new DefaultPlcBrowseResponse(browseRequest, Collections.emptyMap(), Collections.emptyMap());
        });
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        return new DefaultPlcReadRequest.Builder((PlcReader)this, (PlcTagHandler)new MockTagHandler());
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        return CompletableFuture.supplyAsync(() -> {
            Validate.notNull((Object)this.device, (String)"No device is set in the mock connection!", (Object[])new Object[0]);
            LOGGER.debug("Sending read request to MockDevice");
            Map response = readRequest.getTagNames().stream().collect(Collectors.toMap(Function.identity(), name -> this.device.read(readRequest.getTag(name).getAddressString())));
            return new DefaultPlcReadResponse(readRequest, response);
        });
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        return CompletableFuture.supplyAsync(() -> {
            Validate.notNull((Object)this.device, (String)"No device is set in the mock connection!", (Object[])new Object[0]);
            LOGGER.debug("Sending write request to MockDevice");
            Map response = writeRequest.getTagNames().stream().collect(Collectors.toMap(Function.identity(), name -> this.device.write(writeRequest.getTag(name).getAddressString(), writeRequest.getPlcValue(name))));
            return new DefaultPlcWriteResponse((PlcWriteRequest)((DefaultPlcWriteRequest)writeRequest), response);
        });
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        return CompletableFuture.supplyAsync(() -> {
            Validate.notNull((Object)this.device, (String)"No device is set in the mock connection!", (Object[])new Object[0]);
            LOGGER.debug("Sending subsribe request to MockDevice");
            Map response = subscriptionRequest.getTagNames().stream().collect(Collectors.toMap(Function.identity(), name -> this.device.subscribe(subscriptionRequest.getTag(name).getAddressString())));
            return new DefaultPlcSubscriptionResponse(subscriptionRequest, response);
        });
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        return CompletableFuture.supplyAsync(() -> {
            Validate.notNull((Object)this.device, (String)"No device is set in the mock connection!", (Object[])new Object[0]);
            LOGGER.debug("Sending subsribe request to MockDevice");
            this.device.unsubscribe();
            return new DefaultPlcUnsubscriptionResponse(unsubscriptionRequest);
        });
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        return this.device.register(consumer, handles);
    }

    public void unregister(PlcConsumerRegistration registration) {
        this.device.unregister(registration);
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        return new DefaultPlcWriteRequest.Builder((PlcWriter)this, (PlcTagHandler)new MockTagHandler(), (org.apache.plc4x.java.api.value.PlcValueHandler)new PlcValueHandler());
    }

    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        return new DefaultPlcSubscriptionRequest.Builder((PlcSubscriber)this, (PlcTagHandler)new MockTagHandler());
    }

    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        return new DefaultPlcUnsubscriptionRequest.Builder((PlcSubscriber)this);
    }

    public PlcAuthentication getAuthentication() {
        return this.authentication;
    }
}

