/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.mock.connection.tcp;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.HexDump;
import org.apache.commons.io.IOUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpHexDumper
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TcpHexDumper.class);
    private final ExecutorService pool = Executors.newCachedThreadPool();
    private final Integer portToUse;
    private final Integer shutdownTimeout;
    private ServerSocket serverSocket;

    private TcpHexDumper(Integer portToUse) {
        this(portToUse, 10);
    }

    public TcpHexDumper(Integer portToUse, Integer shutdownTimeout) {
        this.portToUse = portToUse;
        this.shutdownTimeout = shutdownTimeout;
    }

    private void init(int port) throws IOException, InterruptedException {
        if (this.serverSocket != null) {
            this.stop(true);
        }
        this.serverSocket = new ServerSocket(port);
        logger.info("Starting pool");
        this.pool.submit(() -> {
            Socket accept;
            try {
                logger.info("Waiting for an incoming connection");
                accept = this.serverSocket.accept();
                logger.info("Accepted {} and starting listener", (Object)accept);
            }
            catch (IOException e) {
                throw new PlcRuntimeException((Throwable)e);
            }
            this.pool.submit(() -> {
                InputStream inputStream;
                try {
                    inputStream = accept.getInputStream();
                    logger.info("Starting to read now");
                }
                catch (IOException e) {
                    throw new PlcRuntimeException((Throwable)e);
                }
                byte[] buffer = new byte[4096];
                try {
                    while (IOUtils.read((InputStream)inputStream, (byte[])buffer) > 0) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        HexDump.dump((byte[])buffer, (long)0L, (OutputStream)byteArrayOutputStream, (int)0);
                        logger.info("Dump:\n{}", (Object)byteArrayOutputStream);
                    }
                }
                catch (IOException e) {
                    throw new PlcRuntimeException((Throwable)e);
                }
            });
        });
        logger.info("Started pool");
    }

    private void stop() throws IOException, InterruptedException {
        this.stop(false);
    }

    private void stop(boolean await) throws IOException, InterruptedException {
        this.serverSocket.close();
        if (await) {
            this.pool.awaitTermination(this.shutdownTimeout.intValue(), TimeUnit.SECONDS);
        } else {
            this.pool.shutdownNow();
        }
        logger.info("Stopped");
    }

    public void after() {
        try {
            this.stop(true);
        }
        catch (InterruptedException e) {
            logger.info("Shutdown error", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            logger.info("Shutdown error", (Throwable)e);
        }
    }

    public void before() throws Throwable {
        this.init(this.portToUse);
    }

    public static TcpHexDumper runOn(int port) throws IOException, InterruptedException {
        TcpHexDumper tcpHexDumper = new TcpHexDumper(port);
        tcpHexDumper.init(port);
        return tcpHexDumper;
    }

    public Integer getPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stop();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }
}

